/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFUnixTimeStampDate;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFUnixTimeStampString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFUnixTimeStampTimestamp;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampLocalTZObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.io.LongWritable;

@Description(name="to_unix_timestamp", value="_FUNC_(date[, pattern]) - Returns the UNIX timestamp", extended="Converts the specified time to number of seconds since 1970-01-01.")
@VectorizedExpressions(value={VectorUDFUnixTimeStampDate.class, VectorUDFUnixTimeStampString.class, VectorUDFUnixTimeStampTimestamp.class})
public class GenericUDFToUnixTimeStamp
extends GenericUDF {
    private transient DateObjectInspector inputDateOI;
    private transient TimestampObjectInspector inputTimestampOI;
    private transient TimestampLocalTZObjectInspector inputTimestampLocalTzOI;
    private transient ObjectInspectorConverters.Converter inputTextConverter;
    private transient ObjectInspectorConverters.Converter patternConverter;
    private transient ZoneId timeZone;
    private transient String lasPattern = "yyyy-MM-dd HH:mm:ss";
    private final transient SimpleDateFormat formatter = new SimpleDateFormat(this.lasPattern);
    protected final transient LongWritable retValue = new LongWritable();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.initializeInput(arguments);
        return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
    }

    protected void initializeInput(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 1) {
            throw new UDFArgumentLengthException("The function " + this.getName().toUpperCase() + "requires at least one argument");
        }
        for (ObjectInspector argument : arguments) {
            if (argument.getCategory() == ObjectInspector.Category.PRIMITIVE) continue;
            throw new UDFArgumentException(this.getName().toUpperCase() + " only takes string/date/timestamp types, got " + argument.getTypeName());
        }
        PrimitiveObjectInspector arg1OI = (PrimitiveObjectInspector)arguments[0];
        switch (arg1OI.getPrimitiveCategory()) {
            case CHAR: 
            case VARCHAR: 
            case STRING: {
                this.inputTextConverter = ObjectInspectorConverters.getConverter((ObjectInspector)arg1OI, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
                if (arguments.length <= 1) break;
                PrimitiveObjectInspector arg2OI = (PrimitiveObjectInspector)arguments[1];
                if (PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)arg2OI.getPrimitiveCategory()) != PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP) {
                    throw new UDFArgumentException("The time pattern for " + this.getName().toUpperCase() + " should be string type");
                }
                this.patternConverter = ObjectInspectorConverters.getConverter((ObjectInspector)arg2OI, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
                break;
            }
            case DATE: {
                this.inputDateOI = (DateObjectInspector)arguments[0];
                break;
            }
            case TIMESTAMP: {
                this.inputTimestampOI = (TimestampObjectInspector)arguments[0];
                break;
            }
            case TIMESTAMPLOCALTZ: {
                this.inputTimestampLocalTzOI = (TimestampLocalTZObjectInspector)arguments[0];
                break;
            }
            default: {
                throw new UDFArgumentException("The function " + this.getName().toUpperCase() + " takes only string/date/timestamp/timestampwltz types. Got Type:" + arg1OI.getPrimitiveCategory().name());
            }
        }
        if (this.timeZone == null) {
            this.timeZone = SessionState.get() == null ? new HiveConf().getLocalTimeZone() : SessionState.get().getConf().getLocalTimeZone();
            this.formatter.setTimeZone(TimeZone.getTimeZone(this.timeZone));
        }
    }

    @Override
    public void configure(MapredContext context) {
        if (context != null) {
            String timeZoneStr = HiveConf.getVar((Configuration)context.getJobConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_LOCAL_TIME_ZONE);
            this.timeZone = TimestampTZUtil.parseTimeZone((String)timeZoneStr);
            this.formatter.setTimeZone(TimeZone.getTimeZone(this.timeZone));
        }
    }

    protected String getName() {
        return "to_unix_timestamp";
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments[0].get() == null) {
            return null;
        }
        if (this.inputTextConverter != null) {
            String textVal = (String)this.inputTextConverter.convert(arguments[0].get());
            if (textVal == null) {
                return null;
            }
            if (this.patternConverter != null) {
                if (arguments[1].get() == null) {
                    return null;
                }
                String patternVal = (String)this.patternConverter.convert(arguments[1].get());
                if (patternVal == null) {
                    return null;
                }
                if (!patternVal.equals(this.lasPattern)) {
                    this.formatter.applyPattern(patternVal);
                    this.lasPattern = patternVal;
                }
            }
            try {
                this.retValue.set(this.formatter.parse(textVal).getTime() / 1000L);
            }
            catch (ParseException e) {
                return null;
            }
        } else if (this.inputDateOI != null) {
            TimestampTZ timestampTZ = TimestampTZUtil.convert((Date)this.inputDateOI.getPrimitiveJavaObject(arguments[0].get()), (ZoneId)this.timeZone);
            this.retValue.set(timestampTZ.getEpochSecond());
        } else if (this.inputTimestampOI != null) {
            TimestampTZ timestampTZ = TimestampTZUtil.convert((Timestamp)this.inputTimestampOI.getPrimitiveJavaObject(arguments[0].get()), (ZoneId)this.timeZone);
            this.retValue.set(timestampTZ.getEpochSecond());
        } else {
            TimestampTZ timestampTZ = this.inputTimestampLocalTzOI.getPrimitiveJavaObject(arguments[0].get());
            this.retValue.set(timestampTZ.getEpochSecond());
        }
        return this.retValue;
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder(32);
        sb.append(this.getName());
        sb.append('(');
        sb.append(StringUtils.join((Object[])children, (char)','));
        sb.append(')');
        return sb.toString();
    }
}

