/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToDate;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToDate;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableDateObjectInspector;

@Description(name="date", value="CAST(<Date string> as DATE) - Returns the date represented by the date string.", extended="date_string is a string in the format 'yyyy-MM-dd.'Example:\n   > SELECT CAST('2009-01-01' AS DATE) FROM src LIMIT 1;\n  '2009-01-01'")
@VectorizedExpressions(value={CastStringToDate.class, CastTimestampToDate.class})
public class GenericUDFToDate
extends GenericUDF {
    private transient PrimitiveObjectInspector argumentOI;
    private transient PrimitiveObjectInspectorConverter.DateConverter dc;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 1) {
            throw new UDFArgumentLengthException("The function CAST as DATE requires at least one argument, got " + arguments.length);
        }
        try {
            this.argumentOI = (PrimitiveObjectInspector)arguments[0];
            PrimitiveObjectInspector.PrimitiveCategory pc = this.argumentOI.getPrimitiveCategory();
            PrimitiveObjectInspectorUtils.PrimitiveGrouping pg = PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)pc);
            switch (pg) {
                case DATE_GROUP: 
                case STRING_GROUP: 
                case VOID_GROUP: {
                    break;
                }
                default: {
                    throw new UDFArgumentException("CAST as DATE only allows date,string, or timestamp types");
                }
            }
        }
        catch (ClassCastException e) {
            throw new UDFArgumentException("The function CAST as DATE takes only primitive types");
        }
        this.dc = new PrimitiveObjectInspectorConverter.DateConverter(this.argumentOI, (SettableDateObjectInspector)PrimitiveObjectInspectorFactory.writableDateObjectInspector);
        return PrimitiveObjectInspectorFactory.writableDateObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object o0 = arguments[0].get();
        if (o0 == null) {
            return null;
        }
        return this.dc.convert(o0);
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 1);
        StringBuilder sb = new StringBuilder();
        sb.append("CAST( ");
        sb.append(children[0]);
        sb.append(" AS DATE)");
        return sb.toString();
    }
}

