/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDateToTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDoubleToTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastLongToTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToTimestamp;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableTimestampObjectInspector;

@Description(name="timestamp", value="cast(date as timestamp) - Returns timestamp")
@VectorizedExpressions(value={CastLongToTimestamp.class, CastDateToTimestamp.class, CastDoubleToTimestamp.class, CastDecimalToTimestamp.class, CastStringToTimestamp.class})
public class GenericUDFTimestamp
extends GenericUDF {
    private transient PrimitiveObjectInspector argumentOI;
    private transient PrimitiveObjectInspectorConverter.TimestampConverter tc;
    private boolean intToTimestampInSeconds = false;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        PrimitiveObjectInspector.PrimitiveCategory category;
        PrimitiveObjectInspectorUtils.PrimitiveGrouping group;
        if (arguments.length < 1) {
            throw new UDFArgumentLengthException("The function TIMESTAMP requires at least one argument, got " + arguments.length);
        }
        SessionState ss = SessionState.get();
        if (ss != null) {
            this.intToTimestampInSeconds = ss.getConf().getBoolVar(HiveConf.ConfVars.HIVE_INT_TIMESTAMP_CONVERSION_IN_SECONDS);
        }
        try {
            this.argumentOI = (PrimitiveObjectInspector)arguments[0];
        }
        catch (ClassCastException e) {
            throw new UDFArgumentException("The function TIMESTAMP takes only primitive types");
        }
        if (ss != null && ss.getConf().getBoolVar(HiveConf.ConfVars.HIVE_STRICT_TIMESTAMP_CONVERSION) && (group = PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)(category = this.argumentOI.getPrimitiveCategory()))) == PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP) {
            throw new UDFArgumentException("Casting NUMERIC types to TIMESTAMP is prohibited (" + HiveConf.ConfVars.HIVE_STRICT_TIMESTAMP_CONVERSION + ")");
        }
        this.tc = new PrimitiveObjectInspectorConverter.TimestampConverter(this.argumentOI, (SettableTimestampObjectInspector)PrimitiveObjectInspectorFactory.writableTimestampObjectInspector);
        this.tc.setIntToTimestampInSeconds(this.intToTimestampInSeconds);
        return PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object o0 = arguments[0].get();
        if (o0 == null) {
            return null;
        }
        return this.tc.convert(o0);
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 1);
        StringBuilder sb = new StringBuilder();
        sb.append("CAST( ");
        sb.append(children[0]);
        sb.append(" AS TIMESTAMP)");
        return sb.toString();
    }

    public boolean isIntToTimestampInSeconds() {
        return this.intToTimestampInSeconds;
    }
}

