/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;

@Description(name="quote", value="_FUNC_() - Returns the Quoted stringExample:\n   > SELECT _FUNC_('Don't') FROM src LIMIT 1;\n  'Don't'\n Including Single quotes\n")
public class GenericUDFQuote
extends GenericUDF {
    private transient PrimitiveObjectInspectorConverter.TextConverter converter;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentException("QUOTE() requires one value argument. Found :" + arguments.length);
        }
        if (!(arguments[0] instanceof PrimitiveObjectInspector)) {
            throw new UDFArgumentException("QUOTE() takes only primitive types. Found " + arguments[0].getTypeName());
        }
        PrimitiveObjectInspector argumentOI = (PrimitiveObjectInspector)arguments[0];
        this.converter = new PrimitiveObjectInspectorConverter.TextConverter(argumentOI);
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }

    public Text evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        String qtChar = "'";
        String qtCharRep = "\\\\'";
        Object valObject = arguments[0].get();
        if (valObject == null) {
            return null;
        }
        String val = this.converter.convert(valObject).toString();
        String sp = val.replaceAll("'", "\\\\'");
        sp = "'" + sp + "'";
        return new Text(sp);
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("quote", children);
    }
}

