/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;

@Description(name="from_unixtime", value="_FUNC_(unix_time, format) - returns unix_time in the specified format", extended="Example:\n  > SELECT _FUNC_(0, 'yyyy-MM-dd HH:mm:ss') FROM src LIMIT 1;\n  '1970-01-01 00:00:00'")
public class GenericUDFFromUnixTime
extends GenericUDF {
    private transient IntObjectInspector inputIntOI;
    private transient LongObjectInspector inputLongOI;
    private transient ObjectInspectorConverters.Converter inputTextConverter;
    private transient ZoneId timeZone;
    private final transient Text result = new Text();
    private transient SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private transient String lastFormat = null;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 1) {
            throw new UDFArgumentLengthException("The function " + this.getName().toUpperCase() + "requires at least one argument");
        }
        if (arguments.length > 2) {
            throw new UDFArgumentLengthException("Too many arguments for the function " + this.getName().toUpperCase());
        }
        for (ObjectInspector argument : arguments) {
            if (argument.getCategory() == ObjectInspector.Category.PRIMITIVE) continue;
            throw new UDFArgumentException(this.getName().toUpperCase() + " only takes primitive types, got " + argument.getTypeName());
        }
        PrimitiveObjectInspector arg0OI = (PrimitiveObjectInspector)arguments[0];
        switch (arg0OI.getPrimitiveCategory()) {
            case INT: {
                this.inputIntOI = (IntObjectInspector)arguments[0];
                break;
            }
            case LONG: {
                this.inputLongOI = (LongObjectInspector)arguments[0];
                break;
            }
            default: {
                throw new UDFArgumentException("The function " + this.getName().toUpperCase() + " takes only int/long types for first argument. Got Type:" + arg0OI.getPrimitiveCategory().name());
            }
        }
        if (arguments.length == 2) {
            PrimitiveObjectInspector arg1OI = (PrimitiveObjectInspector)arguments[1];
            switch (arg1OI.getPrimitiveCategory()) {
                case CHAR: 
                case VARCHAR: 
                case STRING: {
                    this.inputTextConverter = ObjectInspectorConverters.getConverter((ObjectInspector)arg1OI, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
                    break;
                }
                default: {
                    throw new UDFArgumentException("The function " + this.getName().toUpperCase() + " takes only string type for second argument. Got Type:" + arg1OI.getPrimitiveCategory().name());
                }
            }
        }
        if (this.timeZone == null) {
            this.timeZone = SessionState.get() == null ? new HiveConf().getLocalTimeZone() : SessionState.get().getConf().getLocalTimeZone();
            this.formatter.setTimeZone(TimeZone.getTimeZone(this.timeZone));
        }
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }

    @Override
    public void configure(MapredContext context) {
        if (context != null) {
            String timeZoneStr = HiveConf.getVar((Configuration)context.getJobConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_LOCAL_TIME_ZONE);
            this.timeZone = TimestampTZUtil.parseTimeZone((String)timeZoneStr);
            this.formatter.setTimeZone(TimeZone.getTimeZone(this.timeZone));
        }
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments[0].get() == null) {
            return null;
        }
        if (this.inputTextConverter != null) {
            if (arguments[1].get() == null) {
                return null;
            }
            String format = (String)this.inputTextConverter.convert(arguments[1].get());
            if (format == null) {
                return null;
            }
            if (!format.equals(this.lastFormat)) {
                this.formatter = new SimpleDateFormat(format);
                this.formatter.setTimeZone(TimeZone.getTimeZone(this.timeZone));
                this.lastFormat = format;
            }
        }
        long unixtime = this.inputIntOI != null ? (long)this.inputIntOI.get(arguments[0].get()) : this.inputLongOI.get(arguments[0].get());
        Date date = new Date(unixtime * 1000L);
        this.result.set(this.formatter.format(date));
        return this.result;
    }

    protected String getName() {
        return "from_unixtime";
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder(32);
        sb.append(this.getName());
        sb.append('(');
        sb.append(StringUtils.join((Object[])children, (String)", "));
        sb.append(')');
        return sb.toString();
    }
}

