/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.util.DateTimeMath;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.Text;

@Description(name="date_format", value="_FUNC_(date/timestamp/string, fmt) - converts a date/timestamp/string to a value of string in the format specified by the date format fmt.", extended="Supported formats are SimpleDateFormat formats - https://docs.oracle.com/javase/7/docs/api/java/text/SimpleDateFormat.html. Second argument fmt should be constant.\nExample: > SELECT _FUNC_('2015-04-08', 'y');\n '2015'")
public class GenericUDFDateFormat
extends GenericUDF {
    private transient ObjectInspectorConverters.Converter[] tsConverters = new ObjectInspectorConverters.Converter[2];
    private transient PrimitiveObjectInspector.PrimitiveCategory[] tsInputTypes = new PrimitiveObjectInspector.PrimitiveCategory[2];
    private transient ObjectInspectorConverters.Converter[] dtConverters = new ObjectInspectorConverters.Converter[2];
    private transient PrimitiveObjectInspector.PrimitiveCategory[] dtInputTypes = new PrimitiveObjectInspector.PrimitiveCategory[2];
    private final Date date = new Date();
    private final Text output = new Text();
    private transient SimpleDateFormat formatter;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkArgsSize(arguments, 2, 2);
        this.checkArgPrimitive(arguments, 0);
        this.checkArgPrimitive(arguments, 1);
        this.checkArgGroups(arguments, 0, this.tsInputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP);
        this.checkArgGroups(arguments, 0, this.dtInputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP);
        this.checkArgGroups(arguments, 1, this.tsInputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP);
        this.obtainTimestampConverter(arguments, 0, this.tsInputTypes, this.tsConverters);
        this.obtainDateConverter(arguments, 0, this.dtInputTypes, this.dtConverters);
        if (arguments[1] instanceof ConstantObjectInspector) {
            String fmtStr = this.getConstantStringValue(arguments, 1);
            if (fmtStr != null) {
                try {
                    this.formatter = new SimpleDateFormat(fmtStr);
                    this.formatter.setCalendar(DateTimeMath.getProlepticGregorianCalendarUTC());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        } else {
            throw new UDFArgumentTypeException(1, this.getFuncName() + " only takes constant as " + this.getArgOrder(1) + " argument");
        }
        WritableStringObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (this.formatter == null) {
            return null;
        }
        Timestamp ts = this.getTimestampValue(arguments, 0, this.tsConverters);
        if (ts == null) {
            org.apache.hadoop.hive.common.type.Date d = this.getDateValue(arguments, 0, this.dtInputTypes, this.dtConverters);
            if (d == null) {
                return null;
            }
            ts = Timestamp.ofEpochMilli((long)d.toEpochMilli());
        }
        this.date.setTime(ts.toEpochMilli());
        String res = this.formatter.format(this.date);
        if (res == null) {
            return null;
        }
        this.output.set(res);
        return this.output;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(this.getFuncName(), children);
    }

    @Override
    protected String getFuncName() {
        return "date_format";
    }
}

