/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.mapjoin.MapJoinMemoryExhaustionError;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BooleanWritable;

@UDFType(deterministic=false)
@Description(name="assert_true_oom", value="_FUNC_(condition) - Throw an MapJoinMemoryExhaustionError if 'condition' is not true.")
public class GenericUDFAssertTrueOOM
extends GenericUDF {
    private ObjectInspectorConverters.Converter conditionConverter = null;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        HiveConf conf = SessionState.getSessionConf();
        if (!conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST)) {
            throw new RuntimeException("this UDF is only available in testmode");
        }
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("ASSERT_TRUE_OOM() expects one argument.");
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Argument to ASSERT_TRUE_OOM() should be primitive.");
        }
        this.conditionConverter = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[0], (ObjectInspector)PrimitiveObjectInspectorFactory.writableBooleanObjectInspector);
        return PrimitiveObjectInspectorFactory.writableVoidObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        BooleanWritable condition = (BooleanWritable)this.conditionConverter.convert(arguments[0].get());
        if (condition == null || !condition.get()) {
            throw new MapJoinMemoryExhaustionError("assert_true_oom: assertation failed; Simulated OOM");
        }
        return null;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("assert_true_oom", children);
    }
}

