/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.WindowFunctionDescription;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFStreamingEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="last_value", value="_FUNC_(x)")
@WindowFunctionDescription(supportsWindow=true, pivotResult=false, impliesOrder=true)
public class GenericUDAFLastValue
extends AbstractGenericUDAFResolver {
    static final Logger LOG = LoggerFactory.getLogger((String)GenericUDAFLastValue.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length > 2) {
            throw new UDFArgumentTypeException(2, "At most 2 arguments expected");
        }
        if (parameters.length > 1 && !parameters[1].equals((Object)TypeInfoFactory.booleanTypeInfo)) {
            throw new UDFArgumentTypeException(1, "second argument must be a boolean expression");
        }
        return this.createEvaluator();
    }

    protected GenericUDAFLastValueEvaluator createEvaluator() {
        return new GenericUDAFLastValueEvaluator();
    }

    static class LastValStreamingFixedWindow
    extends GenericUDAFStreamingEvaluator<Object> {
        public LastValStreamingFixedWindow(GenericUDAFEvaluator wrappedEval, WindowFrameDef wFrameDef) {
            super(wrappedEval, wFrameDef);
        }

        @Override
        public int getRowsRemainingAfterTerminate() throws HiveException {
            throw new UnsupportedOperationException();
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            GenericUDAFEvaluator.AggregationBuffer underlying = this.wrappedEval.getNewAggregationBuffer();
            return new State(underlying);
        }

        protected ObjectInspector inputOI() {
            return ((GenericUDAFLastValueEvaluator)this.wrappedEval).inputOI;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            State s = (State)agg;
            LastValueBuffer lb = (LastValueBuffer)s.wrappedBuf;
            if (lb.firstRow) {
                this.wrappedEval.iterate(lb, parameters);
                for (int i = this.wFrameDef.getEnd().getRelativeOffset(); i < 0; ++i) {
                    s.results.add(null);
                }
            }
            Object o = ObjectInspectorUtils.copyToStandardObject((Object)parameters[0], (ObjectInspector)this.inputOI(), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            if (!lb.skipNulls || o != null) {
                s.lastValue = o;
                s.lastIdx = s.numRows;
            } else if (lb.skipNulls && s.lastIdx != -1 && !this.wFrameDef.isStartUnbounded() && s.numRows >= s.lastIdx + this.wFrameDef.getWindowSize()) {
                s.lastValue = null;
                s.lastIdx = -1;
            }
            if (s.numRows >= this.wFrameDef.getEnd().getRelativeOffset()) {
                s.results.add(s.lastValue);
            }
            ++s.numRows;
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            int i;
            State s = (State)agg;
            LastValueBuffer lb = (LastValueBuffer)s.wrappedBuf;
            if (lb.skipNulls && s.lastIdx != -1 && !this.wFrameDef.isStartUnbounded() && s.numRows >= s.lastIdx + this.wFrameDef.getWindowSize()) {
                s.lastValue = null;
                s.lastIdx = -1;
            }
            for (i = Math.max(0, this.wFrameDef.getStart().getRelativeOffset()); i < this.wFrameDef.getEnd().getRelativeOffset(); ++i) {
                if (s.hasResultReady()) {
                    s.results.add(s.lastValue);
                }
                ++s.numRows;
            }
            for (i = 0; i < this.wFrameDef.getStart().getRelativeOffset(); ++i) {
                if (s.hasResultReady()) {
                    s.results.add(null);
                }
                ++s.numRows;
            }
            return null;
        }

        class State
        extends GenericUDAFStreamingEvaluator.StreamingState {
            private Object lastValue;
            private int lastIdx;

            public State(GenericUDAFEvaluator.AggregationBuffer buf) {
                super(LastValStreamingFixedWindow.this, buf);
                this.lastValue = null;
                this.lastIdx = -1;
            }

            @Override
            public int estimate() {
                if (!(this.wrappedBuf instanceof GenericUDAFEvaluator.AbstractAggregationBuffer)) {
                    return -1;
                }
                int underlying = ((GenericUDAFEvaluator.AbstractAggregationBuffer)this.wrappedBuf).estimate();
                if (underlying == -1) {
                    return -1;
                }
                return 2 * underlying;
            }

            @Override
            protected void reset() {
                this.lastValue = null;
                this.lastIdx = -1;
                super.reset();
            }
        }
    }

    public static class GenericUDAFLastValueEvaluator
    extends GenericUDAFEvaluator {
        ObjectInspector inputOI;
        ObjectInspector outputOI;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (m != GenericUDAFEvaluator.Mode.COMPLETE) {
                throw new HiveException("Only COMPLETE mode supported for Rank function");
            }
            this.inputOI = parameters[0];
            this.outputOI = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.inputOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            return this.outputOI;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            return new LastValueBuffer();
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((LastValueBuffer)agg).init();
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            LastValueBuffer lb = (LastValueBuffer)agg;
            if (lb.firstRow) {
                lb.firstRow = false;
                if (parameters.length == 2) {
                    lb.skipNulls = PrimitiveObjectInspectorUtils.getBoolean((Object)parameters[1], (PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.writableBooleanObjectInspector);
                }
            }
            Object o = ObjectInspectorUtils.copyToStandardObject((Object)parameters[0], (ObjectInspector)this.inputOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            if (!lb.skipNulls || o != null) {
                lb.val = o;
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            throw new HiveException("terminatePartial not supported");
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            throw new HiveException("merge not supported");
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            LastValueBuffer lb = (LastValueBuffer)agg;
            return lb.val;
        }

        @Override
        public GenericUDAFEvaluator getWindowingEvaluator(WindowFrameDef wFrmDef) {
            return new LastValStreamingFixedWindow(this, wFrmDef);
        }
    }

    static class LastValueBuffer
    implements GenericUDAFEvaluator.AggregationBuffer {
        Object val;
        boolean firstRow;
        boolean skipNulls;

        LastValueBuffer() {
            this.init();
        }

        void init() {
            this.val = null;
            this.firstRow = true;
            this.skipNulls = false;
        }
    }
}

