/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.UDFMethodResolver;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastLongToDouble;
import org.apache.hadoop.hive.ql.udf.TimestampCastRestrictorResolver;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;

@VectorizedExpressions(value={CastTimestampToDouble.class, CastLongToDouble.class, CastDecimalToDouble.class, CastStringToDouble.class})
@Description(name="double", value="_FUNC_(x) - converts it's parameter to _FUNC_", extended="- x is NULL -> NULL\n- byte, short, integer, long, float, double, decimal, timestamp:\n  x fits into the type _FUNC_ -> x\n  undefined otherwise\n- boolean:\n  true  -> 1.0\n  false -> 0.0\n- string:\n  x is a valid _FUNC_ -> x\n  NULL otherwise\nExample:\n   > SELECT _FUNC_(true);\n  1")
public class UDFToDouble
extends UDF {
    private final DoubleWritable doubleWritable = new DoubleWritable();

    public UDFMethodResolver getResolver() {
        return new TimestampCastRestrictorResolver(super.getResolver());
    }

    public DoubleWritable evaluate(NullWritable i) {
        return null;
    }

    public DoubleWritable evaluate(BooleanWritable i) {
        if (i == null) {
            return null;
        }
        this.doubleWritable.set(i.get() ? 1.0 : 0.0);
        return this.doubleWritable;
    }

    public DoubleWritable evaluate(ByteWritable i) {
        if (i == null) {
            return null;
        }
        this.doubleWritable.set((double)i.get());
        return this.doubleWritable;
    }

    public DoubleWritable evaluate(ShortWritable i) {
        if (i == null) {
            return null;
        }
        this.doubleWritable.set((double)i.get());
        return this.doubleWritable;
    }

    public DoubleWritable evaluate(IntWritable i) {
        if (i == null) {
            return null;
        }
        this.doubleWritable.set((double)i.get());
        return this.doubleWritable;
    }

    public DoubleWritable evaluate(LongWritable i) {
        if (i == null) {
            return null;
        }
        this.doubleWritable.set((double)i.get());
        return this.doubleWritable;
    }

    public DoubleWritable evaluate(FloatWritable i) {
        if (i == null) {
            return null;
        }
        this.doubleWritable.set((double)i.get());
        return this.doubleWritable;
    }

    public DoubleWritable evaluate(Text i) {
        if (i == null) {
            return null;
        }
        if (!LazyUtils.isNumberMaybe((byte[])i.getBytes(), (int)0, (int)i.getLength())) {
            return null;
        }
        try {
            this.doubleWritable.set(Double.parseDouble(i.toString()));
            return this.doubleWritable;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public DoubleWritable evaluate(TimestampWritableV2 i) {
        if (i == null) {
            return null;
        }
        try {
            this.doubleWritable.set(i.getDouble());
            return this.doubleWritable;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public DoubleWritable evaluate(HiveDecimalWritable i) {
        if (i == null || !i.isSet()) {
            return null;
        }
        this.doubleWritable.set(i.doubleValue());
        return this.doubleWritable;
    }
}

