/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidCompactorWriteIdList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreUtils;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreThread;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.OptionalCompactionInfoStruct;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.io.AcidDirectory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorMR;
import org.apache.hadoop.hive.ql.txn.compactor.QueryCompactor;
import org.apache.hadoop.hive.ql.txn.compactor.QueryCompactorFactory;
import org.apache.hadoop.hive.ql.txn.compactor.RemoteCompactorThread;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.common.util.Ref;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Worker
extends RemoteCompactorThread
implements MetaStoreThread {
    private static final String CLASS_NAME = Worker.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private static final long SLEEP_TIME = 10000L;
    private String workerName;

    public static String hostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Unable to resolve my host name " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.info("Starting Worker thread");
        boolean computeStats = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_MR_COMPACTOR_GATHER_STATS);
        long timeout = this.conf.getTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_WORKER_TIMEOUT, TimeUnit.MILLISECONDS);
        ExecutorService executor = this.getTimeoutHandlingExecutor();
        try {
            do {
                boolean launchedJob;
                Future<Boolean> singleRun = executor.submit(() -> this.findNextCompactionAndExecute(computeStats));
                try {
                    launchedJob = singleRun.get(timeout, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException te) {
                    LOG.info("Timeout during executing compaction", (Throwable)te);
                    singleRun.cancel(true);
                    executor.shutdownNow();
                    executor = this.getTimeoutHandlingExecutor();
                    launchedJob = true;
                }
                catch (ExecutionException e) {
                    LOG.info("Exception during executing compaction", (Throwable)e);
                    launchedJob = true;
                }
                catch (InterruptedException ie) {
                    launchedJob = true;
                }
                if (!launchedJob && !this.stop.get()) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                LOG.info("Worker thread finished one loop.");
            } while (!this.stop.get());
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
            if (this.msc != null) {
                this.msc.close();
            }
        }
    }

    private void verifyTableIdHasNotChanged(CompactionInfo ci, Table originalTable) throws HiveException, MetaException {
        Table currentTable = this.resolveTable(ci);
        if (originalTable.getId() != currentTable.getId()) {
            throw new HiveException("Table " + originalTable.getDbName() + "." + originalTable.getTableName() + " id (" + currentTable.getId() + ") is not equal to its id when compaction started (" + originalTable.getId() + "). The table might have been dropped and recreated while compaction was running. Marking compaction as failed.");
        }
    }

    @Override
    public void init(AtomicBoolean stop) throws Exception {
        super.init(stop);
        StringBuilder name = new StringBuilder(Worker.hostname());
        name.append("-");
        name.append(this.getId());
        this.workerName = name.toString();
        this.setName(name.toString());
    }

    static boolean isEnoughToCompact(boolean isMajorCompaction, AcidDirectory dir, StorageDescriptor sd) {
        boolean isEnoughToCompact;
        int deltaCount = dir.getCurrentDirectories().size();
        int origCount = dir.getOriginalFiles().size();
        StringBuilder deltaInfo = new StringBuilder().append(deltaCount);
        if (isMajorCompaction) {
            isEnoughToCompact = origCount > 0 || deltaCount + (dir.getBaseDirectory() == null ? 0 : 1) > 1;
        } else {
            boolean bl = isEnoughToCompact = deltaCount > 1;
            if (deltaCount == 2) {
                Map<String, Long> deltaByType = dir.getCurrentDirectories().stream().collect(Collectors.groupingBy(delta -> delta.isDeleteDelta() ? "delete_delta_" : "delta_", Collectors.counting()));
                isEnoughToCompact = deltaByType.size() != deltaCount;
                deltaInfo.append(" ").append(deltaByType);
            }
        }
        if (!isEnoughToCompact) {
            LOG.info("Not enough files in {} to compact; current base: {}, delta files: {}, originals: {}", new Object[]{sd.getLocation(), dir.getBaseDirectory(), deltaInfo, origCount});
        }
        return isEnoughToCompact;
    }

    public static boolean needsCleaning(AcidDirectory dir, StorageDescriptor sd) {
        boolean needsJustCleaning;
        int numObsoleteDirs = dir.getObsolete().size() + dir.getAbortedDirectories().size();
        boolean bl = needsJustCleaning = numObsoleteDirs > 0;
        if (needsJustCleaning) {
            LOG.info("{} obsolete directories in {} found; marked for cleaning.", (Object)numObsoleteDirs, (Object)sd.getLocation());
        }
        return needsJustCleaning;
    }

    private ExecutorService getTimeoutHandlingExecutor() {
        return Executors.newSingleThreadExecutor(r -> {
            Thread masterThread = Thread.currentThread();
            Thread t = new Thread(masterThread.getThreadGroup(), r, masterThread.getName() + "_timeout_executor");
            t.setDaemon(masterThread.isDaemon());
            t.setPriority(masterThread.getPriority());
            return t;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    protected Boolean findNextCompactionAndExecute(boolean computeStats) throws InterruptedException {
        CompactionHeartbeater heartbeater = null;
        CompactionInfo ci = null;
        try (CompactionTxn compactionTxn = new CompactionTxn();){
            Partition p;
            Table t1;
            if (this.msc == null) {
                try {
                    this.msc = HiveMetaStoreUtils.getHiveMetastoreClient((HiveConf)this.conf);
                }
                catch (Exception e) {
                    LOG.error("Failed to connect to HMS", (Throwable)e);
                    Boolean bl = false;
                    if (compactionTxn != null) {
                        if (var5_7 != null) {
                            try {
                                compactionTxn.close();
                            }
                            catch (Throwable throwable) {
                                var5_7.addSuppressed(throwable);
                            }
                        } else {
                            compactionTxn.close();
                        }
                    }
                    if (heartbeater == null) return bl;
                    heartbeater.cancel();
                    return bl;
                }
            }
            ci = CompactionInfo.optionalCompactionInfoStructToInfo((OptionalCompactionInfoStruct)this.msc.findNextCompact(this.workerName));
            LOG.debug("Processing compaction request " + ci);
            if (ci == null) {
                Boolean e = false;
                return e;
            }
            this.checkInterrupt();
            try {
                t1 = this.resolveTable(ci);
                if (t1 == null) {
                    LOG.info("Unable to find table " + ci.getFullTableName() + ", assuming it was dropped and moving on.");
                    this.msc.markCleaned(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
                    Boolean bl = false;
                    return bl;
                }
            }
            catch (MetaException e) {
                this.msc.markCleaned(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
                Boolean bl = false;
                return bl;
            }
            this.checkInterrupt();
            Table t = t1;
            String fullTableName = TxnUtils.getFullTableName((String)t.getDbName(), (String)t.getTableName());
            try {
                p = this.resolvePartition(ci);
                if (p == null && ci.partName != null) {
                    LOG.info("Unable to find partition " + ci.getFullPartitionName() + ", assuming it was dropped and moving on.");
                    this.msc.markCleaned(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
                    Boolean bl = false;
                    return bl;
                }
            }
            catch (Exception e) {
                this.msc.markCleaned(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
                Boolean bl = false;
                return bl;
            }
            this.checkInterrupt();
            StorageDescriptor sd = this.resolveStorageDescriptor(t, p);
            if (sd.getSortCols() != null && !sd.getSortCols().isEmpty()) {
                LOG.error("Attempt to compact sorted table " + ci.getFullTableName() + ", which is not yet supported!");
                this.msc.markCleaned(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
                Boolean bl = false;
                return bl;
            }
            if (ci.runAs == null) {
                ci.runAs = this.findUserToRunAs(sd.getLocation(), t);
            }
            this.checkInterrupt();
            compactionTxn.open(ci);
            heartbeater = new CompactionHeartbeater(compactionTxn, fullTableName, this.conf);
            heartbeater.start();
            ValidTxnList validTxnList = this.msc.getValidTxns(compactionTxn.getTxnId());
            ValidCompactorWriteIdList tblValidWriteIds = TxnUtils.createValidCompactWriteIdList((TableValidWriteIds)((TableValidWriteIds)this.msc.getValidWriteIds(Collections.singletonList(fullTableName), validTxnList.writeToString()).get(0)));
            LOG.debug("ValidCompactWriteIdList: " + tblValidWriteIds.writeToString());
            this.conf.set("hive.txn.valid.txns", validTxnList.writeToString());
            ci.highestWriteId = tblValidWriteIds.getHighWatermark();
            this.msc.updateCompactorState(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci), compactionTxn.getTxnId());
            this.checkInterrupt();
            StringBuilder jobName = new StringBuilder(this.workerName);
            jobName.append("-compactor-");
            jobName.append(ci.getFullPartitionName());
            if (Worker.isDynPartAbort(t, ci)) {
                this.msc.markCompacted(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
                compactionTxn.wasSuccessful();
                Boolean bl = false;
                return bl;
            }
            AcidDirectory dir = this.getAcidStateForWorker(ci, sd, tblValidWriteIds);
            if (!Worker.isEnoughToCompact(ci.isMajorCompaction(), dir, sd)) {
                if (Worker.needsCleaning(dir, sd)) {
                    this.msc.markCompacted(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
                } else {
                    this.msc.markCleaned(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
                }
                compactionTxn.wasSuccessful();
                Boolean bl = false;
                return bl;
            }
            this.checkInterrupt();
            LOG.info("Starting " + ci.type.toString() + " compaction for " + ci.getFullPartitionName() + " in " + compactionTxn + " with compute stats set to " + computeStats);
            StatsUpdater su = computeStats ? StatsUpdater.init(ci, this.msc.findColumnsWithStats(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci)), this.conf, this.runJobAsSelf(ci.runAs) ? ci.runAs : t.getOwner()) : null;
            try {
                this.failCompactionIfSetForTest();
                QueryCompactor queryCompactor = QueryCompactorFactory.getQueryCompactor(t, this.conf, ci);
                if (queryCompactor != null) {
                    LOG.info("Will compact id: " + ci.id + " with query-based compactor class: " + queryCompactor.getClass().getName());
                    queryCompactor.runCompaction(this.conf, t, p, sd, (ValidWriteIdList)tblValidWriteIds, ci, dir);
                } else {
                    LOG.info("Will compact id: " + ci.id + " via MR job");
                    this.runCompactionViaMrJob(ci, t, p, sd, tblValidWriteIds, jobName, dir, su);
                }
                heartbeater.cancel();
                this.verifyTableIdHasNotChanged(ci, t1);
                LOG.info("Completed " + ci.type.toString() + " compaction for " + ci.getFullPartitionName() + " in " + compactionTxn + ", marking as compacted.");
                this.msc.markCompacted(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
                compactionTxn.wasSuccessful();
                return true;
            }
            catch (Throwable e) {
                LOG.error("Caught exception while trying to compact " + ci + ".  Marking failed to avoid repeated failures", e);
                this.markFailed(ci, e);
                return true;
            }
        }
        catch (IOException | TException t) {
            LOG.error("Caught an exception in the main loop of compactor worker " + this.workerName, t);
            this.markFailed(ci, t);
            if (this.msc == null) return true;
            this.msc.close();
            this.msc = null;
            return true;
        }
        catch (Throwable t) {
            LOG.error("Caught an exception in the main loop of compactor worker " + this.workerName, t);
            return true;
        }
        finally {
            if (heartbeater != null) {
                heartbeater.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AcidDirectory getAcidStateForWorker(CompactionInfo ci, StorageDescriptor sd, ValidCompactorWriteIdList tblValidWriteIds) throws IOException, InterruptedException {
        if (this.runJobAsSelf(ci.runAs)) {
            return AcidUtils.getAcidState(null, new Path(sd.getLocation()), (Configuration)this.conf, (ValidWriteIdList)tblValidWriteIds, (Ref<Boolean>)Ref.from((Object)false), true);
        }
        UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)ci.runAs, (UserGroupInformation)UserGroupInformation.getLoginUser());
        try {
            AcidDirectory acidDirectory = (AcidDirectory)ugi.doAs(() -> AcidUtils.getAcidState(null, new Path(sd.getLocation()), (Configuration)this.conf, (ValidWriteIdList)tblValidWriteIds, (Ref<Boolean>)Ref.from((Object)false), true));
            return acidDirectory;
        }
        finally {
            try {
                FileSystem.closeAllForUGI((UserGroupInformation)ugi);
            }
            catch (IOException exception) {
                LOG.error("Could not clean up file-system handles for UGI: " + ugi + " for " + ci.getFullPartitionName(), (Throwable)exception);
            }
        }
    }

    private void failCompactionIfSetForTest() {
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) && this.conf.getBoolVar(HiveConf.ConfVars.HIVETESTMODEFAILCOMPACTION)) {
            throw new RuntimeException(HiveConf.ConfVars.HIVETESTMODEFAILCOMPACTION.name() + "=true");
        }
    }

    private void runCompactionViaMrJob(CompactionInfo ci, Table t, Partition p, StorageDescriptor sd, ValidCompactorWriteIdList tblValidWriteIds, StringBuilder jobName, AcidDirectory dir, StatsUpdater su) throws IOException, HiveException, InterruptedException {
        CompactorMR mr = new CompactorMR();
        if (this.runJobAsSelf(ci.runAs)) {
            mr.run(this.conf, jobName.toString(), t, p, sd, (ValidWriteIdList)tblValidWriteIds, ci, su, this.msc, dir);
        } else {
            UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)ci.runAs, (UserGroupInformation)UserGroupInformation.getLoginUser());
            ugi.doAs(() -> {
                mr.run(this.conf, jobName.toString(), t, p, sd, (ValidWriteIdList)tblValidWriteIds, ci, su, this.msc, dir);
                return null;
            });
            try {
                FileSystem.closeAllForUGI((UserGroupInformation)ugi);
            }
            catch (IOException exception) {
                LOG.error("Could not clean up file-system handles for UGI: " + ugi + " for " + ci.getFullPartitionName(), (Throwable)exception);
            }
        }
    }

    private void markFailed(CompactionInfo ci, Throwable e) {
        if (ci != null) {
            ci.errorMessage = e.getMessage();
        }
        if (this.msc == null) {
            LOG.warn("Metastore client was null. Could not mark failed: {}", (Object)ci);
            return;
        }
        try {
            this.msc.markFailed(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
        }
        catch (TException e1) {
            LOG.error("Caught an exception while trying to mark compaction {} as failed: {}", (Object)ci, (Object)e);
        }
    }

    private void checkInterrupt() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException("Compaction execution is interrupted");
        }
    }

    private static boolean isDynPartAbort(Table t, CompactionInfo ci) {
        return t.getPartitionKeys() != null && t.getPartitionKeys().size() > 0 && ci.partName == null;
    }

    private class CompactionTxn
    implements AutoCloseable {
        private long txnId = 0L;
        private TxnStatus status = TxnStatus.UNKNOWN;
        private boolean succeessfulCompaction = false;

        private CompactionTxn() {
        }

        void open(CompactionInfo ci) throws TException {
            if (Worker.this.msc == null) {
                LOG.error("Metastore client was null. Could not open a new transaction.");
                return;
            }
            this.txnId = Worker.this.msc.openTxn(ci.runAs, TxnType.COMPACTION);
            this.status = TxnStatus.OPEN;
        }

        void wasSuccessful() {
            this.succeessfulCompaction = true;
        }

        @Override
        public void close() throws Exception {
            if (this.status == TxnStatus.UNKNOWN) {
                return;
            }
            if (this.succeessfulCompaction) {
                this.commit();
            } else {
                this.abort();
            }
        }

        long getTxnId() {
            return this.txnId;
        }

        public String toString() {
            return "txnId=" + this.txnId + " (TxnStatus: " + this.status + ")";
        }

        private void commit() {
            if (Worker.this.msc == null) {
                LOG.error("Metastore client was null. Could not commit txn " + this);
                return;
            }
            if (this.status == TxnStatus.OPEN) {
                try {
                    Worker.this.msc.commitTxn(this.txnId);
                    this.status = TxnStatus.COMMITTED;
                }
                catch (TException e) {
                    LOG.error("Caught an exception while committing compaction txn in worker " + Worker.this.workerName, (Throwable)e);
                }
            }
        }

        private void abort() {
            if (Worker.this.msc == null) {
                LOG.error("Metastore client was null. Could not abort txn " + this);
                return;
            }
            if (this.status == TxnStatus.OPEN) {
                try {
                    Worker.this.msc.abortTxns(Collections.singletonList(this.txnId));
                    this.status = TxnStatus.ABORTED;
                }
                catch (TException e) {
                    LOG.error("Caught an exception while aborting compaction txn in worker " + Worker.this.workerName, (Throwable)e);
                }
            }
        }
    }

    static final class CompactionHeartbeater
    extends Thread {
        private static final Logger LOG = LoggerFactory.getLogger(CompactionHeartbeater.class);
        private final AtomicBoolean stop = new AtomicBoolean();
        private final CompactionTxn compactionTxn;
        private final String tableName;
        private final HiveConf conf;
        private final long interval;

        public CompactionHeartbeater(CompactionTxn compactionTxn, String tableName, HiveConf conf) {
            this.tableName = tableName;
            this.compactionTxn = compactionTxn;
            this.conf = conf;
            this.interval = MetastoreConf.getTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS) / 2L;
            this.setDaemon(true);
            this.setPriority(1);
            this.setName("CompactionHeartbeater-" + compactionTxn.getTxnId());
        }

        @Override
        public void run() {
            try (IMetaStoreClient msc = null;){
                msc = HiveMetaStoreUtils.getHiveMetastoreClient((HiveConf)this.conf);
                LOG.debug("Heartbeating compaction transaction id {} for table: {}", (Object)this.compactionTxn, (Object)this.tableName);
                while (!this.stop.get()) {
                    msc.heartbeat(this.compactionTxn.getTxnId(), 0L);
                    Thread.sleep(this.interval);
                }
            }
        }

        public void cancel() {
            if (!this.stop.get()) {
                LOG.debug("Successfully stop the heartbeating the transaction {}", (Object)this.compactionTxn);
                this.stop.set(true);
            }
        }
    }

    static final class StatsUpdater {
        private static final Logger LOG = LoggerFactory.getLogger(StatsUpdater.class);
        private final List<String> columnList;
        private final HiveConf conf;
        private final String userName;
        private final CompactionInfo ci;

        public static StatsUpdater init(CompactionInfo ci, List<String> columnListForStats, HiveConf conf, String userName) {
            return new StatsUpdater(ci, columnListForStats, conf, userName);
        }

        private StatsUpdater(CompactionInfo ci, List<String> columnListForStats, HiveConf conf, String userName) {
            this.conf = new HiveConf(conf);
            this.conf.unset("hive.txn.valid.txns");
            this.userName = userName;
            this.ci = ci;
            if (!ci.isMajorCompaction() || columnListForStats == null || columnListForStats.isEmpty()) {
                this.columnList = Collections.emptyList();
                return;
            }
            this.columnList = columnListForStats;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void gatherStats() {
            try {
                if (!this.ci.isMajorCompaction()) {
                    return;
                }
                if (this.columnList.isEmpty()) {
                    LOG.debug(this.ci + ": No existing stats found.  Will not run analyze.");
                    return;
                }
                StringBuilder sb = new StringBuilder("analyze table ").append(StatsUtils.getFullyQualifiedTableName(this.ci.dbname, this.ci.tableName));
                if (this.ci.partName != null) {
                    sb.append(" partition(");
                    Map partitionColumnValues = Warehouse.makeEscSpecFromName((String)this.ci.partName);
                    for (Map.Entry ent : partitionColumnValues.entrySet()) {
                        sb.append((String)ent.getKey()).append("='").append((String)ent.getValue()).append("',");
                    }
                    sb.setLength(sb.length() - 1);
                    sb.append(")");
                }
                sb.append(" compute statistics for columns ");
                for (String colName : this.columnList) {
                    sb.append(colName).append(",");
                }
                sb.setLength(sb.length() - 1);
                LOG.info(this.ci + ": running '" + sb.toString() + "'");
                this.conf.setVar(HiveConf.ConfVars.METASTOREURIS, "");
                QueryState queryState = new QueryState.Builder().withGenerateNewQueryId(true).withHiveConf(this.conf).build();
                SessionState localSession = null;
                try (Driver d = new Driver(queryState);){
                    if (SessionState.get() == null) {
                        localSession = new SessionState(this.conf);
                        SessionState.start(localSession);
                    }
                    try {
                        d.run(sb.toString());
                    }
                    catch (CommandProcessorException e) {
                        LOG.warn(this.ci + ": " + sb.toString() + " failed due to: " + e);
                    }
                }
                finally {
                    if (localSession != null) {
                        try {
                            localSession.close();
                        }
                        catch (IOException ex) {
                            LOG.warn(this.ci + ": localSession.close() failed due to: " + ex.getMessage(), (Throwable)ex);
                        }
                    }
                }
            }
            catch (Throwable t) {
                LOG.error(this.ci + ": gatherStats(" + this.ci.dbname + "," + this.ci.tableName + "," + this.ci.partName + ") failed due to: " + t.getMessage(), t);
            }
        }
    }
}

