/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.ql.io.AcidDirectory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilder;
import org.apache.hadoop.hive.ql.txn.compactor.QueryCompactor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MmMajorQueryCompactor
extends QueryCompactor {
    private static final Logger LOG = LoggerFactory.getLogger((String)MmMajorQueryCompactor.class.getName());

    MmMajorQueryCompactor() {
    }

    @Override
    void runCompaction(HiveConf hiveConf, Table table, Partition partition, StorageDescriptor storageDescriptor, ValidWriteIdList writeIds, CompactionInfo compactionInfo, AcidDirectory dir) throws IOException {
        LOG.debug("Going to delete directories for aborted transactions for MM table " + table.getDbName() + "." + table.getTableName());
        QueryCompactor.Util.removeFilesForMmTable(hiveConf, dir);
        HiveConf driverConf = new HiveConf(hiveConf);
        driverConf.set(HiveConf.ConfVars.HIVE_QUOTEDID_SUPPORT.varname, "column");
        String tmpPrefix = table.getDbName() + ".tmp_compactor_" + table.getTableName() + "_";
        String tmpTableName = tmpPrefix + System.currentTimeMillis();
        Path resultBaseDir = QueryCompactor.Util.getCompactionResultDir(storageDescriptor, writeIds, driverConf, true, true, false, null);
        List<String> createTableQueries = this.getCreateQueries(tmpTableName, table, storageDescriptor, resultBaseDir.toString());
        List<String> compactionQueries = this.getCompactionQueries(table, partition, tmpTableName);
        List<String> dropQueries = this.getDropQueries(tmpTableName);
        this.runCompactionQueries(driverConf, tmpTableName, storageDescriptor, writeIds, compactionInfo, Lists.newArrayList((Object[])new Path[]{resultBaseDir}), createTableQueries, compactionQueries, dropQueries);
    }

    @Override
    protected void commitCompaction(String dest, String tmpTableName, HiveConf conf, ValidWriteIdList actualWriteIds, long compactorTxnId) throws IOException, HiveException {
        QueryCompactor.Util.cleanupEmptyDir(conf, tmpTableName);
    }

    private List<String> getCreateQueries(String tmpTableName, Table table, StorageDescriptor storageDescriptor, String baseLocation) {
        return Lists.newArrayList((Object[])new String[]{new CompactionQueryBuilder(CompactionQueryBuilder.CompactionType.MAJOR_INSERT_ONLY, CompactionQueryBuilder.Operation.CREATE, tmpTableName).setSourceTab(table).setStorageDescriptor(storageDescriptor).setLocation(baseLocation).build()});
    }

    private List<String> getCompactionQueries(Table t, Partition p, String tmpName) {
        return Lists.newArrayList((Object[])new String[]{new CompactionQueryBuilder(CompactionQueryBuilder.CompactionType.MAJOR_INSERT_ONLY, CompactionQueryBuilder.Operation.INSERT, tmpName).setSourceTab(t).setSourcePartition(p).build()});
    }

    private List<String> getDropQueries(String tmpTableName) {
        return Lists.newArrayList((Object[])new String[]{new CompactionQueryBuilder(CompactionQueryBuilder.CompactionType.MAJOR_INSERT_ONLY, CompactionQueryBuilder.Operation.DROP, tmpTableName).build()});
    }
}

