/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class CompactorUtil {
    public static final String COMPACTOR = "compactor";

    public static ThreadFactory createThreadFactory(String threadNameFormat) {
        return new ThreadFactoryBuilder().setPriority(Thread.currentThread().getPriority()).setDaemon(Thread.currentThread().isDaemon()).setNameFormat(threadNameFormat).build();
    }

    public static ExecutorService createExecutorWithThreadFactory(int threadCount, String threadNameFormat) {
        return Executors.newFixedThreadPool(threadCount, CompactorUtil.createThreadFactory(threadNameFormat));
    }

    public static interface ThrowingRunnable<E extends Exception> {
        public void run() throws E;

        public static Runnable unchecked(ThrowingRunnable<?> r) {
            return () -> {
                try {
                    r.run();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        }
    }
}

