/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.hive_metastoreConstants;
import org.apache.hadoop.hive.ql.ddl.table.create.show.ShowCreateTableOperation;
import org.apache.hadoop.hive.ql.io.AcidDirectory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.util.DirectionUtils;
import org.apache.hive.common.util.HiveStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CompactionQueryBuilder {
    private static final Logger LOG = LoggerFactory.getLogger((String)CompactionQueryBuilder.class.getName());
    private final Operation operation;
    private String resultTableName;
    private org.apache.hadoop.hive.metastore.api.Table sourceTab;
    private StorageDescriptor storageDescriptor;
    private String location;
    private ValidWriteIdList validWriteIdList;
    private AcidDirectory dir;
    private Partition sourcePartition;
    private String sourceTabForInsert;
    private boolean isPartitioned;
    private boolean isBucketed;
    private boolean isDeleteDelta;
    private final boolean major;
    private final boolean minor;
    private final boolean crud;
    private final boolean insertOnly;

    CompactionQueryBuilder setSourceTab(org.apache.hadoop.hive.metastore.api.Table sourceTab) {
        this.sourceTab = sourceTab;
        return this;
    }

    CompactionQueryBuilder setStorageDescriptor(StorageDescriptor storageDescriptor) {
        this.storageDescriptor = storageDescriptor;
        return this;
    }

    CompactionQueryBuilder setLocation(String location) {
        this.location = location;
        return this;
    }

    CompactionQueryBuilder setValidWriteIdList(ValidWriteIdList validWriteIdList) {
        this.validWriteIdList = validWriteIdList;
        return this;
    }

    CompactionQueryBuilder setDir(AcidDirectory dir) {
        this.dir = dir;
        return this;
    }

    CompactionQueryBuilder setSourcePartition(Partition sourcePartition) {
        this.sourcePartition = sourcePartition;
        return this;
    }

    CompactionQueryBuilder setSourceTabForInsert(String sourceTabForInsert) {
        this.sourceTabForInsert = sourceTabForInsert;
        return this;
    }

    CompactionQueryBuilder setPartitioned(boolean partitioned) {
        this.isPartitioned = partitioned;
        return this;
    }

    CompactionQueryBuilder setBucketed(boolean bucketed) {
        this.isBucketed = bucketed;
        return this;
    }

    CompactionQueryBuilder setIsDeleteDelta(boolean deleteDelta) {
        this.isDeleteDelta = deleteDelta;
        return this;
    }

    CompactionQueryBuilder(CompactionType compactionType, Operation operation, String resultTableName) {
        if (compactionType == null) {
            throw new IllegalArgumentException("CompactionQueryBuilder.CompactionType cannot be null");
        }
        this.operation = operation;
        this.resultTableName = resultTableName;
        this.major = compactionType == CompactionType.MAJOR_CRUD || compactionType == CompactionType.MAJOR_INSERT_ONLY;
        this.crud = compactionType == CompactionType.MAJOR_CRUD || compactionType == CompactionType.MINOR_CRUD;
        this.minor = !this.major;
        this.insertOnly = !this.crud;
    }

    String build() {
        StringBuilder query = new StringBuilder(this.operation.toString());
        if (this.operation == Operation.CREATE) {
            query.append(" temporary external");
        }
        if (this.operation == Operation.INSERT) {
            query.append(" into");
        }
        query.append(" table ");
        if (this.operation == Operation.DROP) {
            query.append("if exists ");
        }
        query.append(this.resultTableName);
        switch (this.operation) {
            case CREATE: {
                this.getDdlForCreate(query);
                break;
            }
            case ALTER: {
                this.buildAddClauseForAlter(query);
                break;
            }
            case INSERT: {
                query.append(" select ");
                this.buildSelectClauseForInsert(query);
                query.append(" from ");
                this.getSourceForInsert(query);
                this.buildWhereClauseForInsert(query);
                break;
            }
        }
        return query.toString();
    }

    private void buildAddClauseForAlter(StringBuilder query) {
        if (this.validWriteIdList == null || this.dir == null) {
            query.setLength(0);
            return;
        }
        long minWriteID = this.validWriteIdList.getMinOpenWriteId() == null ? 1L : this.validWriteIdList.getMinOpenWriteId();
        long highWatermark = this.validWriteIdList.getHighWatermark();
        List<AcidUtils.ParsedDelta> deltas = this.dir.getCurrentDirectories().stream().filter(delta -> delta.isDeleteDelta() == this.isDeleteDelta && delta.getMaxWriteId() <= highWatermark && delta.getMinWriteId() >= minWriteID).collect(Collectors.toList());
        if (deltas.isEmpty()) {
            query.setLength(0);
            return;
        }
        query.append(" add ");
        deltas.forEach(delta -> query.append("partition (file_name='").append(delta.getPath().getName()).append("') location '").append(delta.getPath()).append("' "));
    }

    private void buildSelectClauseForInsert(StringBuilder query) {
        List cols;
        if (this.major && this.crud || this.major && this.insertOnly && this.sourcePartition != null || this.minor && this.insertOnly) {
            if (this.sourceTab == null) {
                return;
            }
            cols = this.sourceTab.getSd().getCols();
        } else {
            cols = null;
        }
        if (this.crud) {
            if (this.major) {
                query.append("validate_acid_sort_order(ROW__ID.writeId, ROW__ID.bucketId, ROW__ID.rowId), ROW__ID.writeId, ROW__ID.bucketId, ROW__ID.rowId, ROW__ID.writeId, NAMED_STRUCT(");
                for (int i = 0; i < cols.size(); ++i) {
                    query.append(i == 0 ? "'" : ", '").append(((FieldSchema)cols.get(i)).getName()).append("', ").append(((FieldSchema)cols.get(i)).getName());
                }
                query.append(") ");
            } else {
                query.append("`operation`, `originalTransaction`, `bucket`, `rowId`, `currentTransaction`, `row`");
            }
        } else if (this.major) {
            if (this.sourcePartition != null) {
                for (int i = 0; i < cols.size(); ++i) {
                    query.append(i == 0 ? "`" : ", `").append(((FieldSchema)cols.get(i)).getName()).append("`");
                }
            } else {
                query.append("*");
            }
        } else {
            for (int i = 0; i < cols.size(); ++i) {
                query.append(i == 0 ? "`" : ", `").append(((FieldSchema)cols.get(i)).getName()).append("`");
            }
        }
    }

    private void getSourceForInsert(StringBuilder query) {
        if (this.sourceTabForInsert != null) {
            query.append(this.sourceTabForInsert);
        } else {
            query.append(this.sourceTab.getDbName()).append(".").append(this.sourceTab.getTableName());
        }
    }

    private void buildWhereClauseForInsert(StringBuilder query) {
        long[] invalidWriteIds;
        if (this.major && this.sourcePartition != null && this.sourceTab != null) {
            List vals = this.sourcePartition.getValues();
            List keys = this.sourceTab.getPartitionKeys();
            if (keys.size() != vals.size()) {
                throw new IllegalStateException("source partition values (" + Arrays.toString(vals.toArray()) + ") do not match source table values (" + Arrays.toString(keys.toArray()) + "). Failing compaction.");
            }
            query.append(" where ");
            for (int i = 0; i < keys.size(); ++i) {
                query.append(i == 0 ? "`" : " and `").append(((FieldSchema)keys.get(i)).getName()).append("`='").append((String)vals.get(i)).append("'");
            }
        }
        if (this.minor && this.crud && this.validWriteIdList != null && (invalidWriteIds = this.validWriteIdList.getInvalidWriteIds()).length > 0) {
            query.append(" where `originalTransaction` not in (").append(StringUtils.join((Object[])ArrayUtils.toObject((long[])invalidWriteIds), (String)",")).append(")");
        }
    }

    private void getDdlForCreate(StringBuilder query) {
        this.defineColumns(query);
        if (this.isPartitioned) {
            query.append(" PARTITIONED BY (`file_name` STRING) ");
        }
        int bucketingVersion = 0;
        if (this.crud && this.minor) {
            bucketingVersion = this.getMinorCrudBucketing(query, bucketingVersion);
        } else if (this.insertOnly) {
            this.getMmBucketing(query);
        }
        if (this.insertOnly) {
            this.getSkewedByClause(query);
        }
        if (this.crud) {
            query.append(" stored as orc");
        } else {
            this.copySerdeFromSourceTable(query);
        }
        if (this.location != null) {
            query.append(" LOCATION '").append(HiveStringUtils.escapeHiveCommand((String)this.location)).append("'");
        }
        this.addTblProperties(query, bucketingVersion);
    }

    private void defineColumns(StringBuilder query) {
        if (this.sourceTab == null) {
            return;
        }
        query.append("(");
        if (this.crud) {
            query.append("`operation` int, `originalTransaction` bigint, `bucket` int, `rowId` bigint, `currentTransaction` bigint, `row` struct<");
        }
        List cols = this.sourceTab.getSd().getCols();
        boolean isFirst = true;
        for (FieldSchema col : cols) {
            if (!isFirst) {
                query.append(", ");
            }
            isFirst = false;
            query.append("`").append(col.getName()).append("` ");
            query.append(this.crud ? ":" : "");
            query.append(col.getType());
        }
        query.append(this.crud ? ">" : "");
        query.append(") ");
    }

    private void getMmBucketing(StringBuilder query) {
        if (this.sourceTab == null) {
            return;
        }
        List buckCols = this.sourceTab.getSd().getBucketCols();
        if (buckCols.size() > 0) {
            query.append("CLUSTERED BY (").append(org.apache.hadoop.util.StringUtils.join((CharSequence)",", (Iterable)buckCols)).append(") ");
            List sortCols = this.sourceTab.getSd().getSortCols();
            if (sortCols.size() > 0) {
                query.append("SORTED BY (");
                boolean isFirst = true;
                for (Order sortCol : sortCols) {
                    if (!isFirst) {
                        query.append(", ");
                    }
                    isFirst = false;
                    query.append(sortCol.getCol()).append(" ").append(DirectionUtils.codeToText(sortCol.getOrder()));
                }
                query.append(") ");
            }
            query.append("INTO ").append(this.sourceTab.getSd().getNumBuckets()).append(" BUCKETS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMinorCrudBucketing(StringBuilder query, int bucketingVersion) {
        if (this.isBucketed && this.sourceTab != null) {
            int numBuckets = 1;
            try {
                Table t = Hive.get().getTable(this.sourceTab.getDbName(), this.sourceTab.getTableName());
                numBuckets = Math.max(t.getNumBuckets(), numBuckets);
                bucketingVersion = t.getBucketingVersion();
            }
            catch (HiveException e) {
                LOG.info("Error finding table {}. Minor compaction result will use 0 buckets.", (Object)this.sourceTab.getTableName());
            }
            finally {
                query.append(" clustered by (`bucket`)").append(" sorted by (`bucket`, `originalTransaction`, `rowId`)").append(" into ").append(numBuckets).append(" buckets");
            }
        }
        return bucketingVersion;
    }

    private void getSkewedByClause(StringBuilder query) {
        SkewedInfo skewedInfo;
        if (this.sourceTab == null) {
            return;
        }
        if (this.sourceTab.getSd().isStoredAsSubDirectories() && (skewedInfo = this.sourceTab.getSd().getSkewedInfo()) != null && !skewedInfo.getSkewedColNames().isEmpty()) {
            query.append(" SKEWED BY (").append(org.apache.hadoop.util.StringUtils.join((CharSequence)", ", (Iterable)skewedInfo.getSkewedColNames())).append(") ON ");
            boolean isFirst = true;
            for (List colValues : skewedInfo.getSkewedColValues()) {
                if (!isFirst) {
                    query.append(", ");
                }
                isFirst = false;
                query.append("('").append(org.apache.hadoop.util.StringUtils.join((CharSequence)"','", (Iterable)colValues)).append("')");
            }
            query.append(") STORED AS DIRECTORIES");
        }
    }

    private void copySerdeFromSourceTable(StringBuilder query) {
        if (this.storageDescriptor == null) {
            return;
        }
        this.ensureTableToCompactIsNative();
        SerDeInfo serdeInfo = this.storageDescriptor.getSerdeInfo();
        Map serdeParams = serdeInfo.getParameters();
        query.append(" ROW FORMAT SERDE '").append(HiveStringUtils.escapeHiveCommand((String)serdeInfo.getSerializationLib())).append("'");
        if (!serdeParams.isEmpty()) {
            ShowCreateTableOperation.appendSerdeParams(query, serdeParams);
        }
        query.append("STORED AS INPUTFORMAT '").append(HiveStringUtils.escapeHiveCommand((String)this.storageDescriptor.getInputFormat())).append("'").append(" OUTPUTFORMAT '").append(HiveStringUtils.escapeHiveCommand((String)this.storageDescriptor.getOutputFormat())).append("'");
    }

    private void addTblProperties(StringBuilder query, int bucketingVersion) {
        HashMap<String, String> tblProperties = new HashMap<String, String>();
        tblProperties.put("transactional", "false");
        if (this.crud) {
            tblProperties.put("compactiontable", "true");
        }
        if (this.crud && this.minor && this.isBucketed) {
            tblProperties.put("bucketing_version", String.valueOf(bucketingVersion));
        }
        if (this.sourceTab != null) {
            if (this.insertOnly) {
                Set<String> excludes = CompactionQueryBuilder.getHiveMetastoreConstants();
                excludes.addAll(StatsSetupConst.TABLE_PARAMS_STATS_KEYS);
                for (Map.Entry e : this.sourceTab.getParameters().entrySet()) {
                    if (e.getValue() == null || excludes.contains(e.getKey())) continue;
                    tblProperties.put((String)e.getKey(), HiveStringUtils.escapeHiveCommand((String)((String)e.getValue())));
                }
            } else {
                for (Map.Entry entry : this.sourceTab.getParameters().entrySet()) {
                    if (!((String)entry.getKey()).startsWith("orc.")) continue;
                    tblProperties.put((String)entry.getKey(), HiveStringUtils.escapeHiveCommand((String)((String)entry.getValue())));
                }
            }
        }
        query.append(" TBLPROPERTIES (");
        boolean isFirst = true;
        for (Map.Entry property : tblProperties.entrySet()) {
            if (!isFirst) {
                query.append(", ");
            }
            query.append("'").append((String)property.getKey()).append("'='").append((String)property.getValue()).append("'");
            isFirst = false;
        }
        query.append(")");
    }

    private static Set<String> getHiveMetastoreConstants() {
        HashSet<String> result = new HashSet<String>();
        for (Field f : hive_metastoreConstants.class.getDeclaredFields()) {
            if (!Modifier.isFinal(f.getModifiers()) || !String.class.equals(f.getType())) continue;
            f.setAccessible(true);
            try {
                result.add((String)f.get(null));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private void ensureTableToCompactIsNative() {
        if (this.sourceTab == null) {
            return;
        }
        String storageHandler = (String)this.sourceTab.getParameters().get("storage_handler");
        if (storageHandler != null) {
            String message = "Table " + this.sourceTab.getTableName() + "has a storage handler (" + storageHandler + "). Failing compaction for this non-native table.";
            LOG.error(message);
            throw new RuntimeException(message);
        }
    }

    static enum Operation {
        CREATE,
        ALTER,
        INSERT,
        DROP;

    }

    static enum CompactionType {
        MAJOR_CRUD,
        MINOR_CRUD,
        MAJOR_INSERT_ONLY,
        MINOR_INSERT_ONLY;

    }
}

