/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HMSHandler;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.TxnCommonUtils;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.io.AcidDirectory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorUtil;
import org.apache.hadoop.hive.ql.txn.compactor.MetaStoreCompactorThread;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.Ref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cleaner
extends MetaStoreCompactorThread {
    private static final String CLASS_NAME = Cleaner.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private long cleanerCheckInterval = 0L;
    private ReplChangeManager replChangeManager;
    private ExecutorService cleanerExecutor;

    @Override
    public void init(AtomicBoolean stop) throws Exception {
        super.init(stop);
        this.replChangeManager = ReplChangeManager.getInstance((Configuration)this.conf);
        this.cleanerCheckInterval = this.conf.getTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RUN_INTERVAL, TimeUnit.MILLISECONDS);
        this.cleanerExecutor = CompactorUtil.createExecutorWithThreadFactory(this.conf.getIntVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_THREADS_NUM), "Cleaner-executor-thread-%d");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.info("Starting Cleaner thread");
        try {
            do {
                long elapsedTime;
                TxnStore.MutexAPI.LockHandle handle = null;
                long startedAt = -1L;
                boolean delayedCleanupEnabled = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_DELAYED_CLEANUP_ENABLED);
                long retentionTime = 0L;
                if (delayedCleanupEnabled) {
                    retentionTime = HiveConf.getTimeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETENTION_TIME, (TimeUnit)TimeUnit.MILLISECONDS);
                }
                try {
                    handle = this.txnHandler.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.Cleaner.name());
                    startedAt = System.currentTimeMillis();
                    long minOpenTxnId = this.txnHandler.findMinOpenTxnIdForCleaner();
                    List readyToClean = this.txnHandler.findReadyToClean(minOpenTxnId, retentionTime);
                    if (!readyToClean.isEmpty()) {
                        long minTxnIdSeenOpen = this.txnHandler.findMinTxnIdSeenOpen();
                        long cleanerWaterMark = minTxnIdSeenOpen < 0L ? minOpenTxnId : Math.min(minOpenTxnId, minTxnIdSeenOpen);
                        LOG.info("Cleaning based on min open txn id: " + minOpenTxnId);
                        ArrayList<CompletableFuture<Void>> cleanerList = new ArrayList<CompletableFuture<Void>>();
                        for (CompactionInfo compactionInfo : readyToClean) {
                            cleanerList.add(CompletableFuture.runAsync(CompactorUtil.ThrowingRunnable.unchecked(() -> this.clean(compactionInfo, cleanerWaterMark)), this.cleanerExecutor));
                        }
                        CompletableFuture.allOf(cleanerList.toArray(new CompletableFuture[0])).join();
                    }
                }
                catch (Throwable t) {
                    LOG.error("Caught an exception in the main loop of compactor cleaner, " + StringUtils.stringifyException((Throwable)t));
                }
                finally {
                    if (handle != null) {
                        handle.releaseLocks();
                    }
                }
                if ((elapsedTime = System.currentTimeMillis() - startedAt) < this.cleanerCheckInterval && !this.stop.get()) {
                    Thread.sleep(this.cleanerCheckInterval - elapsedTime);
                }
                LOG.debug("Cleaner thread finished one loop.");
            } while (!this.stop.get());
        }
        catch (InterruptedException ie) {
            LOG.error("Compactor cleaner thread interrupted, exiting " + StringUtils.stringifyException((Throwable)ie));
        }
        finally {
            if (this.cleanerExecutor != null) {
                this.cleanerExecutor.shutdownNow();
            }
        }
    }

    private void clean(CompactionInfo ci, long minOpenTxnGLB) throws MetaException {
        LOG.info("Starting cleaning for " + ci);
        try {
            Table t = this.resolveTable(ci);
            if (t == null) {
                LOG.info("Unable to find table " + ci.getFullTableName() + ", assuming it was dropped." + Cleaner.idWatermark(ci));
                this.txnHandler.markCleaned(ci);
                return;
            }
            Partition p = null;
            if (ci.partName != null && (p = this.resolvePartition(ci)) == null) {
                LOG.info("Unable to find partition " + ci.getFullPartitionName() + ", assuming it was dropped." + Cleaner.idWatermark(ci));
                this.txnHandler.markCleaned(ci);
                return;
            }
            StorageDescriptor sd = this.resolveStorageDescriptor(t, p);
            String location = sd.getLocation();
            ValidTxnList validTxnList = TxnUtils.createValidTxnListForCleaner((GetOpenTxnsResponse)this.txnHandler.getOpenTxns(), (long)minOpenTxnGLB);
            this.conf.set("hive.txn.valid.txns", validTxnList.writeToString());
            ValidReaderWriteIdList validWriteIdList = this.getValidCleanerWriteIdList(ci, t, validTxnList);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cleaning based on writeIdList: " + validWriteIdList);
            }
            Ref removedFiles = Ref.from((Object)false);
            if (this.runJobAsSelf(ci.runAs)) {
                removedFiles.value = this.removeFiles(location, (ValidWriteIdList)validWriteIdList, ci);
            } else {
                LOG.info("Cleaning as user " + ci.runAs + " for " + ci.getFullPartitionName());
                UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)ci.runAs, (UserGroupInformation)UserGroupInformation.getLoginUser());
                ugi.doAs(() -> {
                    removedFiles.value = this.removeFiles(location, (ValidWriteIdList)validWriteIdList, ci);
                    return null;
                });
                try {
                    FileSystem.closeAllForUGI((UserGroupInformation)ugi);
                }
                catch (IOException exception) {
                    LOG.error("Could not clean up file-system handles for UGI: " + ugi + " for " + ci.getFullPartitionName() + Cleaner.idWatermark(ci), (Throwable)exception);
                }
            }
            if (((Boolean)removedFiles.value).booleanValue() || Cleaner.isDynPartAbort(t, ci)) {
                this.txnHandler.markCleaned(ci);
            } else {
                LOG.warn("No files were removed. Leaving queue entry " + ci + " in ready for cleaning state.");
            }
        }
        catch (Exception e) {
            LOG.error("Caught exception when cleaning, unable to complete cleaning of " + ci + " " + StringUtils.stringifyException((Throwable)e));
            ci.errorMessage = e.getMessage();
            this.txnHandler.markFailed(ci);
        }
    }

    private ValidReaderWriteIdList getValidCleanerWriteIdList(CompactionInfo ci, Table t, ValidTxnList validTxnList) throws NoSuchTxnException, MetaException {
        List<String> tblNames = Collections.singletonList(TableName.getDbTable((String)t.getDbName(), (String)t.getTableName()));
        GetValidWriteIdsRequest request = new GetValidWriteIdsRequest(tblNames);
        request.setValidTxnList(validTxnList.writeToString());
        GetValidWriteIdsResponse rsp = this.txnHandler.getValidWriteIds(request);
        assert (rsp != null && rsp.getTblValidWriteIdsSize() == 1);
        ValidReaderWriteIdList validWriteIdList = TxnCommonUtils.createValidReaderWriteIdList((TableValidWriteIds)((TableValidWriteIds)rsp.getTblValidWriteIds().get(0)));
        boolean delayedCleanupEnabled = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_COMPACTOR_DELAYED_CLEANUP_ENABLED);
        if (delayedCleanupEnabled) {
            validWriteIdList = validWriteIdList.updateHighWatermark(ci.highestWriteId);
        }
        return validWriteIdList;
    }

    private static boolean isDynPartAbort(Table t, CompactionInfo ci) {
        return t.getPartitionKeys() != null && t.getPartitionKeys().size() > 0 && ci.partName == null;
    }

    private static String idWatermark(CompactionInfo ci) {
        return " id=" + ci.id;
    }

    private boolean removeFiles(String location, ValidWriteIdList writeIdList, CompactionInfo ci) throws IOException, NoSuchObjectException, MetaException {
        Path locPath = new Path(location);
        AcidDirectory dir = AcidUtils.getAcidState(locPath.getFileSystem((Configuration)this.conf), locPath, (Configuration)this.conf, writeIdList, (Ref<Boolean>)Ref.from((Object)false), false);
        List<Path> obsoleteDirs = dir.getObsolete();
        Table table = HMSHandler.getMSForConf((Configuration)this.conf).getTable(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), ci.dbname, ci.tableName);
        if (Cleaner.isDynPartAbort(table, ci) || dir.hasUncompactedAborts()) {
            ci.setWriteIds(dir.getAbortedWriteIds());
        }
        obsoleteDirs.addAll(dir.getAbortedDirectories());
        ArrayList<Path> filesToDelete = new ArrayList<Path>(obsoleteDirs.size());
        StringBuilder extraDebugInfo = new StringBuilder("[");
        for (Path stat : obsoleteDirs) {
            filesToDelete.add(stat);
            extraDebugInfo.append(stat.getName()).append(",");
            if (FileUtils.isPathWithinSubtree((Path)stat, (Path)locPath)) continue;
            LOG.info(Cleaner.idWatermark(ci) + " found unexpected file: " + stat);
        }
        extraDebugInfo.setCharAt(extraDebugInfo.length() - 1, ']');
        LOG.info(Cleaner.idWatermark(ci) + " About to remove " + filesToDelete.size() + " obsolete directories from " + location + ". " + extraDebugInfo.toString());
        if (filesToDelete.size() < 1) {
            LOG.warn("Hmm, nothing to delete in the cleaner for directory " + location + ", that hardly seems right.");
            return false;
        }
        FileSystem fs = dir.getFs();
        Database db = HMSHandler.getMSForConf((Configuration)this.conf).getDatabase(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), ci.dbname);
        for (Path dead : filesToDelete) {
            LOG.debug("Going to delete path " + dead.toString());
            if (ReplChangeManager.shouldEnableCm((Database)db, (Table)table)) {
                this.replChangeManager.recycle(dead, ReplChangeManager.RecycleType.MOVE, true);
            }
            fs.delete(dead, true);
        }
        return true;
    }
}

