/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats.fs;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.stats.StatsAggregator;
import org.apache.hadoop.hive.ql.stats.StatsCollectionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSStatsAggregator
implements StatsAggregator {
    private final Logger LOG = LoggerFactory.getLogger((String)this.getClass().getName());
    private List<Map<String, Map<String, String>>> statsList;
    private FileSystem fs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect(StatsCollectionContext scc) {
        List<String> statsDirs = scc.getStatsTmpDirs();
        assert (statsDirs.size() == 1) : "Found multiple stats dirs: " + statsDirs;
        Path statsDir = new Path(statsDirs.get(0));
        Utilities.FILE_OP_LOGGER.trace("About to read stats from {}", (Object)statsDir);
        int poolSize = HiveConf.getIntVar((Configuration)scc.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT);
        poolSize = Math.max(poolSize, 1);
        ExecutorService pool = Executors.newFixedThreadPool(poolSize, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("stats-updater-thread-%d").build());
        LinkedList<Future<Map<String, Map<String, String>>>> futureList = new LinkedList<Future<Map<String, Map<String, String>>>>();
        try {
            this.fs = statsDir.getFileSystem(scc.getHiveConf());
            this.statsList = new ArrayList<Map<String, Map<String, String>>>();
            FileStatus[] status = this.fs.listStatus(statsDir, new PathFilter(){

                public boolean accept(Path file) {
                    return file.getName().startsWith("tmpstats-");
                }
            });
            HashMap statsMap = new HashMap();
            for (FileStatus file : status) {
                futureList.add(pool.submit(() -> {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }));
            }
            for (Future future : futureList) {
                Map stats = (Map)future.get();
                if (stats == null) continue;
                this.statsList.add(stats);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException | ExecutionException e) {
            Utilities.FILE_OP_LOGGER.error("Failed to read stats from filesystem ", (Throwable)e);
            this.cancelRunningTasks(futureList);
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException e) {
            this.cancelRunningTasks(futureList);
            Thread.currentThread().interrupt();
        }
        finally {
            pool.shutdownNow();
        }
        return false;
    }

    private void cancelRunningTasks(List<Future<Map<String, Map<String, String>>>> tasks) {
        for (Future<Map<String, Map<String, String>>> task : tasks) {
            task.cancel(true);
        }
    }

    @Override
    public String aggregateStats(String partID, String statType) {
        long counter = 0L;
        Utilities.FILE_OP_LOGGER.debug("Part ID: {}, {}", (Object)partID, (Object)statType);
        boolean statsPresent = false;
        for (Map<String, Map<String, String>> statsMap : this.statsList) {
            Map<String, String> partStat = statsMap.get(partID);
            if (null == partStat) continue;
            statsPresent = true;
            String statVal = partStat.get(statType);
            if (null == statVal) continue;
            counter += Long.parseLong(statVal);
        }
        Utilities.FILE_OP_LOGGER.info("Read stats for {}, {}, {}, {}, {}: ", new Object[]{partID, statType, statsPresent, counter, this.statsList.isEmpty()});
        return statsPresent || this.statsList.isEmpty() ? String.valueOf(counter) : null;
    }

    @Override
    public boolean closeConnection(StatsCollectionContext scc) {
        List<String> statsDirs = scc.getStatsTmpDirs();
        assert (statsDirs.size() == 1) : "Found multiple stats dirs: " + statsDirs;
        Path statsDir = new Path(statsDirs.get(0));
        this.LOG.debug("About to delete stats tmp dir :" + statsDir);
        try {
            this.fs.delete(statsDir, true);
            return true;
        }
        catch (IOException e) {
            this.LOG.error("Failed to delete stats dir", (Throwable)e);
            return true;
        }
    }
}

