/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Timestamp;
import org.apache.hadoop.hive.metastore.api.TimestampColumnStatsData;
import org.apache.hadoop.hive.metastore.api.utils.DecimalUtils;
import org.apache.hadoop.hive.metastore.columnstats.cache.DateColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.DecimalColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.DoubleColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.LongColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.StringColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.TimestampColumnStatsDataInspector;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.stats.ColStatsProcessor;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;

public class ColumnStatisticsObjTranslator {
    public static ColumnStatisticsObj readHiveColumnStatistics(String columnName, String columnType, List<ColStatsProcessor.ColumnStatsField> columnStatsFields, int start, List<? extends StructField> fields, List<Object> values) throws HiveException {
        ColumnStatisticsObj statsObj = new ColumnStatisticsObj();
        statsObj.setColName(columnName);
        statsObj.setColType(columnType);
        int end = start + columnStatsFields.size();
        for (int i = start; i < end; ++i) {
            ObjectInspector foi = fields.get(i).getFieldObjectInspector();
            Object v = values.get(i);
            try {
                ColumnStatisticsObjTranslator.unpackPrimitiveObject(foi, v, columnStatsFields.get(i - start), statsObj);
                continue;
            }
            catch (Exception e) {
                throw new HiveException("Error calculating statistics for column:" + columnName, (Throwable)e);
            }
        }
        return statsObj;
    }

    private static void unpackBooleanStats(ObjectInspector oi, Object o, ColStatsProcessor.ColumnStatsField csf, ColumnStatisticsObj statsObj) {
        long v = ((LongObjectInspector)oi).get(o);
        switch (csf) {
            case COUNT_TRUES: {
                statsObj.getStatsData().getBooleanStats().setNumTrues(v);
                break;
            }
            case COUNT_FALSES: {
                statsObj.getStatsData().getBooleanStats().setNumFalses(v);
                break;
            }
            case COUNT_NULLS: {
                statsObj.getStatsData().getBooleanStats().setNumNulls(v);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported column stat for BOOLEAN : " + (Object)((Object)csf));
            }
        }
    }

    private static void unpackDoubleStats(ObjectInspector oi, Object o, ColStatsProcessor.ColumnStatsField csf, ColumnStatisticsObj statsObj) throws UnsupportedDoubleException {
        switch (csf) {
            case COUNT_NULLS: {
                long cn = ((LongObjectInspector)oi).get(o);
                statsObj.getStatsData().getDoubleStats().setNumNulls(cn);
                break;
            }
            case MIN: {
                double min = ((DoubleObjectInspector)oi).get(o);
                if (Double.isInfinite(min) || Double.isNaN(min)) {
                    throw new UnsupportedDoubleException();
                }
                statsObj.getStatsData().getDoubleStats().setLowValue(min);
                break;
            }
            case MAX: {
                double max = ((DoubleObjectInspector)oi).get(o);
                if (Double.isInfinite(max) || Double.isNaN(max)) {
                    throw new UnsupportedDoubleException();
                }
                statsObj.getStatsData().getDoubleStats().setHighValue(max);
                break;
            }
            case NDV: {
                long ndv = ((LongObjectInspector)oi).get(o);
                statsObj.getStatsData().getDoubleStats().setNumDVs(ndv);
                break;
            }
            case BITVECTOR: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                byte[] buf = ((BinaryObjectInspector)poi).getPrimitiveJavaObject(o);
                statsObj.getStatsData().getDoubleStats().setBitVectors(buf);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported column stat for DOUBLE : " + (Object)((Object)csf));
            }
        }
    }

    private static void unpackDecimalStats(ObjectInspector oi, Object o, ColStatsProcessor.ColumnStatsField csf, ColumnStatisticsObj statsObj) {
        switch (csf) {
            case COUNT_NULLS: {
                long cn = ((LongObjectInspector)oi).get(o);
                statsObj.getStatsData().getDecimalStats().setNumNulls(cn);
                break;
            }
            case MIN: {
                HiveDecimal min = ((HiveDecimalObjectInspector)oi).getPrimitiveJavaObject(o);
                statsObj.getStatsData().getDecimalStats().setLowValue(ColumnStatisticsObjTranslator.convertToThriftDecimal(min));
                break;
            }
            case MAX: {
                HiveDecimal max = ((HiveDecimalObjectInspector)oi).getPrimitiveJavaObject(o);
                statsObj.getStatsData().getDecimalStats().setHighValue(ColumnStatisticsObjTranslator.convertToThriftDecimal(max));
                break;
            }
            case NDV: {
                long ndv = ((LongObjectInspector)oi).get(o);
                statsObj.getStatsData().getDecimalStats().setNumDVs(ndv);
                break;
            }
            case BITVECTOR: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                byte[] buf = ((BinaryObjectInspector)poi).getPrimitiveJavaObject(o);
                statsObj.getStatsData().getDecimalStats().setBitVectors(buf);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported column stat for DECIMAL : " + (Object)((Object)csf));
            }
        }
    }

    private static Decimal convertToThriftDecimal(HiveDecimal d) {
        return DecimalUtils.getDecimal((ByteBuffer)ByteBuffer.wrap(d.unscaledValue().toByteArray()), (short)((short)d.scale()));
    }

    private static void unpackLongStats(ObjectInspector oi, Object o, ColStatsProcessor.ColumnStatsField csf, ColumnStatisticsObj statsObj) {
        switch (csf) {
            case COUNT_NULLS: {
                long cn = ((LongObjectInspector)oi).get(o);
                statsObj.getStatsData().getLongStats().setNumNulls(cn);
                break;
            }
            case MIN: {
                long min = ((LongObjectInspector)oi).get(o);
                statsObj.getStatsData().getLongStats().setLowValue(min);
                break;
            }
            case MAX: {
                long max = ((LongObjectInspector)oi).get(o);
                statsObj.getStatsData().getLongStats().setHighValue(max);
                break;
            }
            case NDV: {
                long ndv = ((LongObjectInspector)oi).get(o);
                statsObj.getStatsData().getLongStats().setNumDVs(ndv);
                break;
            }
            case BITVECTOR: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                byte[] buf = ((BinaryObjectInspector)poi).getPrimitiveJavaObject(o);
                statsObj.getStatsData().getLongStats().setBitVectors(buf);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported column stat for LONG : " + (Object)((Object)csf));
            }
        }
    }

    private static void unpackStringStats(ObjectInspector oi, Object o, ColStatsProcessor.ColumnStatsField csf, ColumnStatisticsObj statsObj) {
        switch (csf) {
            case COUNT_NULLS: {
                long cn = ((LongObjectInspector)oi).get(o);
                statsObj.getStatsData().getStringStats().setNumNulls(cn);
                break;
            }
            case NDV: {
                long ndv = ((LongObjectInspector)oi).get(o);
                statsObj.getStatsData().getStringStats().setNumDVs(ndv);
                break;
            }
            case BITVECTOR: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                byte[] buf = ((BinaryObjectInspector)poi).getPrimitiveJavaObject(o);
                statsObj.getStatsData().getStringStats().setBitVectors(buf);
                break;
            }
            case MAX_LENGTH: {
                long max = ((LongObjectInspector)oi).get(o);
                statsObj.getStatsData().getStringStats().setMaxColLen(max);
                break;
            }
            case AVG_LENGTH: {
                double avg = ((DoubleObjectInspector)oi).get(o);
                statsObj.getStatsData().getStringStats().setAvgColLen(avg);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported column stat for STRING : " + (Object)((Object)csf));
            }
        }
    }

    private static void unpackBinaryStats(ObjectInspector oi, Object o, ColStatsProcessor.ColumnStatsField csf, ColumnStatisticsObj statsObj) {
        switch (csf) {
            case COUNT_NULLS: {
                long cn = ((LongObjectInspector)oi).get(o);
                statsObj.getStatsData().getBinaryStats().setNumNulls(cn);
                break;
            }
            case AVG_LENGTH: {
                double avg = ((DoubleObjectInspector)oi).get(o);
                statsObj.getStatsData().getBinaryStats().setAvgColLen(avg);
                break;
            }
            case MAX_LENGTH: {
                long v = ((LongObjectInspector)oi).get(o);
                statsObj.getStatsData().getBinaryStats().setMaxColLen(v);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported column stat for BINARY : " + (Object)((Object)csf));
            }
        }
    }

    private static void unpackDateStats(ObjectInspector oi, Object o, ColStatsProcessor.ColumnStatsField csf, ColumnStatisticsObj statsObj) {
        switch (csf) {
            case COUNT_NULLS: {
                long cn = ((LongObjectInspector)oi).get(o);
                statsObj.getStatsData().getDateStats().setNumNulls(cn);
                break;
            }
            case MIN: {
                DateWritableV2 min = ((DateObjectInspector)oi).getPrimitiveWritableObject(o);
                statsObj.getStatsData().getDateStats().setLowValue(new Date((long)min.getDays()));
                break;
            }
            case MAX: {
                DateWritableV2 max = ((DateObjectInspector)oi).getPrimitiveWritableObject(o);
                statsObj.getStatsData().getDateStats().setHighValue(new Date((long)max.getDays()));
                break;
            }
            case NDV: {
                long ndv = ((LongObjectInspector)oi).get(o);
                statsObj.getStatsData().getDateStats().setNumDVs(ndv);
                break;
            }
            case BITVECTOR: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                byte[] buf = ((BinaryObjectInspector)poi).getPrimitiveJavaObject(o);
                statsObj.getStatsData().getDateStats().setBitVectors(buf);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported column stat for DATE : " + (Object)((Object)csf));
            }
        }
    }

    private static void unpackTimestampStats(ObjectInspector oi, Object o, ColStatsProcessor.ColumnStatsField csf, ColumnStatisticsObj statsObj) {
        switch (csf) {
            case COUNT_NULLS: {
                long cn = ((LongObjectInspector)oi).get(o);
                statsObj.getStatsData().getTimestampStats().setNumNulls(cn);
                break;
            }
            case MIN: {
                TimestampWritableV2 min = ((TimestampObjectInspector)oi).getPrimitiveWritableObject(o);
                statsObj.getStatsData().getTimestampStats().setLowValue(new Timestamp(min.getSeconds()));
                break;
            }
            case MAX: {
                TimestampWritableV2 max = ((TimestampObjectInspector)oi).getPrimitiveWritableObject(o);
                statsObj.getStatsData().getTimestampStats().setHighValue(new Timestamp(max.getSeconds()));
                break;
            }
            case NDV: {
                long ndv = ((LongObjectInspector)oi).get(o);
                statsObj.getStatsData().getTimestampStats().setNumDVs(ndv);
                break;
            }
            case BITVECTOR: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                byte[] buf = ((BinaryObjectInspector)poi).getPrimitiveJavaObject(o);
                statsObj.getStatsData().getTimestampStats().setBitVectors(buf);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported column stat for TIMESTAMP : " + (Object)((Object)csf));
            }
        }
    }

    private static void unpackPrimitiveObject(ObjectInspector oi, Object o, ColStatsProcessor.ColumnStatsField csf, ColumnStatisticsObj statsObj) throws UnsupportedDoubleException {
        if (o == null) {
            return;
        }
        if (csf == ColStatsProcessor.ColumnStatsField.COLUMN_STATS_TYPE) {
            PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
            String s = ((StringObjectInspector)poi).getPrimitiveJavaObject(o);
            ColumnStatisticsData statsData = new ColumnStatisticsData();
            if (s.equalsIgnoreCase(ColStatsProcessor.ColumnStatsType.LONG.toString())) {
                LongColumnStatsDataInspector longStats = new LongColumnStatsDataInspector();
                statsData.setLongStats((LongColumnStatsData)longStats);
                statsObj.setStatsData(statsData);
            } else if (s.equalsIgnoreCase(ColStatsProcessor.ColumnStatsType.DOUBLE.toString())) {
                DoubleColumnStatsDataInspector doubleStats = new DoubleColumnStatsDataInspector();
                statsData.setDoubleStats((DoubleColumnStatsData)doubleStats);
                statsObj.setStatsData(statsData);
            } else if (s.equalsIgnoreCase(ColStatsProcessor.ColumnStatsType.STRING.toString())) {
                StringColumnStatsDataInspector stringStats = new StringColumnStatsDataInspector();
                statsData.setStringStats((StringColumnStatsData)stringStats);
                statsObj.setStatsData(statsData);
            } else if (s.equalsIgnoreCase(ColStatsProcessor.ColumnStatsType.BOOLEAN.toString())) {
                BooleanColumnStatsData booleanStats = new BooleanColumnStatsData();
                statsData.setBooleanStats(booleanStats);
                statsObj.setStatsData(statsData);
            } else if (s.equalsIgnoreCase(ColStatsProcessor.ColumnStatsType.BINARY.toString())) {
                BinaryColumnStatsData binaryStats = new BinaryColumnStatsData();
                statsData.setBinaryStats(binaryStats);
                statsObj.setStatsData(statsData);
            } else if (s.equalsIgnoreCase(ColStatsProcessor.ColumnStatsType.DECIMAL.toString())) {
                DecimalColumnStatsDataInspector decimalStats = new DecimalColumnStatsDataInspector();
                statsData.setDecimalStats((DecimalColumnStatsData)decimalStats);
                statsObj.setStatsData(statsData);
            } else if (s.equalsIgnoreCase(ColStatsProcessor.ColumnStatsType.DATE.toString())) {
                DateColumnStatsDataInspector dateStats = new DateColumnStatsDataInspector();
                statsData.setDateStats((DateColumnStatsData)dateStats);
                statsObj.setStatsData(statsData);
            } else if (s.equalsIgnoreCase(ColStatsProcessor.ColumnStatsType.TIMESTAMP.toString())) {
                TimestampColumnStatsDataInspector timestampStats = new TimestampColumnStatsDataInspector();
                statsData.setTimestampStats((TimestampColumnStatsData)timestampStats);
                statsObj.setStatsData(statsData);
            }
        } else if (statsObj.getStatsData().isSetBooleanStats()) {
            ColumnStatisticsObjTranslator.unpackBooleanStats(oi, o, csf, statsObj);
        } else if (statsObj.getStatsData().isSetLongStats()) {
            ColumnStatisticsObjTranslator.unpackLongStats(oi, o, csf, statsObj);
        } else if (statsObj.getStatsData().isSetDoubleStats()) {
            ColumnStatisticsObjTranslator.unpackDoubleStats(oi, o, csf, statsObj);
        } else if (statsObj.getStatsData().isSetStringStats()) {
            ColumnStatisticsObjTranslator.unpackStringStats(oi, o, csf, statsObj);
        } else if (statsObj.getStatsData().isSetBinaryStats()) {
            ColumnStatisticsObjTranslator.unpackBinaryStats(oi, o, csf, statsObj);
        } else if (statsObj.getStatsData().isSetDecimalStats()) {
            ColumnStatisticsObjTranslator.unpackDecimalStats(oi, o, csf, statsObj);
        } else if (statsObj.getStatsData().isSetDateStats()) {
            ColumnStatisticsObjTranslator.unpackDateStats(oi, o, csf, statsObj);
        } else if (statsObj.getStatsData().isSetTimestampStats()) {
            ColumnStatisticsObjTranslator.unpackTimestampStats(oi, o, csf, statsObj);
        }
    }

    static class UnsupportedDoubleException
    extends Exception {
        UnsupportedDoubleException() {
        }
    }
}

