/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ColumnStatsDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.ColumnStatisticsObjTranslator;
import org.apache.hadoop.hive.ql.stats.IStatsProcessor;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColStatsProcessor
implements IStatsProcessor {
    private static final transient Logger LOG = LoggerFactory.getLogger(ColStatsProcessor.class);
    private FetchOperator ftOp;
    private FetchWork fWork;
    private ColumnStatsDesc colStatDesc;
    private HiveConf conf;
    private boolean isStatsReliable;

    public ColStatsProcessor(ColumnStatsDesc colStats, HiveConf conf) {
        this.conf = conf;
        this.fWork = colStats.getFWork();
        this.colStatDesc = colStats;
        this.isStatsReliable = conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_RELIABLE);
    }

    @Override
    public void initialize(CompilationOpContext opContext) {
        try {
            this.fWork.initializeForFetch(opContext);
            JobConf job = new JobConf((Configuration)this.conf);
            this.ftOp = new FetchOperator(this.fWork, job);
        }
        catch (Exception e) {
            LOG.error("Failed to initialize", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public int process(Hive db, Table tbl) throws Exception {
        return this.persistColumnStats(db, tbl);
    }

    private List<ColumnStatistics> constructColumnStatsFromPackedRows(Table tbl) throws HiveException, MetaException, IOException {
        InspectableObject packedRow;
        String partName = null;
        List<String> colName = this.colStatDesc.getColName();
        List<String> colType = this.colStatDesc.getColType();
        boolean isTblLevel = this.colStatDesc.isTblLevel();
        ArrayList<ColumnStatistics> stats = new ArrayList<ColumnStatistics>();
        while ((packedRow = this.ftOp.getNextRow()) != null) {
            if (packedRow.oi.getCategory() != ObjectInspector.Category.STRUCT) {
                throw new HiveException("Unexpected object type encountered while unpacking row");
            }
            ArrayList<ColumnStatisticsObj> statsObjs = new ArrayList<ColumnStatisticsObj>();
            StructObjectInspector soi = (StructObjectInspector)packedRow.oi;
            List fields = soi.getAllStructFieldRefs();
            List values = soi.getStructFieldsDataAsList(packedRow.o);
            int pos = 0;
            for (int i = 0; i < colName.size(); ++i) {
                String columnName = colName.get(i);
                String columnType = colType.get(i);
                PrimitiveTypeInfo typeInfo = (PrimitiveTypeInfo)TypeInfoUtils.getTypeInfoFromTypeString((String)columnType);
                List<ColumnStatsField> columnStatsFields = ColumnStatsType.getColumnStats(typeInfo);
                try {
                    ColumnStatisticsObj statObj = ColumnStatisticsObjTranslator.readHiveColumnStatistics(columnName, columnType, columnStatsFields, pos, fields, values);
                    statsObjs.add(statObj);
                }
                catch (Exception e) {
                    if (this.isStatsReliable) {
                        throw new HiveException("Statistics collection failed while (hive.stats.reliable)", (Throwable)e);
                    }
                    LOG.debug("Because {} is infinite or NaN, we skip stats.", (Object)columnName, (Object)e);
                }
                pos += columnStatsFields.size();
            }
            if (statsObjs.isEmpty()) continue;
            if (!isTblLevel) {
                List<FieldSchema> partColSchema = tbl.getPartCols();
                ArrayList<String> partVals = new ArrayList<String>();
                for (int i = pos; i < pos + partColSchema.size(); ++i) {
                    Object partVal = ((PrimitiveObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).getPrimitiveJavaObject(values.get(i));
                    partVals.add(partVal == null ? this.conf.getVar(HiveConf.ConfVars.DEFAULTPARTITIONNAME) : partVal.toString());
                }
                partName = Warehouse.makePartName(partColSchema, partVals);
            }
            ColumnStatisticsDesc statsDesc = this.buildColumnStatsDesc(tbl, partName, isTblLevel);
            ColumnStatistics colStats = new ColumnStatistics();
            colStats.setStatsDesc(statsDesc);
            colStats.setStatsObj(statsObjs);
            colStats.setEngine("hive");
            stats.add(colStats);
        }
        this.ftOp.clearFetchContext();
        return stats;
    }

    private ColumnStatisticsDesc buildColumnStatsDesc(Table table, String partName, boolean isTblLevel) {
        String dbName = table.getDbName();
        assert (dbName != null);
        ColumnStatisticsDesc statsDesc = new ColumnStatisticsDesc();
        statsDesc.setDbName(dbName);
        statsDesc.setTableName(table.getTableName());
        statsDesc.setIsTblLevel(isTblLevel);
        if (!isTblLevel) {
            statsDesc.setPartName(partName);
        } else {
            statsDesc.setPartName(null);
        }
        return statsDesc;
    }

    public int persistColumnStats(Hive db, Table tbl) throws HiveException, MetaException, IOException {
        HiveTxnManager txnMgr;
        List<ColumnStatistics> colStats = this.constructColumnStatsFromPackedRows(tbl);
        if (colStats.isEmpty()) {
            return 0;
        }
        SetPartitionsStatsRequest request = new SetPartitionsStatsRequest(colStats, "hive");
        request.setNeedMerge(this.colStatDesc.isNeedMerge());
        HiveTxnManager hiveTxnManager = txnMgr = AcidUtils.isTransactionalTable(tbl) ? SessionState.get().getTxnMgr() : null;
        if (txnMgr != null) {
            request.setWriteId(txnMgr.getAllocatedTableWriteId(tbl.getDbName(), tbl.getTableName()));
            ValidWriteIdList validWriteIdList = AcidUtils.getTableValidWriteIdList((Configuration)this.conf, AcidUtils.getFullTableName(tbl.getDbName(), tbl.getTableName()));
            if (validWriteIdList != null) {
                request.setValidWriteIdList(validWriteIdList.toString());
            }
        }
        db.setPartitionColumnStatistics(request);
        return 0;
    }

    @Override
    public void setDpPartSpecs(Collection<Partition> dpPartSpecs) {
    }

    public static enum ColumnStatsType {
        BOOLEAN((List<ColumnStatsField>)ImmutableList.of((Object)((Object)ColumnStatsField.COLUMN_STATS_TYPE), (Object)((Object)ColumnStatsField.COUNT_TRUES), (Object)((Object)ColumnStatsField.COUNT_FALSES), (Object)((Object)ColumnStatsField.COUNT_NULLS))),
        LONG((List<ColumnStatsField>)ImmutableList.of((Object)((Object)ColumnStatsField.COLUMN_STATS_TYPE), (Object)((Object)ColumnStatsField.MIN), (Object)((Object)ColumnStatsField.MAX), (Object)((Object)ColumnStatsField.COUNT_NULLS), (Object)((Object)ColumnStatsField.NDV), (Object)((Object)ColumnStatsField.BITVECTOR))),
        DOUBLE((List<ColumnStatsField>)ImmutableList.of((Object)((Object)ColumnStatsField.COLUMN_STATS_TYPE), (Object)((Object)ColumnStatsField.MIN), (Object)((Object)ColumnStatsField.MAX), (Object)((Object)ColumnStatsField.COUNT_NULLS), (Object)((Object)ColumnStatsField.NDV), (Object)((Object)ColumnStatsField.BITVECTOR))),
        STRING((List<ColumnStatsField>)ImmutableList.of((Object)((Object)ColumnStatsField.COLUMN_STATS_TYPE), (Object)((Object)ColumnStatsField.MAX_LENGTH), (Object)((Object)ColumnStatsField.AVG_LENGTH), (Object)((Object)ColumnStatsField.COUNT_NULLS), (Object)((Object)ColumnStatsField.NDV), (Object)((Object)ColumnStatsField.BITVECTOR))),
        BINARY((List<ColumnStatsField>)ImmutableList.of((Object)((Object)ColumnStatsField.COLUMN_STATS_TYPE), (Object)((Object)ColumnStatsField.MAX_LENGTH), (Object)((Object)ColumnStatsField.AVG_LENGTH), (Object)((Object)ColumnStatsField.COUNT_NULLS))),
        DECIMAL((List<ColumnStatsField>)ImmutableList.of((Object)((Object)ColumnStatsField.COLUMN_STATS_TYPE), (Object)((Object)ColumnStatsField.MIN), (Object)((Object)ColumnStatsField.MAX), (Object)((Object)ColumnStatsField.COUNT_NULLS), (Object)((Object)ColumnStatsField.NDV), (Object)((Object)ColumnStatsField.BITVECTOR))),
        DATE((List<ColumnStatsField>)ImmutableList.of((Object)((Object)ColumnStatsField.COLUMN_STATS_TYPE), (Object)((Object)ColumnStatsField.MIN), (Object)((Object)ColumnStatsField.MAX), (Object)((Object)ColumnStatsField.COUNT_NULLS), (Object)((Object)ColumnStatsField.NDV), (Object)((Object)ColumnStatsField.BITVECTOR))),
        TIMESTAMP((List<ColumnStatsField>)ImmutableList.of((Object)((Object)ColumnStatsField.COLUMN_STATS_TYPE), (Object)((Object)ColumnStatsField.MIN), (Object)((Object)ColumnStatsField.MAX), (Object)((Object)ColumnStatsField.COUNT_NULLS), (Object)((Object)ColumnStatsField.NDV), (Object)((Object)ColumnStatsField.BITVECTOR)));

        private final List<ColumnStatsField> columnStats;

        private ColumnStatsType(List<ColumnStatsField> columnStats) {
            this.columnStats = columnStats;
        }

        public List<ColumnStatsField> getColumnStats() {
            return this.columnStats;
        }

        public static ColumnStatsType getColumnStatsType(PrimitiveTypeInfo typeInfo) throws SemanticException {
            switch (typeInfo.getPrimitiveCategory()) {
                case BOOLEAN: {
                    return BOOLEAN;
                }
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case TIMESTAMPLOCALTZ: {
                    return LONG;
                }
                case FLOAT: 
                case DOUBLE: {
                    return DOUBLE;
                }
                case DECIMAL: {
                    return DECIMAL;
                }
                case DATE: {
                    return DATE;
                }
                case TIMESTAMP: {
                    return TIMESTAMP;
                }
                case STRING: 
                case CHAR: 
                case VARCHAR: {
                    return STRING;
                }
                case BINARY: {
                    return BINARY;
                }
            }
            throw new SemanticException("Not supported type " + typeInfo.getTypeName() + " for statistics computation");
        }

        public static List<ColumnStatsField> getColumnStats(PrimitiveTypeInfo typeInfo) throws SemanticException {
            return ColumnStatsType.getColumnStatsType(typeInfo).getColumnStats();
        }
    }

    public static enum ColumnStatsField {
        COLUMN_STATS_TYPE("columntype"),
        COUNT_TRUES("counttrues"),
        COUNT_FALSES("countfalses"),
        COUNT_NULLS("countnulls"),
        MIN("min"),
        MAX("max"),
        NDV("numdistinctvalues"),
        BITVECTOR("ndvbitvector"),
        MAX_LENGTH("maxlength"),
        AVG_LENGTH("avglength");

        private final String fieldName;

        private ColumnStatsField(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }
}

