/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.BasicStatsWork;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.IStatsProcessor;
import org.apache.hadoop.hive.ql.stats.Partish;
import org.apache.hadoop.hive.ql.stats.StatsAggregator;
import org.apache.hadoop.hive.ql.stats.StatsCollectionContext;
import org.apache.hadoop.hive.ql.stats.StatsFactory;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicStatsTask
implements Serializable,
IStatsProcessor {
    private static final long serialVersionUID = 1L;
    private static final transient Logger LOG = LoggerFactory.getLogger(BasicStatsTask.class);
    private Table table;
    private Collection<Partition> dpPartSpecs = null;
    public boolean followedColStats;
    private BasicStatsWork work;
    private HiveConf conf;
    protected transient SessionState.LogHelper console;

    public BasicStatsTask(HiveConf conf, BasicStatsWork work) {
        this.conf = conf;
        this.console = new SessionState.LogHelper(LOG);
        this.work = work;
    }

    @Override
    public int process(Hive db, Table tbl) throws Exception {
        LOG.info("Executing stats task");
        this.table = tbl;
        return this.aggregateStats(db);
    }

    @Override
    public void initialize(CompilationOpContext opContext) {
    }

    public StageType getType() {
        return StageType.STATS;
    }

    public String getName() {
        return "STATS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private int aggregateStats(Hive db) {
        block30: {
            block27: {
                block28: {
                    statsAggregator = null;
                    ret = 0;
                    scc = null;
                    environmentContext = null;
                    environmentContext = new EnvironmentContext();
                    environmentContext.putToProperties("DO_NOT_UPDATE_STATS", "true");
                    wh = new Warehouse((Configuration)this.conf);
                    if (!this.getWork().getNoStatsAggregator() && !this.getWork().isNoScanAnalyzeCommand()) {
                        try {
                            scc = this.getContext();
                            statsAggregator = this.createStatsAggregator(scc, this.conf);
                        }
                        catch (HiveException e) {
                            if (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_RELIABLE)) {
                                throw e;
                            }
                            this.console.printError(ErrorMsg.STATS_SKIPPING_BY_ERROR.getErrorCodedMsg(new String[]{e.toString()}));
                        }
                    }
                    partitions = this.getPartitionsList(db);
                    tableFullName = this.table.getDbName() + "." + this.table.getTableName();
                    partishes = new ArrayList<Partish.PTable>();
                    if (partitions != null) ** GOTO lbl42
                    p = new Partish.PTable(this.table);
                    partishes.add(p);
                    basicStatsProcessor = new BasicStatsProcessor(p, this.work, this.conf, this.followedColStats);
                    basicStatsProcessor.collectFileStatus(wh, this.conf);
                    res = (Table)basicStatsProcessor.process(statsAggregator);
                    if (res != null) break block27;
                    var13_18 = 0;
                    if (statsAggregator == null) break block28;
                    statsAggregator.closeConnection(scc);
                }
                return var13_18;
            }
            try {
                block31: {
                    db.alterTable(tableFullName, res, environmentContext, true);
                    if (this.conf.getBoolVar(HiveConf.ConfVars.TEZ_EXEC_SUMMARY)) {
                        this.console.printInfo("Table " + tableFullName + " stats: [" + this.toString(p.getPartParameters()) + ']');
                    }
                    BasicStatsTask.LOG.info("Table " + tableFullName + " stats: [" + this.toString(p.getPartParameters()) + ']');
                    break block31;
lbl42:
                    // 1 sources

                    updates = new ArrayList<Partition>();
                    pool = this.buildBasicStatsExecutor();
                    futures = Lists.newLinkedList();
                    processors = Lists.newLinkedList();
                    try {
                        for (Partition partn : partitions) {
                            p = new Partish.PPart(this.table, partn);
                            bsp = new BasicStatsProcessor(p, this.work, this.conf, this.followedColStats);
                            processors.add(bsp);
                            futures.add(pool.submit(new Callable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    bsp.collectFileStatus(wh, BasicStatsTask.this.conf);
                                    return null;
                                }
                            }));
                        }
                        pool.shutdown();
                        for (Object future : futures) {
                            future.get();
                        }
                    }
                    catch (InterruptedException e) {
                        BasicStatsTask.LOG.debug("Cancelling " + futures.size() + " file stats lookup tasks");
                        for (Future future : futures) {
                            future.cancel(true);
                        }
                        if (this.work.isStatsReliable()) {
                            ret = 1;
                        }
                    }
                    finally {
                        if (pool != null) {
                            pool.shutdownNow();
                        }
                        BasicStatsTask.LOG.debug("Finished getting file stats of all partitions!");
                    }
                    for (BasicStatsProcessor basicStatsProcessor : processors) {
                        res = basicStatsProcessor.process(statsAggregator);
                        if (res == null) {
                            BasicStatsTask.LOG.info("Partition " + BasicStatsProcessor.access$200(basicStatsProcessor).getPartition().getSpec() + " stats: [0]");
                            continue;
                        }
                        updates.add((Partition)res);
                        if (this.conf.getBoolVar(HiveConf.ConfVars.TEZ_EXEC_SUMMARY)) {
                            this.console.printInfo("Partition " + BasicStatsProcessor.access$200(basicStatsProcessor).getPartition().getSpec() + " stats: [" + this.toString(BasicStatsProcessor.access$200(basicStatsProcessor).getPartParameters()) + ']');
                        }
                        BasicStatsTask.LOG.info("Partition " + BasicStatsProcessor.access$200(basicStatsProcessor).getPartition().getSpec() + " stats: [" + this.toString(BasicStatsProcessor.access$200(basicStatsProcessor).getPartParameters()) + ']');
                    }
                    if (!updates.isEmpty()) {
                        db.alterPartitions(tableFullName, updates, environmentContext, true);
                    }
                    if (this.work.isStatsReliable() && updates.size() != processors.size()) {
                        BasicStatsTask.LOG.info("Stats should be reliadble...however seems like there were some issue.. => ret 1");
                        ret = 1;
                    }
                }
                if (statsAggregator == null) break block30;
                statsAggregator.closeConnection(scc);
            }
            catch (Exception e) {
                try {
                    this.console.printInfo("[Warning] could not update stats.", "Failed with exception " + e.getMessage() + "\n" + StringUtils.stringifyException((Throwable)e));
                    if (this.work.isStatsReliable()) {
                        ret = 1;
                    }
                    if (statsAggregator == null) break block30;
                    statsAggregator.closeConnection(scc);
                }
                catch (Throwable var19_26) {
                    if (statsAggregator != null) {
                        statsAggregator.closeConnection(scc);
                    }
                    throw var19_26;
                }
            }
        }
        return ret;
    }

    private BasicStatsWork getWork() {
        return this.work;
    }

    private ExecutorService buildBasicStatsExecutor() {
        int poolSize = this.conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 1);
        poolSize = Math.max(poolSize, 1);
        ExecutorService pool = Executors.newFixedThreadPool(poolSize, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("stats-updater-thread-%d").build());
        LOG.debug("Getting file stats of all partitions. threadpool size:" + poolSize);
        return pool;
    }

    private StatsAggregator createStatsAggregator(StatsCollectionContext scc, HiveConf conf) throws HiveException {
        String statsImpl = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVESTATSDBCLASS);
        StatsFactory factory = StatsFactory.newFactory(statsImpl, (Configuration)conf);
        if (factory == null) {
            throw new HiveException(ErrorMsg.STATSPUBLISHER_NOT_OBTAINED.getErrorCodedMsg());
        }
        StatsPublisher statsPublisher = factory.getStatsPublisher();
        if (!statsPublisher.init(scc)) {
            throw new HiveException(ErrorMsg.STATSPUBLISHER_INITIALIZATION_ERROR.getErrorCodedMsg());
        }
        StatsAggregator statsAggregator = factory.getStatsAggregator();
        if (!statsAggregator.connect(scc)) {
            throw new HiveException(ErrorMsg.STATSAGGREGATOR_CONNECTION_ERROR.getErrorCodedMsg(new String[]{statsImpl}));
        }
        return statsAggregator;
    }

    private StatsCollectionContext getContext() throws HiveException {
        StatsCollectionContext scc = new StatsCollectionContext((Configuration)this.conf);
        Task sourceTask = this.getWork().getSourceTask();
        if (sourceTask == null) {
            throw new HiveException(ErrorMsg.STATSAGGREGATOR_SOURCETASK_NULL.getErrorCodedMsg());
        }
        scc.setTask(sourceTask);
        scc.setStatsTmpDir(this.getWork().getStatsTmpDir());
        return scc;
    }

    private String toString(Map<String, String> parameters) {
        StringBuilder builder = new StringBuilder();
        for (String statType : StatsSetupConst.SUPPORTED_STATS) {
            String value = parameters.get(statType);
            if (value == null) continue;
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(statType).append('=').append(value);
        }
        return builder.toString();
    }

    private List<Partition> getPartitionsList(Hive db) throws HiveException {
        if (this.work.getLoadFileDesc() != null) {
            return null;
        }
        ArrayList<Partition> list = new ArrayList<Partition>();
        if (this.work.getTableSpecs() != null) {
            BaseSemanticAnalyzer.TableSpec tblSpec = this.work.getTableSpecs();
            this.table = tblSpec.tableHandle;
            if (!this.table.isPartitioned()) {
                return null;
            }
            List<Partition> partitions = tblSpec.partitions;
            if (partitions != null) {
                for (Partition partn : partitions) {
                    list.add(partn);
                }
            }
        } else if (this.work.getLoadTableDesc() != null) {
            LoadTableDesc tbd = this.work.getLoadTableDesc();
            this.table = db.getTable(tbd.getTable().getTableName());
            if (!this.table.isPartitioned()) {
                return null;
            }
            DynamicPartitionCtx dpCtx = tbd.getDPCtx();
            if (dpCtx != null && dpCtx.getNumDPCols() > 0) {
                if (this.dpPartSpecs != null) {
                    list.addAll(this.dpPartSpecs);
                }
            } else {
                Partition partn = db.getPartition(this.table, tbd.getPartitionSpec(), false);
                list.add(partn);
            }
        }
        return list;
    }

    public Collection<Partition> getDpPartSpecs() {
        return this.dpPartSpecs;
    }

    @Override
    public void setDpPartSpecs(Collection<Partition> dpPartSpecs) {
        this.dpPartSpecs = dpPartSpecs;
    }

    private static class BasicStatsProcessor {
        private Partish partish;
        private List<FileStatus> partfileStatus;
        private boolean isMissingAcidState = false;
        private BasicStatsWork work;
        private boolean followedColStats1;

        public BasicStatsProcessor(Partish partish, BasicStatsWork work, HiveConf conf, boolean followedColStats2) {
            this.partish = partish;
            this.work = work;
            this.followedColStats1 = followedColStats2;
        }

        public Object process(StatsAggregator statsAggregator) throws HiveException, MetaException {
            Partish p = this.partish;
            Map<String, String> parameters = p.getPartParameters();
            if (this.work.isTargetRewritten()) {
                StatsSetupConst.setBasicStatsState(parameters, (String)"true");
            }
            if (!this.work.isExplicitAnalyze() && !this.followedColStats1) {
                StatsSetupConst.clearColumnStatsState(parameters);
            }
            if (this.partfileStatus == null) {
                String spec = this.partish.getPartition() == null ? this.partish.getTable().getTableName() : this.partish.getPartition().getSpec().toString();
                LOG.warn("Partition/partfiles is null for: " + spec);
                if (this.isMissingAcidState) {
                    MetaStoreServerUtils.clearQuickStats(parameters);
                    return p.getOutput();
                }
                return null;
            }
            if (this.work.isClearAggregatorStats()) {
                StatsSetupConst.setBasicStatsState(parameters, (String)"false");
            }
            MetaStoreServerUtils.populateQuickStats(this.partfileStatus, parameters);
            if (statsAggregator != null && (StatsSetupConst.areBasicStatsUptoDate(parameters) || p.isTransactionalTable())) {
                String prefix = this.getAggregationPrefix(p.getTable(), p.getPartition());
                this.updateStats(statsAggregator, parameters, prefix);
            }
            return p.getOutput();
        }

        public void collectFileStatus(Warehouse wh, HiveConf conf) throws MetaException, IOException {
            if (!this.partish.isTransactionalTable()) {
                this.partfileStatus = wh.getFileStatusesForSD(this.partish.getPartSd());
            } else {
                Path path = new Path(this.partish.getPartSd().getLocation());
                this.partfileStatus = AcidUtils.getAcidFilesForStats(this.partish.getTable(), path, (Configuration)conf, null);
                this.isMissingAcidState = true;
            }
        }

        private String getAggregationPrefix(Table table, Partition partition) throws MetaException {
            String prefix = this.getAggregationPrefix0(table, partition);
            String aggKey = prefix.endsWith("/") ? prefix : prefix + "/";
            return aggKey;
        }

        private String getAggregationPrefix0(Table table, Partition partition) throws MetaException {
            String prefix = FileUtils.escapePathName((String)table.getDbName()).toLowerCase() + "." + FileUtils.escapePathName((String)table.getTableName()).toLowerCase();
            if (partition != null) {
                return Utilities.join(prefix, Warehouse.makePartPath(partition.getSpec()));
            }
            return prefix;
        }

        private void updateStats(StatsAggregator statsAggregator, Map<String, String> parameters, String aggKey) throws HiveException {
            for (String statType : StatsSetupConst.STATS_REQUIRE_COMPUTE) {
                String originalValue;
                String value = statsAggregator.aggregateStats(aggKey, statType);
                if (value == null || value.isEmpty()) continue;
                long longValue = Long.parseLong(value);
                if (!this.work.isTargetRewritten() && (originalValue = parameters.get(statType)) != null) {
                    longValue += Long.parseLong(originalValue);
                }
                parameters.put(statType, String.valueOf(longValue));
            }
        }

        static /* synthetic */ Partish access$200(BasicStatsProcessor x0) {
            return x0.partish;
        }
    }
}

