/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.filtercontext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.filtercontext.DatabaseFilterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableFilterContext
extends HiveMetaStoreAuthorizableEvent {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseFilterContext.class);
    List<Table> tables = null;
    List<String> tableNames = null;
    String dbName = null;

    public TableFilterContext(List<Table> tables) {
        super(null);
        this.tables = tables;
        this.getAuthzContext();
    }

    public TableFilterContext(String dbName, List<String> tableNames) {
        super(null);
        this.dbName = dbName;
        this.tableNames = tableNames;
    }

    @Override
    public HiveMetaStoreAuthzInfo getAuthzContext() {
        HiveMetaStoreAuthzInfo ret = new HiveMetaStoreAuthzInfo(this.preEventContext, HiveOperationType.QUERY, this.getInputHObjs(), this.getOutputHObjs(), null);
        return ret;
    }

    private List<HivePrivilegeObject> getInputHObjs() {
        LOG.debug("==> TableFilterContext.getOutputHObjs()");
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        if (this.tables != null) {
            for (Table table : this.tables) {
                HivePrivilegeObject.HivePrivilegeObjectType type = HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW;
                HivePrivilegeObject.HivePrivObjectActionType objectActionType = HivePrivilegeObject.HivePrivObjectActionType.OTHER;
                HivePrivilegeObject hivePrivilegeObject = new HivePrivilegeObject(type, table.getDbName(), table.getTableName(), null, null, objectActionType, null, null, table.getOwner(), table.getOwnerType());
                ret.add(hivePrivilegeObject);
            }
        } else {
            for (String tableName : this.tableNames) {
                HivePrivilegeObject.HivePrivilegeObjectType type = HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW;
                HivePrivilegeObject.HivePrivObjectActionType objectActionType = HivePrivilegeObject.HivePrivObjectActionType.OTHER;
                HivePrivilegeObject hivePrivilegeObject = new HivePrivilegeObject(type, this.dbName, tableName, null, null, objectActionType, null, null);
                ret.add(hivePrivilegeObject);
            }
        }
        LOG.debug("<== TableFilterContext.getOutputHObjs(): ret=" + ret);
        return ret;
    }

    private List<HivePrivilegeObject> getOutputHObjs() {
        return Collections.emptyList();
    }

    public List<Table> getTables() {
        return this.tables;
    }
}

