/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.events.PreCreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateDatabaseEvent
extends HiveMetaStoreAuthorizableEvent {
    private static final Logger LOG = LoggerFactory.getLogger(CreateDatabaseEvent.class);
    private String COMMAND_STR = "create database";

    public CreateDatabaseEvent(PreEventContext preEventContext) {
        super(preEventContext);
    }

    @Override
    public HiveMetaStoreAuthzInfo getAuthzContext() {
        HiveMetaStoreAuthzInfo ret = new HiveMetaStoreAuthzInfo(this.preEventContext, HiveOperationType.CREATEDATABASE, this.getInputHObjs(), this.getOutputHObjs(), this.COMMAND_STR);
        return ret;
    }

    private List<HivePrivilegeObject> getInputHObjs() {
        return Collections.emptyList();
    }

    private List<HivePrivilegeObject> getOutputHObjs() {
        String uri;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> CreateDatabaseEvent.getOutputHObjs()");
        }
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        PreCreateDatabaseEvent event = (PreCreateDatabaseEvent)this.preEventContext;
        Database database = event.getDatabase();
        String string = uri = database != null ? database.getLocationUri() : "";
        if (database != null) {
            ret.add(this.getHivePrivilegeObject(database));
            if (StringUtils.isNotEmpty((CharSequence)uri)) {
                ret.add(this.getHivePrivilegeObjectDfsUri(uri));
            }
            this.COMMAND_STR = this.buildCommandString(this.COMMAND_STR, database);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== CreateDatabaseEvent.getOutputHObjs(): ret=" + ret);
            }
        }
        return ret;
    }

    private String buildCommandString(String cmdStr, Database db) {
        String ret = cmdStr;
        if (db != null) {
            String dbName = db.getName();
            ret = ret + (StringUtils.isNotEmpty((CharSequence)dbName) ? " " + dbName : "");
        }
        return ret;
    }
}

