/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.PreAlterTableEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterTableEvent
extends HiveMetaStoreAuthorizableEvent {
    private static final Logger LOG = LoggerFactory.getLogger(AlterTableEvent.class);
    private String COMMAND_STR = "alter table";

    public AlterTableEvent(PreEventContext preEventContext) {
        super(preEventContext);
    }

    @Override
    public HiveMetaStoreAuthzInfo getAuthzContext() {
        HiveMetaStoreAuthzInfo ret = new HiveMetaStoreAuthzInfo(this.preEventContext, this.getOperationType(), this.getInputHObjs(), this.getOutputHObjs(), this.COMMAND_STR);
        return ret;
    }

    private HiveOperationType getOperationType() {
        PreAlterTableEvent event = (PreAlterTableEvent)this.preEventContext;
        Table table = event.getNewTable();
        Table oldTable = event.getOldTable();
        String newUri = table != null ? this.getSdLocation(table.getSd()) : "";
        String oldUri = oldTable != null ? this.getSdLocation(oldTable.getSd()) : "";
        return StringUtils.equals((CharSequence)oldUri, (CharSequence)newUri) ? HiveOperationType.ALTERTABLE_ADDCOLS : HiveOperationType.ALTERTABLE_LOCATION;
    }

    private List<HivePrivilegeObject> getInputHObjs() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AlterTableEvent.getInputHObjs()");
        }
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        PreAlterTableEvent event = (PreAlterTableEvent)this.preEventContext;
        Table oldTable = event.getOldTable();
        ret.add(this.getHivePrivilegeObject(oldTable));
        this.COMMAND_STR = this.buildCommandString(this.COMMAND_STR, oldTable);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AlterTableEvent.getInputHObjs(): ret=" + ret);
        }
        return ret;
    }

    private List<HivePrivilegeObject> getOutputHObjs() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AlterTableEvent.getOutputHObjs()");
        }
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        PreAlterTableEvent event = (PreAlterTableEvent)this.preEventContext;
        Table newTable = event.getNewTable();
        ret.add(this.getHivePrivilegeObject(newTable));
        Table oldTable = event.getOldTable();
        String oldUri = oldTable != null ? this.getSdLocation(oldTable.getSd()) : "";
        String newUri = this.getSdLocation(newTable.getSd());
        if (!StringUtils.equals((CharSequence)oldUri, (CharSequence)newUri)) {
            ret.add(this.getHivePrivilegeObjectDfsUri(newUri));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AlterTableEvent.getOutputHObjs(): ret=" + ret);
        }
        return ret;
    }

    private String buildCommandString(String cmdStr, Table tbl) {
        String ret = cmdStr;
        if (tbl != null) {
            String tblName = tbl.getTableName();
            ret = ret + (StringUtils.isNotEmpty((CharSequence)tblName) ? " " + tblName : "");
        }
        return ret;
    }
}

