/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.metastore.DefaultMetaStoreFilterHookImpl;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObjectUtils;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class AuthorizationMetaStoreFilterHook
extends DefaultMetaStoreFilterHookImpl {
    public static final Logger LOG = LoggerFactory.getLogger(AuthorizationMetaStoreFilterHook.class);

    public AuthorizationMetaStoreFilterHook(Configuration conf) {
        super(conf);
    }

    public List<String> filterTableNames(String catName, String dbName, List<String> tableList) throws MetaException {
        List<HivePrivilegeObject> listObjs = this.getHivePrivObjects(dbName, tableList);
        return this.getTableNames(this.getFilteredObjects(listObjs));
    }

    public List<String> filterDatabases(List<String> dbList) throws MetaException {
        List<HivePrivilegeObject> listObjs = HivePrivilegeObjectUtils.getHivePrivDbObjects(dbList);
        return this.getDbNames(this.getFilteredObjects(listObjs));
    }

    private List<String> getDbNames(List<HivePrivilegeObject> filteredObjects) {
        ArrayList<String> tnames = new ArrayList<String>();
        for (HivePrivilegeObject obj : filteredObjects) {
            tnames.add(obj.getDbname());
        }
        return tnames;
    }

    private List<String> getTableNames(List<HivePrivilegeObject> filteredObjects) {
        ArrayList<String> tnames = new ArrayList<String>();
        for (HivePrivilegeObject obj : filteredObjects) {
            tnames.add(obj.getObjectName());
        }
        return tnames;
    }

    private List<HivePrivilegeObject> getFilteredObjects(List<HivePrivilegeObject> listObjs) throws MetaException {
        SessionState ss = SessionState.get();
        HiveAuthzContext.Builder authzContextBuilder = new HiveAuthzContext.Builder();
        authzContextBuilder.setUserIpAddress(ss.getUserIpAddress());
        authzContextBuilder.setForwardedAddresses(ss.getForwardedAddresses());
        try {
            return ss.getAuthorizerV2().filterListCmdObjects(listObjs, authzContextBuilder.build());
        }
        catch (HiveAuthzPluginException e) {
            LOG.error("Authorization error", (Throwable)((Object)e));
            throw new MetaException(e.getMessage());
        }
        catch (HiveAccessControlException e) {
            LOG.error("AccessControlException", (Throwable)((Object)e));
            throw new MetaException(e.getMessage());
        }
    }

    private List<HivePrivilegeObject> getHivePrivObjects(String dbName, List<String> tableList) {
        ArrayList<HivePrivilegeObject> objs = new ArrayList<HivePrivilegeObject>();
        for (String tname : tableList) {
            objs.add(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW, dbName, tname));
        }
        return objs;
    }

    public List<TableMeta> filterTableMetas(String catName, String dbName, List<TableMeta> tableMetas) throws MetaException {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (TableMeta tableMeta : tableMetas) {
            tableNames.add(tableMeta.getTableName());
        }
        List<String> filteredTableNames = this.filterTableNames(catName, dbName, tableNames);
        return tableMetas.stream().filter(e -> filteredTableNames.contains(e.getTableName())).collect(Collectors.toList());
    }
}

