/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.session.SessionState;

final class CommandAuthorizerV1 {
    private CommandAuthorizerV1() {
        throw new UnsupportedOperationException("CommandAuthorizerV1 should not be instantiated");
    }

    static void doAuthorization(HiveOperation op, BaseSemanticAnalyzer sem, SessionState ss, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws HiveException {
        if (op == null) {
            throw new HiveException("Operation should not be null");
        }
        Hive db = sem.getDb();
        HiveAuthorizationProvider authorizer = ss.getAuthorizer();
        CommandAuthorizerV1.authorizeOperation(op, sem, inputs, outputs, db, authorizer);
        CommandAuthorizerV1.authorizeOutputs(op, outputs, db, authorizer);
        CommandAuthorizerV1.authorizeInputs(op, sem, inputs, authorizer);
    }

    private static void authorizeOperation(HiveOperation op, BaseSemanticAnalyzer sem, Set<ReadEntity> inputs, Set<WriteEntity> outputs, Hive db, HiveAuthorizationProvider authorizer) throws HiveException {
        ImportSemanticAnalyzer isa;
        if (op.equals((Object)HiveOperation.CREATEDATABASE) || op.equals((Object)HiveOperation.ALTERDATABASE_LOCATION)) {
            authorizer.authorizeDbLevelOperations(op.getInputRequiredPrivileges(), op.getOutputRequiredPrivileges(), inputs, outputs);
        } else if (op.equals((Object)HiveOperation.CREATETABLE_AS_SELECT) || op.equals((Object)HiveOperation.CREATETABLE)) {
            authorizer.authorize(db.getDatabase(SessionState.get().getCurrentDatabase()), null, HiveOperation.CREATETABLE_AS_SELECT.getOutputRequiredPrivileges());
        } else if (op.equals((Object)HiveOperation.IMPORT) && !(isa = (ImportSemanticAnalyzer)sem).existsTable()) {
            authorizer.authorize(db.getDatabase(SessionState.get().getCurrentDatabase()), null, HiveOperation.CREATETABLE_AS_SELECT.getOutputRequiredPrivileges());
        }
    }

    private static void authorizeOutputs(HiveOperation op, Set<WriteEntity> outputs, Hive db, HiveAuthorizationProvider authorizer) throws HiveException {
        if (CollectionUtils.isEmpty(outputs)) {
            return;
        }
        for (WriteEntity write : outputs) {
            Partition part;
            if (write.isDummy() || write.isPathType()) continue;
            if (write.getType() == Entity.Type.DATABASE) {
                if (op.equals((Object)HiveOperation.IMPORT)) continue;
                authorizer.authorize(write.getDatabase(), null, op.getOutputRequiredPrivileges());
                continue;
            }
            if (write.getType() == Entity.Type.PARTITION && (part = db.getPartition(write.getTable(), write.getPartition().getSpec(), false)) != null) {
                authorizer.authorize(write.getPartition(), null, op.getOutputRequiredPrivileges());
                continue;
            }
            if (write.getTable() == null) continue;
            authorizer.authorize(write.getTable(), null, op.getOutputRequiredPrivileges());
        }
    }

    private static void authorizeInputs(HiveOperation op, BaseSemanticAnalyzer sem, Set<ReadEntity> inputs, HiveAuthorizationProvider authorizer) throws HiveException {
        if (CollectionUtils.isEmpty(inputs)) {
            return;
        }
        Map<String, Boolean> tableUsePartLevelAuth = CommandAuthorizerV1.getTableUsePartLevelAuth(inputs);
        HashMap<Table, List<String>> tab2Cols = new HashMap<Table, List<String>>();
        HashMap<Partition, List<String>> part2Cols = new HashMap<Partition, List<String>>();
        CommandAuthorizerV1.getTablePartitionUsedColumns(op, sem, tab2Cols, part2Cols, tableUsePartLevelAuth);
        HashSet<String> tableAuthChecked = new HashSet<String>();
        for (ReadEntity read : inputs) {
            Partition partition;
            if (read.isDummy() || read.isPathType() || !read.isDirect()) continue;
            if (read.getType() == Entity.Type.DATABASE) {
                authorizer.authorize(read.getDatabase(), op.getInputRequiredPrivileges(), null);
                continue;
            }
            Table tbl = read.getTable();
            if (tbl.isView() && sem instanceof SemanticAnalyzer) {
                tab2Cols.put(tbl, sem.getColumnAccessInfo().getTableToColumnAccessMap().get(tbl.getCompleteName()));
            }
            if (read.getPartition() != null && Boolean.TRUE.equals(tableUsePartLevelAuth.get((tbl = (partition = read.getPartition()).getTable()).getTableName()))) {
                List cols = (List)part2Cols.get(partition);
                if (cols != null && cols.size() > 0) {
                    authorizer.authorize(partition.getTable(), partition, cols, op.getInputRequiredPrivileges(), null);
                    continue;
                }
                authorizer.authorize(partition, op.getInputRequiredPrivileges(), null);
                continue;
            }
            CommandAuthorizerV1.authorizeTable(op, authorizer, tableUsePartLevelAuth, tab2Cols, tableAuthChecked, tbl);
        }
    }

    private static Map<String, Boolean> getTableUsePartLevelAuth(Set<ReadEntity> inputs) {
        HashMap<String, Boolean> tableUsePartLevelAuth = new HashMap<String, Boolean>();
        for (ReadEntity read : inputs) {
            boolean usePartLevelPriv;
            String tblName;
            if (read.isDummy() || read.isPathType() || read.getType() == Entity.Type.DATABASE) continue;
            Table tbl = read.getTable();
            if (read.getPartition() == null && (tbl == null || !tbl.isPartitioned()) || tableUsePartLevelAuth.get(tblName = tbl.getTableName()) != null) continue;
            boolean bl = usePartLevelPriv = tbl.getParameters().get("PARTITION_LEVEL_PRIVILEGE") != null && "TRUE".equalsIgnoreCase(tbl.getParameters().get("PARTITION_LEVEL_PRIVILEGE"));
            if (usePartLevelPriv) {
                tableUsePartLevelAuth.put(tblName, Boolean.TRUE);
                continue;
            }
            tableUsePartLevelAuth.put(tblName, Boolean.FALSE);
        }
        return tableUsePartLevelAuth;
    }

    private static void getTablePartitionUsedColumns(HiveOperation op, BaseSemanticAnalyzer sem, Map<Table, List<String>> tab2Cols, Map<Partition, List<String>> part2Cols, Map<String, Boolean> tableUsePartLevelAuth) throws HiveException {
        if (op.equals((Object)HiveOperation.CREATETABLE_AS_SELECT) || op.equals((Object)HiveOperation.QUERY)) {
            SemanticAnalyzer querySem = (SemanticAnalyzer)sem;
            ParseContext parseCtx = querySem.getParseContext();
            for (Map.Entry<String, TableScanOperator> topOpMap : querySem.getParseContext().getTopOps().entrySet()) {
                TableScanOperator tableScanOp = topOpMap.getValue();
                if (tableScanOp.isInsideView()) continue;
                Table tbl = ((TableScanDesc)tableScanOp.getConf()).getTableMetadata();
                ArrayList<String> cols = new ArrayList<String>();
                for (int id : tableScanOp.getNeededColumnIDs()) {
                    cols.add(tbl.getCols().get(id).getName());
                }
                if (tbl.isPartitioned() && Boolean.TRUE.equals(tableUsePartLevelAuth.get(tbl.getTableName()))) {
                    String aliasId = topOpMap.getKey();
                    PrunedPartitionList partsList = PartitionPruner.prune(tableScanOp, parseCtx, aliasId);
                    Set<Partition> parts = partsList.getPartitions();
                    for (Partition part : parts) {
                        List<String> existingCols = part2Cols.get(part);
                        if (existingCols == null) {
                            existingCols = new ArrayList<String>();
                        }
                        existingCols.addAll(cols);
                        part2Cols.put(part, existingCols);
                    }
                    continue;
                }
                List<String> existingCols = tab2Cols.get(tbl);
                if (existingCols == null) {
                    existingCols = new ArrayList<String>();
                }
                existingCols.addAll(cols);
                tab2Cols.put(tbl, existingCols);
            }
        }
    }

    private static void authorizeTable(HiveOperation op, HiveAuthorizationProvider authorizer, Map<String, Boolean> tableUsePartLevelAuth, Map<Table, List<String>> tab2Cols, Set<String> tableAuthChecked, Table tbl) throws HiveException {
        if (tbl != null && !tableAuthChecked.contains(tbl.getTableName()) && !Boolean.TRUE.equals(tableUsePartLevelAuth.get(tbl.getTableName()))) {
            List<String> cols = tab2Cols.get(tbl);
            if (cols != null && cols.size() > 0) {
                authorizer.authorize(tbl, null, cols, op.getInputRequiredPrivileges(), null);
            } else {
                authorizer.authorize(tbl, op.getInputRequiredPrivileges(), null);
            }
            tableAuthChecked.add(tbl.getTableName());
        }
    }
}

