/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import java.io.IOException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HMSHandler;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.security.authorization.HDFSPermissionPolicyProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProviderBase;
import org.apache.hadoop.hive.ql.security.authorization.HiveMetastoreAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePolicyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageBasedAuthorizationProvider
extends HiveAuthorizationProviderBase
implements HiveMetastoreAuthorizationProvider {
    private Warehouse wh;
    private boolean isRunFromMetaStore = false;
    private static Logger LOG = LoggerFactory.getLogger(StorageBasedAuthorizationProvider.class);

    private void initWh() throws MetaException, HiveException {
        if (this.wh == null) {
            if (!this.isRunFromMetaStore) {
                this.hive_db = new HiveAuthorizationProviderBase.HiveProxy(Hive.get(this.getConf(), StorageBasedAuthorizationProvider.class));
                this.wh = new Warehouse(this.getConf());
                if (this.wh == null) {
                    throw new IllegalStateException("Unable to initialize Warehouse from clientside.");
                }
            } else {
                throw new IllegalStateException("Uninitialized Warehouse from MetastoreHandler");
            }
        }
    }

    @Override
    public void init(Configuration conf) throws HiveException {
        this.hive_db = new HiveAuthorizationProviderBase.HiveProxy();
    }

    @Override
    public void authorizeDbLevelOperations(Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv, Collection<ReadEntity> inputs, Collection<WriteEntity> outputs) throws HiveException, AuthorizationException {
        Path root = null;
        try {
            this.initWh();
            root = this.wh.getWhRoot();
            for (WriteEntity writeEntity : outputs) {
                if (!WriteEntity.WriteType.PATH_WRITE.equals((Object)writeEntity.getWriteType())) continue;
                root = new Path(writeEntity.getName());
                break;
            }
            this.authorize(root, readRequiredPriv, writeRequiredPriv);
        }
        catch (MetaException ex) {
            throw this.hiveException((Exception)((Object)ex));
        }
    }

    @Override
    public void authorize(Database db, Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        try {
            this.initWh();
        }
        catch (MetaException ex) {
            throw this.hiveException((Exception)((Object)ex));
        }
        Path path = this.getDbLocation(db);
        DropPrivilegeExtractor privExtractor = new DropPrivilegeExtractor(readRequiredPriv, writeRequiredPriv);
        readRequiredPriv = privExtractor.getReadReqPriv();
        writeRequiredPriv = privExtractor.getWriteReqPriv();
        if (privExtractor.hasDropPrivilege()) {
            this.checkDeletePermission(path, this.getConf(), this.authenticator.getUserName());
        }
        this.authorize(path, readRequiredPriv, writeRequiredPriv);
    }

    private static boolean userHasProxyPrivilege(String user, Configuration conf) {
        try {
            if (MetaStoreServerUtils.checkUserHasHostProxyPrivileges((String)user, (Configuration)conf, (String)HMSHandler.getIPAddress())) {
                LOG.info("user {} has host proxy privilege.", (Object)user);
                return true;
            }
        }
        catch (Exception ex) {
            LOG.warn("Cannot obtain username to check for host proxy privilege", (Throwable)ex);
        }
        return false;
    }

    @Override
    public void authorize(Table table, Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        try {
            this.initWh();
        }
        catch (MetaException ex) {
            throw this.hiveException((Exception)((Object)ex));
        }
        DropPrivilegeExtractor privExtractor = new DropPrivilegeExtractor(readRequiredPriv, writeRequiredPriv);
        readRequiredPriv = privExtractor.getReadReqPriv();
        writeRequiredPriv = privExtractor.getWriteReqPriv();
        if (privExtractor.hasDropPrivilege || this.requireCreatePrivilege(readRequiredPriv) || this.requireCreatePrivilege(writeRequiredPriv)) {
            this.authorize(this.hive_db.getDatabase(table.getCatName(), table.getDbName()), new Privilege[0], new Privilege[]{Privilege.ALTER_DATA});
        }
        Path path = table.getDataLocation();
        if (privExtractor.hasDropPrivilege() && (table.getTableType() != TableType.EXTERNAL_TABLE || this.getConf().getBoolean(HiveConf.ConfVars.METASTORE_AUTHORIZATION_EXTERNALTABLE_DROP_CHECK.varname, HiveConf.ConfVars.METASTORE_AUTHORIZATION_EXTERNALTABLE_DROP_CHECK.defaultBoolVal))) {
            this.checkDeletePermission(path, this.getConf(), this.authenticator.getUserName());
        }
        if (path != null) {
            this.authorize(path, readRequiredPriv, writeRequiredPriv);
        }
    }

    private boolean requireCreatePrivilege(Privilege[] privs) {
        if (privs == null) {
            return false;
        }
        for (Privilege priv : privs) {
            if (!priv.equals(Privilege.CREATE)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void authorize(Partition part, Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        this.authorize(part.getTable(), part, readRequiredPriv, writeRequiredPriv);
    }

    private void authorize(Table table, Partition part, Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        DropPrivilegeExtractor privExtractor = new DropPrivilegeExtractor(readRequiredPriv, writeRequiredPriv);
        readRequiredPriv = privExtractor.getReadReqPriv();
        writeRequiredPriv = privExtractor.getWriteReqPriv();
        if (privExtractor.hasDropPrivilege()) {
            this.checkDeletePermission(part.getDataLocation(), this.getConf(), this.authenticator.getUserName());
        }
        if (part == null || part.getLocation() == null) {
            if (this.requireCreatePrivilege(readRequiredPriv) || this.requireCreatePrivilege(writeRequiredPriv)) {
                this.authorize(table, new Privilege[0], new Privilege[]{Privilege.ALTER_DATA});
            } else {
                this.authorize(table, readRequiredPriv, writeRequiredPriv);
            }
        } else {
            this.authorize(part.getDataLocation(), readRequiredPriv, writeRequiredPriv);
        }
    }

    private void checkDeletePermission(Path dataLocation, Configuration conf, String userName) throws HiveException {
        try {
            FileUtils.checkDeletePermission((Path)dataLocation, (Configuration)conf, (String)userName);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    @Override
    public void authorize(Table table, Partition part, List<String> columns, Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        this.authorize(table, part, readRequiredPriv, writeRequiredPriv);
    }

    @Override
    public void setMetaStoreHandler(IHMSHandler handler) {
        this.hive_db.setHandler(handler);
        this.wh = handler.getWh();
        this.isRunFromMetaStore = true;
    }

    protected FsAction getFsAction(Privilege priv) {
        switch (priv.getPriv()) {
            case ALL: {
                return FsAction.READ_WRITE;
            }
            case ALTER_DATA: {
                return FsAction.WRITE;
            }
            case ALTER_METADATA: {
                return FsAction.WRITE;
            }
            case CREATE: {
                return FsAction.WRITE;
            }
            case DROP: {
                return FsAction.WRITE;
            }
            case LOCK: {
                throw new AuthorizationException("StorageBasedAuthorizationProvider cannot handle LOCK privilege");
            }
            case SELECT: {
                return FsAction.READ;
            }
            case SHOW_DATABASE: {
                return FsAction.READ;
            }
        }
        throw new AuthorizationException("Unknown privilege");
    }

    protected EnumSet<FsAction> getFsActions(Privilege[] privs) {
        EnumSet<FsAction> actions = EnumSet.noneOf(FsAction.class);
        if (privs == null) {
            return actions;
        }
        for (Privilege priv : privs) {
            actions.add(this.getFsAction(priv));
        }
        return actions;
    }

    public void authorize(Path path, Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        try {
            EnumSet<FsAction> actions = this.getFsActions(readRequiredPriv);
            actions.addAll(this.getFsActions(writeRequiredPriv));
            if (actions.isEmpty()) {
                return;
            }
            this.checkPermissions(this.getConf(), path, actions);
        }
        catch (AccessControlException ex) {
            throw this.authorizationException(ex);
        }
        catch (LoginException ex) {
            throw this.authorizationException(ex);
        }
        catch (IOException ex) {
            throw this.hiveException(ex);
        }
    }

    protected void checkPermissions(Configuration conf, Path path, EnumSet<FsAction> actions) throws IOException, LoginException, HiveException {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        if (StorageBasedAuthorizationProvider.userHasProxyPrivilege(this.authenticator.getUserName(), conf)) {
            LOG.info("Path authorization is skipped for path {}.", (Object)path);
            return;
        }
        FileSystem fs = path.getFileSystem(conf);
        FileStatus pathStatus = FileUtils.getFileStatusOrNull((FileSystem)fs, (Path)path);
        if (pathStatus != null) {
            StorageBasedAuthorizationProvider.checkPermissions(fs, pathStatus, actions, this.authenticator.getUserName());
        } else if (path.getParent() != null) {
            FileStatus parStatus = null;
            for (Path par = path.getParent(); par != null && (parStatus = FileUtils.getFileStatusOrNull((FileSystem)fs, (Path)par)) == null; par = par.getParent()) {
            }
            StorageBasedAuthorizationProvider.checkPermissions(fs, parStatus, actions, this.authenticator.getUserName());
        }
    }

    protected static void checkPermissions(FileSystem fs, FileStatus stat, EnumSet<FsAction> actions, String user) throws IOException, AccessControlException, HiveException {
        if (stat == null) {
            return;
        }
        FsAction checkActions = FsAction.NONE;
        for (FsAction action : actions) {
            checkActions = checkActions.or(action);
        }
        try {
            FileUtils.checkFileAccessWithImpersonation((FileSystem)fs, (FileStatus)stat, (FsAction)checkActions, (String)user);
        }
        catch (Exception err) {
            if (err.getClass().getName().equals("org.apache.hadoop.fs.permission.AccessControlException")) {
                throw StorageBasedAuthorizationProvider.accessControlException(err);
            }
            throw new HiveException((Throwable)err);
        }
    }

    protected Path getDbLocation(Database db) throws HiveException {
        try {
            this.initWh();
            String location = db.getLocationUri();
            if (location == null) {
                return this.wh.getDefaultDatabasePath(db.getName());
            }
            return this.wh.getDnsPath(this.wh.getDatabasePath(db));
        }
        catch (MetaException ex) {
            throw this.hiveException((Exception)((Object)ex));
        }
    }

    private HiveException hiveException(Exception e) {
        return new HiveException((Throwable)e);
    }

    private AuthorizationException authorizationException(Exception e) {
        return new AuthorizationException(e);
    }

    private static AccessControlException accessControlException(Exception e) {
        AccessControlException ace = new AccessControlException(e.getMessage());
        ace.initCause(e);
        return ace;
    }

    @Override
    public void authorizeAuthorizationApiInvocation() throws HiveException, AuthorizationException {
    }

    @Override
    public HivePolicyProvider getHivePolicyProvider() throws HiveAuthzPluginException {
        return new HDFSPermissionPolicyProvider(this.getConf());
    }

    public class DropPrivilegeExtractor {
        private boolean hasDropPrivilege = false;
        private final Privilege[] readReqPriv;
        private final Privilege[] writeReqPriv;

        public DropPrivilegeExtractor(Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) {
            this.readReqPriv = this.extractDropPriv(readRequiredPriv);
            this.writeReqPriv = this.extractDropPriv(writeRequiredPriv);
        }

        private Privilege[] extractDropPriv(Privilege[] requiredPrivs) {
            if (requiredPrivs == null) {
                return null;
            }
            ArrayList<Privilege> privList = new ArrayList<Privilege>();
            for (Privilege priv : requiredPrivs) {
                if (priv.equals(Privilege.DROP)) {
                    this.hasDropPrivilege = true;
                    continue;
                }
                privList.add(priv);
            }
            return privList.toArray(new Privilege[0]);
        }

        public boolean hasDropPrivilege() {
            return this.hasDropPrivilege;
        }

        public void setHasDropPrivilege(boolean hasDropPrivilege) {
            this.hasDropPrivilege = hasDropPrivilege;
        }

        public Privilege[] getReadReqPriv() {
            return this.readReqPriv;
        }

        public Privilege[] getWriteReqPriv() {
            return this.writeReqPriv;
        }
    }
}

