/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.reexec;

import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.plan.mapper.PlanMapper;
import org.apache.hadoop.hive.ql.reexec.IReExecutionPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReExecuteLostAMQueryPlugin
implements IReExecutionPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ReExecuteLostAMQueryPlugin.class);
    private boolean retryPossible;
    private final Pattern lostAMContainerErrorPattern = Pattern.compile(".*AM Container for .* exited .* exitCode: -100.*");

    @Override
    public void initialize(Driver driver) {
        driver.getHookRunner().addOnFailureHook(new LocalHook());
    }

    @Override
    public void beforeExecute(int executionIndex, boolean explainReOptimization) {
    }

    @Override
    public boolean shouldReExecute(int executionNum) {
        return this.retryPossible;
    }

    @Override
    public void prepareToReExecute() {
    }

    @Override
    public boolean shouldReExecute(int executionNum, PlanMapper oldPlanMapper, PlanMapper newPlanMapper) {
        return this.retryPossible;
    }

    @Override
    public void afterExecute(PlanMapper planMapper, boolean successfull) {
    }

    class LocalHook
    implements ExecuteWithHookContext {
        LocalHook() {
        }

        @Override
        public void run(HookContext hookContext) throws Exception {
            Throwable exception;
            if (hookContext.getHookType() == HookContext.HookType.ON_FAILURE_HOOK && (exception = hookContext.getException()) != null && exception.getMessage() != null) {
                String unmanagedAMFailure = "AM record not found (likely died)";
                if (ReExecuteLostAMQueryPlugin.this.lostAMContainerErrorPattern.matcher(exception.getMessage()).matches() || exception.getMessage().contains(unmanagedAMFailure)) {
                    ReExecuteLostAMQueryPlugin.this.retryPossible = true;
                }
                LOG.info("Got exception message: {} retryPossible: {}", (Object)exception.getMessage(), (Object)ReExecuteLostAMQueryPlugin.this.retryPossible);
            }
        }
    }
}

