/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveVariableSource;
import org.apache.hadoop.hive.conf.VariableSubstitution;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.processors.CommandUtil;
import org.apache.hadoop.hive.ql.processors.SetProcessor;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.session.SessionState;

public class ResetProcessor
implements CommandProcessor {
    private static final String DEFAULT_ARG = "-d";

    @Override
    public CommandProcessorResponse run(String command) throws CommandProcessorException {
        return this.run(SessionState.get(), command);
    }

    @VisibleForTesting
    CommandProcessorResponse run(SessionState ss, String command) throws CommandProcessorException {
        CommandProcessorResponse authErrResp = CommandUtil.authorizeCommand(ss, HiveOperationType.RESET, Arrays.asList(command));
        if (authErrResp != null) {
            return authErrResp;
        }
        if (StringUtils.isBlank((CharSequence)(command = command.trim()))) {
            ResetProcessor.resetOverridesOnly(ss);
            return new CommandProcessorResponse();
        }
        String[] parts = command.split("\\s+");
        boolean isDefault = false;
        ArrayList<String> varnames = new ArrayList<String>(parts.length);
        for (String part : parts) {
            if (part.isEmpty()) continue;
            if (DEFAULT_ARG.equals(part)) {
                isDefault = true;
                continue;
            }
            varnames.add(part);
        }
        if (varnames.isEmpty()) {
            throw new CommandProcessorException(1, -1, "No variable names specified", "42000", null);
        }
        String variableNames = "";
        for (String varname : varnames) {
            if (isDefault) {
                if (!variableNames.isEmpty()) {
                    variableNames = variableNames + ", ";
                }
                variableNames = variableNames + varname;
                ResetProcessor.resetToDefault(ss, varname);
                continue;
            }
            ResetProcessor.resetOverrideOnly(ss, varname);
        }
        String message = isDefault ? "Resetting " + variableNames + " to default values" : null;
        return new CommandProcessorResponse(null, message);
    }

    private static void resetOverridesOnly(SessionState ss) {
        if (ss.getOverriddenConfigurations().isEmpty()) {
            return;
        }
        HiveConf conf = new HiveConf();
        for (String key : ss.getOverriddenConfigurations().keySet()) {
            ResetProcessor.setSessionVariableFromConf(ss, key, conf);
        }
        ss.getOverriddenConfigurations().clear();
    }

    private static void resetOverrideOnly(SessionState ss, String varname) {
        if (!ss.getOverriddenConfigurations().containsKey(varname)) {
            return;
        }
        ResetProcessor.setSessionVariableFromConf(ss, varname, new HiveConf());
        ss.getOverriddenConfigurations().remove(varname);
    }

    private static void setSessionVariableFromConf(SessionState ss, String varname, HiveConf conf) {
        String value = conf.get(varname);
        if (value != null) {
            SetProcessor.setConf(ss, varname, varname, value, false);
        }
    }

    private static CommandProcessorResponse resetToDefault(SessionState ss, String varname) throws CommandProcessorException {
        varname = varname.trim();
        try {
            String nonErrorMessage = null;
            if (varname.startsWith("hiveconf:")) {
                String propName = varname.substring("hiveconf:".length());
                nonErrorMessage = SetProcessor.setConf(varname, propName, ResetProcessor.getConfVar(propName).getDefaultValue(), false);
            } else if (varname.startsWith("metaconf:")) {
                String propName = varname.substring("metaconf:".length());
                HiveConf.ConfVars confVars = ResetProcessor.getConfVar(propName);
                Hive.get(ss.getConf()).setMetaConf(propName, new VariableSubstitution(new HiveVariableSource(){

                    public Map<String, String> getHiveVariable() {
                        return SessionState.get().getHiveVariables();
                    }
                }).substitute(ss.getConf(), confVars.getDefaultValue()));
            } else {
                String defaultVal = ResetProcessor.getConfVar(varname).getDefaultValue();
                nonErrorMessage = SetProcessor.setConf(varname, varname, defaultVal, true);
                if (varname.equals(HiveConf.ConfVars.HIVE_SESSION_HISTORY_ENABLED.toString())) {
                    SessionState.get().updateHistory(Boolean.parseBoolean(defaultVal), ss);
                }
            }
            return new CommandProcessorResponse(null, nonErrorMessage);
        }
        catch (Exception e) {
            Exception exception = e instanceof IllegalArgumentException ? null : e;
            throw new CommandProcessorException(1, -1, e.getMessage(), "42000", exception);
        }
    }

    private static HiveConf.ConfVars getConfVar(String propName) {
        HiveConf.ConfVars confVars = HiveConf.getConfVars((String)propName);
        if (confVars == null) {
            throw new IllegalArgumentException(propName + " not found");
        }
        return confVars;
    }

    @Override
    public void close() throws Exception {
    }
}

