/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import java.util.HashSet;
import java.util.Set;

public enum HiveCommand {
    SET,
    RESET,
    DFS,
    CRYPTO(true),
    ERASURE(true),
    ADD,
    LIST,
    LLAP_CLUSTER,
    LLAP_CACHE,
    RELOAD,
    DELETE,
    COMPILE;

    public static final boolean ONLY_FOR_TESTING = true;
    private boolean usedOnlyForTesting;
    private static final Set<String> COMMANDS;

    private HiveCommand() {
        this(false);
    }

    private HiveCommand(boolean onlyForTesting) {
        this.usedOnlyForTesting = onlyForTesting;
    }

    public boolean isOnlyForTesting() {
        return this.usedOnlyForTesting;
    }

    public static HiveCommand find(String[] command) {
        return HiveCommand.find(command, false);
    }

    public static HiveCommand find(String[] command, boolean findOnlyForTesting) {
        if (null == command) {
            return null;
        }
        String cmd = command[0];
        if (cmd != null) {
            cmd = cmd.trim().toUpperCase();
            if (command.length > 1 && "role".equalsIgnoreCase(command[1])) {
                return null;
            }
            if (command.length > 1 && "from".equalsIgnoreCase(command[1])) {
                return null;
            }
            if (command.length > 1 && "set".equalsIgnoreCase(command[0]) && "autocommit".equalsIgnoreCase(command[1])) {
                return null;
            }
            if (command.length > 1 && "llap".equalsIgnoreCase(command[0])) {
                return HiveCommand.getLlapSubCommand(command);
            }
            if (COMMANDS.contains(cmd)) {
                HiveCommand hiveCommand = HiveCommand.valueOf(cmd);
                if (findOnlyForTesting == hiveCommand.isOnlyForTesting()) {
                    return hiveCommand;
                }
                return null;
            }
        }
        return null;
    }

    private static HiveCommand getLlapSubCommand(String[] command) {
        if ("cluster".equalsIgnoreCase(command[1])) {
            return LLAP_CLUSTER;
        }
        if ("cache".equalsIgnoreCase(command[1])) {
            return LLAP_CACHE;
        }
        return null;
    }

    static {
        COMMANDS = new HashSet<String>();
        for (HiveCommand command : HiveCommand.values()) {
            COMMANDS.add(command.name());
        }
    }
}

