/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;

public enum HiveOperation {
    EXPLAIN("EXPLAIN", 920, null, null),
    LOAD("LOAD", 980, null, new Privilege[]{Privilege.ALTER_DATA}),
    EXPORT("EXPORT", 923, new Privilege[]{Privilege.SELECT}, null),
    IMPORT("IMPORT", 948, null, new Privilege[]{Privilege.ALTER_METADATA, Privilege.ALTER_DATA}),
    REPLDUMP("REPLDUMP", 1062, new Privilege[]{Privilege.ALL}, null),
    REPLLOAD("REPLLOAD", 1063, null, new Privilege[]{Privilege.ALL}),
    REPLSTATUS("REPLSTATUS", 1064, new Privilege[]{Privilege.SELECT}, null),
    CREATEDATABASE("CREATEDATABASE", 861, null, new Privilege[]{Privilege.CREATE}),
    DROPDATABASE("DROPDATABASE", 901, null, new Privilege[]{Privilege.DROP}),
    SWITCHDATABASE("SWITCHDATABASE", 1132, null, null, true, false),
    LOCKDB("LOCKDATABASE", 981, new Privilege[]{Privilege.LOCK}, null),
    UNLOCKDB("UNLOCKDATABASE", 1189, new Privilege[]{Privilege.LOCK}, null),
    DROPTABLE("DROPTABLE", 905, null, new Privilege[]{Privilege.DROP}),
    DESCTABLE("DESCTABLE", 894, null, null),
    DESCFUNCTION("DESCFUNCTION", 893, null, null),
    MSCK("MSCK", 987, null, null),
    ALTERTABLE_ADDCOLS("ALTERTABLE_ADDCOLS", 790, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_REPLACECOLS("ALTERTABLE_REPLACECOLS", 811, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_RENAMECOL("ALTERTABLE_RENAMECOL", 809, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_RENAMEPART("ALTERTABLE_RENAMEPART", 810, new Privilege[]{Privilege.DROP}, new Privilege[]{Privilege.CREATE}),
    ALTERTABLE_UPDATEPARTSTATS("ALTERTABLE_UPDATEPARTSTATS", new int[]{788, 787}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_UPDATETABLESTATS("ALTERTABLE_UPDATETABLESTATS", new int[]{821, 819}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_RENAME("ALTERTABLE_RENAME", 808, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_DROPPARTS("ALTERTABLE_DROPPARTS", new int[]{799, 825}, new Privilege[]{Privilege.DROP}, null),
    ALTERTABLE_ADDPARTS("ALTERTABLE_ADDPARTS", new int[]{792, 823}, null, new Privilege[]{Privilege.CREATE}),
    ALTERTABLE_TOUCH("ALTERTABLE_TOUCH", 816, null, null),
    ALTERTABLE_ARCHIVE("ALTERTABLE_ARCHIVE", 793, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERTABLE_UNARCHIVE("ALTERTABLE_UNARCHIVE", 817, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERTABLE_PROPERTIES("ALTERTABLE_PROPERTIES", new int[]{807, 800}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_OWNER("ALTERTABLE_OWNER", 805, null, null),
    ALTERTABLE_SERIALIZER("ALTERTABLE_SERIALIZER", 812, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_SERIALIZER("ALTERPARTITION_SERIALIZER", 784, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_SERDEPROPERTIES("ALTERTABLE_SERDEPROPERTIES", new int[]{813, 818}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_SERDEPROPERTIES("ALTERPARTITION_SERDEPROPERTIES", new int[]{785, 786}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_CLUSTER_SORT("ALTERTABLE_CLUSTER_SORT", 796, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ANALYZE_TABLE("ANALYZE_TABLE", 845, null, null),
    CACHE_METADATA("CACHE_METADATA", 851, new Privilege[]{Privilege.SELECT}, null),
    ALTERTABLE_BUCKETNUM("ALTERTABLE_BUCKETNUM", 794, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_BUCKETNUM("ALTERPARTITION_BUCKETNUM", 780, new Privilege[]{Privilege.ALTER_METADATA}, null),
    SHOWDATABASES("SHOWDATABASES", 1095, new Privilege[]{Privilege.SHOW_DATABASE}, null, true, false),
    SHOWTABLES("SHOWTABLES", 1101, null, null, true, false),
    SHOWCOLUMNS("SHOWCOLUMNS", 1093, null, null, true, false),
    SHOW_TABLESTATUS("SHOW_TABLESTATUS", 1112, null, null, true, false),
    SHOW_TBLPROPERTIES("SHOW_TBLPROPERTIES", 1113, null, null, true, false),
    SHOW_CREATEDATABASE("SHOW_CREATEDATABASE", 1104, new Privilege[]{Privilege.SELECT}, null),
    SHOW_CREATETABLE("SHOW_CREATETABLE", 1105, new Privilege[]{Privilege.SELECT}, null),
    SHOWFUNCTIONS("SHOWFUNCTIONS", 1097, null, null, true, false),
    SHOWPARTITIONS("SHOWPARTITIONS", 1100, null, null),
    SHOWLOCKS("SHOWLOCKS", new int[]{1098, 1096}, null, null, true, false),
    SHOWCONF("SHOWCONF", 1094, null, null),
    SHOWVIEWS("SHOWVIEWS", 1102, null, null, true, false),
    SHOWMATERIALIZEDVIEWS("SHOWMATERIALIZEDVIEWS", 1099, null, null, true, false),
    CREATEFUNCTION("CREATEFUNCTION", 862, null, null),
    DROPFUNCTION("DROPFUNCTION", 902, null, null),
    RELOADFUNCTION("RELOADFUNCTION", 1055, null, null),
    CREATEMACRO("CREATEMACRO", 863, null, null),
    DROPMACRO("DROPMACRO", 903, null, null),
    CREATEVIEW("CREATEVIEW", new int[]{866, 824}, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.CREATE}),
    CREATE_MATERIALIZED_VIEW("CREATE_MATERIALIZED_VIEW", 868, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.CREATE}),
    DROPVIEW("DROPVIEW", 906, null, new Privilege[]{Privilege.DROP}),
    DROP_MATERIALIZED_VIEW("DROP_MATERIALIZED_VIEW", 908, null, new Privilege[]{Privilege.DROP}),
    ALTER_MATERIALIZED_VIEW_REWRITE("ALTER_MATERIALIZED_VIEW_REWRITE", 832, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTER_MATERIALIZED_VIEW_REBUILD("ALTER_MATERIALIZED_VIEW_REBUILD", 831, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.CREATE, Privilege.DROP}),
    ALTERVIEW_PROPERTIES("ALTERVIEW_PROPERTIES", new int[]{827, 826}, null, null),
    LOCKTABLE("LOCKTABLE", 982, new Privilege[]{Privilege.LOCK}, null),
    UNLOCKTABLE("UNLOCKTABLE", 1190, new Privilege[]{Privilege.LOCK}, null),
    CREATEROLE("CREATEROLE", 864, null, null),
    DROPROLE("DROPROLE", 904, null, null),
    GRANT_PRIVILEGE("GRANT_PRIVILEGE", 936, null, null),
    REVOKE_PRIVILEGE("REVOKE_PRIVILEGE", 1071, null, null),
    SHOW_GRANT("SHOW_GRANT", 1107, null, null, true, false),
    GRANT_ROLE("GRANT_ROLE", 938, null, null),
    REVOKE_ROLE("REVOKE_ROLE", 1072, null, null),
    SHOW_ROLES("SHOW_ROLES", new int[]{1108, 1106, 1092}, null, null, true, false),
    SHOW_ROLE_PRINCIPALS("SHOW_ROLE_PRINCIPALS", 1110, null, null, true, false),
    SHOW_ROLE_GRANT("SHOW_ROLE_GRANT", 1109, null, null, true, false),
    ALTERTABLE_FILEFORMAT("ALTERTABLE_FILEFORMAT", 802, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_FILEFORMAT("ALTERPARTITION_FILEFORMAT", 781, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_LOCATION("ALTERTABLE_LOCATION", 803, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERPARTITION_LOCATION("ALTERPARTITION_LOCATION", 782, new Privilege[]{Privilege.ALTER_DATA}, null),
    CREATETABLE("CREATETABLE", 865, null, new Privilege[]{Privilege.CREATE}),
    TRUNCATETABLE("TRUNCATETABLE", 1179, null, new Privilege[]{Privilege.DROP}),
    CREATETABLE_AS_SELECT("CREATETABLE_AS_SELECT", null, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.CREATE}),
    QUERY("QUERY", 1049, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA, Privilege.CREATE}, true, false),
    ALTERDATABASE("ALTERDATABASE", 779, null, null),
    ALTERDATABASE_OWNER("ALTERDATABASE_OWNER", 778, null, null),
    ALTERDATABASE_LOCATION("ALTERDATABASE_LOCATION", new int[]{776, 777}, new Privilege[]{Privilege.ALTER_DATA}, null),
    DESCDATABASE("DESCDATABASE", 892, null, null),
    ALTERTABLE_MERGEFILES("ALTER_TABLE_MERGE", 804, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    ALTERPARTITION_MERGEFILES("ALTER_PARTITION_MERGE", 783, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    ALTERTABLE_SKEWED("ALTERTABLE_SKEWED", 814, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTBLPART_SKEWED_LOCATION("ALTERTBLPART_SKEWED_LOCATION", 815, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERTABLE_PARTCOLTYPE("ALTERTABLE_PARTCOLTYPE", 806, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    ALTERTABLE_EXCHANGEPARTITION("ALTERTABLE_EXCHANGEPARTITION", 801, new Privilege[]{Privilege.SELECT, Privilege.DELETE}, new Privilege[]{Privilege.INSERT}),
    ALTERTABLE_DROPCONSTRAINT("ALTERTABLE_DROPCONSTRAINT", 798, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_ADDCONSTRAINT("ALTERTABLE_ADDCONSTRAINT", 791, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_UPDATECOLUMNS("ALTERTABLE_UPDATECOLUMNS", 820, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERVIEW_RENAME("ALTERVIEW_RENAME", 828, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERVIEW_AS("ALTERVIEW_AS", 822, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_COMPACT("ALTERTABLE_COMPACT", 797, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    SHOW_COMPACTIONS("SHOW COMPACTIONS", 1103, null, null, true, false),
    SHOW_TRANSACTIONS("SHOW TRANSACTIONS", 1114, null, null, true, false),
    START_TRANSACTION("START TRANSACTION", 1120, null, null, false, false),
    COMMIT("COMMIT", 859, null, null, true, true),
    ROLLBACK("ROLLBACK", 1077, null, null, true, true),
    SET_AUTOCOMMIT("SET AUTOCOMMIT", 1090, null, null, true, false),
    ABORT_TRANSACTIONS("ABORT TRANSACTIONS", 768, null, null, false, false),
    KILL_QUERY("KILL QUERY", 969, null, null),
    CREATE_RESOURCEPLAN("CREATE RESOURCEPLAN", 870, null, null, false, false),
    SHOW_RESOURCEPLAN("SHOW RESOURCEPLAN", 1111, null, null, false, false),
    ALTER_RESOURCEPLAN("ALTER RESOURCEPLAN", new int[]{842, 838, 840, 841, 837, 836, 839}, null, null, false, false),
    DROP_RESOURCEPLAN("DROP RESOURCEPLAN", 910, null, null, false, false),
    CREATE_TRIGGER("CREATE TRIGGER", 872, null, null, false, false),
    ALTER_TRIGGER("ALTER TRIGGER", 844, null, null, false, false),
    DROP_TRIGGER("DROP TRIGGER", 912, null, null, false, false),
    CREATE_POOL("CREATE POOL", 869, null, null, false, false),
    ALTER_POOL("ALTER POOL", new int[]{833, 834, 835}, null, null, false, false),
    DROP_POOL("DROP POOL", 909, null, null, false, false),
    CREATE_MAPPING("CREATE MAPPING", 867, null, null, false, false),
    ALTER_MAPPING("ALTER MAPPING", 829, null, null, false, false),
    DROP_MAPPING("DROP MAPPING", 907, null, null, false, false),
    CREATE_SCHEDULED_QUERY("CREATE SCHEDULED QUERY", 871, null, null),
    ALTER_SCHEDULED_QUERY("ALTER SCHEDULED QUERY", 843, null, null),
    DROP_SCHEDULED_QUERY("DROP SCHEDULED QUERY", 911, null, null),
    PREPARE("PREPARE QUERY", 1031, null, null),
    EXECUTE("EXECUTE QUERY", 917, null, null);

    private final String operationName;
    private final int[] tokens;
    private final Privilege[] inputRequiredPrivileges;
    private final Privilege[] outputRequiredPrivileges;
    private final boolean allowedInTransaction;
    private final boolean requiresOpenTransaction;
    private static final Map<Integer, HiveOperation> TOKEN_TO_OPERATION;

    private HiveOperation(String operationName, int token, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges) {
        this(operationName, new int[]{token}, inputRequiredPrivileges, outputRequiredPrivileges, false, false);
    }

    private HiveOperation(String operationName, int[] tokens, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges) {
        this(operationName, tokens, inputRequiredPrivileges, outputRequiredPrivileges, false, false);
    }

    private HiveOperation(String operationName, int token, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges, boolean allowedInTransaction, boolean requiresOpenTransaction) {
        this(operationName, new int[]{token}, inputRequiredPrivileges, outputRequiredPrivileges, allowedInTransaction, requiresOpenTransaction);
    }

    private HiveOperation(String operationName, int[] tokens, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges, boolean allowedInTransaction, boolean requiresOpenTransaction) {
        this.operationName = operationName;
        this.tokens = tokens;
        this.inputRequiredPrivileges = inputRequiredPrivileges;
        this.outputRequiredPrivileges = outputRequiredPrivileges;
        this.requiresOpenTransaction = requiresOpenTransaction;
        this.allowedInTransaction = allowedInTransaction || requiresOpenTransaction;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public Privilege[] getInputRequiredPrivileges() {
        return this.inputRequiredPrivileges;
    }

    public Privilege[] getOutputRequiredPrivileges() {
        return this.outputRequiredPrivileges;
    }

    public boolean isAllowedInTransaction() {
        return this.allowedInTransaction;
    }

    public boolean isRequiresOpenTransaction() {
        return this.requiresOpenTransaction;
    }

    public static HiveOperation operationForToken(int token) {
        return TOKEN_TO_OPERATION.get(token);
    }

    static {
        TOKEN_TO_OPERATION = new HashMap<Integer, HiveOperation>();
        for (HiveOperation hiveOperation : HiveOperation.values()) {
            if (hiveOperation.tokens == null) continue;
            for (int token : hiveOperation.tokens) {
                TOKEN_TO_OPERATION.put(token, hiveOperation);
            }
        }
    }
}

