/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class ExprDynamicParamDesc
extends ExprNodeDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final transient char[] hexArray = "0123456789ABCDEF".toCharArray();
    private int index;
    private Object value;

    public ExprDynamicParamDesc() {
    }

    public ExprDynamicParamDesc(TypeInfo typeInfo, int index, Object value) {
        super(typeInfo);
        this.index = index;
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return "$" + this.index;
    }

    @Override
    public String getExprString() {
        return this.toString();
    }

    @Override
    public ExprNodeDesc clone() {
        return new ExprDynamicParamDesc(this.typeInfo, this.index, this.value);
    }

    @Override
    public boolean isSame(Object o) {
        if (!(o instanceof ExprDynamicParamDesc)) {
            return false;
        }
        ExprDynamicParamDesc dest = (ExprDynamicParamDesc)o;
        if (!this.typeInfo.equals((Object)dest.getTypeInfo())) {
            return false;
        }
        if (this.value == null ? dest.getValue() != null : !this.value.equals(dest.getValue())) {
            return false;
        }
        return dest.getIndex() == this.index;
    }

    @Override
    public int hashCode() {
        int superHashCode = super.hashCode();
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.appendSuper(superHashCode);
        builder.append(this.index);
        if (this.value != null) {
            builder.append(this.value);
        }
        return builder.toHashCode();
    }
}

