/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class DynamicPartitionCtx
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, String> partSpec;
    private int numDPCols;
    private int numSPCols;
    private String spPath;
    private Path rootPath;
    private int numBuckets;
    private List<String> spNames;
    private List<String> dpNames;
    private String defaultPartName;
    private int maxPartsPerNode;
    private Pattern whiteListPattern;

    public DynamicPartitionCtx() {
    }

    public DynamicPartitionCtx(List<String> partColNames, String defaultPartName, int maxParts) throws SemanticException {
        String confVal;
        this.partSpec = new LinkedHashMap<String, String>();
        this.spNames = new ArrayList<String>();
        this.dpNames = new ArrayList<String>();
        for (String colName : partColNames) {
            this.partSpec.put(colName, null);
            this.dpNames.add(colName);
        }
        this.numBuckets = 0;
        this.maxPartsPerNode = maxParts;
        this.defaultPartName = defaultPartName;
        this.numDPCols = this.dpNames.size();
        this.numSPCols = this.spNames.size();
        this.spPath = null;
        try {
            confVal = Hive.get().getMetaConf(HiveConf.ConfVars.METASTORE_PARTITION_NAME_WHITELIST_PATTERN.varname);
        }
        catch (HiveException e) {
            throw new SemanticException((Throwable)e);
        }
        this.whiteListPattern = confVal == null || confVal.isEmpty() ? null : Pattern.compile(confVal);
    }

    public DynamicPartitionCtx(Map<String, String> partSpec, String defaultPartName, int maxParts) throws SemanticException {
        String confVal;
        this.partSpec = partSpec;
        this.spNames = new ArrayList<String>();
        this.dpNames = new ArrayList<String>();
        this.numBuckets = 0;
        this.maxPartsPerNode = maxParts;
        this.defaultPartName = defaultPartName;
        for (Map.Entry<String, String> me : partSpec.entrySet()) {
            if (me.getValue() == null) {
                this.dpNames.add(me.getKey());
                continue;
            }
            this.spNames.add(me.getKey());
        }
        this.numDPCols = this.dpNames.size();
        this.numSPCols = this.spNames.size();
        this.spPath = this.numSPCols > 0 ? Warehouse.makeDynamicPartName(partSpec) : null;
        try {
            confVal = Hive.get().getMetaConf(HiveConf.ConfVars.METASTORE_PARTITION_NAME_WHITELIST_PATTERN.varname);
        }
        catch (HiveException e) {
            throw new SemanticException((Throwable)e);
        }
        this.whiteListPattern = confVal == null || confVal.isEmpty() ? null : Pattern.compile(confVal);
    }

    public DynamicPartitionCtx(DynamicPartitionCtx dp) {
        this.partSpec = dp.partSpec;
        this.numDPCols = dp.numDPCols;
        this.numSPCols = dp.numSPCols;
        this.spPath = dp.spPath;
        this.rootPath = dp.rootPath;
        this.numBuckets = dp.numBuckets;
        this.spNames = dp.spNames;
        this.dpNames = dp.dpNames;
        this.defaultPartName = dp.defaultPartName;
        this.maxPartsPerNode = dp.maxPartsPerNode;
        this.whiteListPattern = dp.whiteListPattern;
    }

    public Pattern getWhiteListPattern() {
        return this.whiteListPattern;
    }

    public int getMaxPartitionsPerNode() {
        return this.maxPartsPerNode;
    }

    public void setMaxPartitionsPerNode(int maxParts) {
        this.maxPartsPerNode = maxParts;
    }

    public String getDefaultPartitionName() {
        return this.defaultPartName;
    }

    public void setDefaultPartitionName(String pname) {
        this.defaultPartName = pname;
    }

    public void setNumBuckets(int bk) {
        this.numBuckets = bk;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    public void setRootPath(Path root) {
        this.rootPath = root;
    }

    public Path getRootPath() {
        return this.rootPath;
    }

    public List<String> getDPColNames() {
        return this.dpNames;
    }

    public void setDPColNames(List<String> dp) {
        this.dpNames = dp;
    }

    public List<String> getSPColNames() {
        return this.spNames;
    }

    public void setPartSpec(Map<String, String> ps) {
        this.partSpec = ps;
    }

    public Map<String, String> getPartSpec() {
        return this.partSpec;
    }

    public void setSPColNames(List<String> sp) {
        this.spNames = sp;
    }

    public void setNumDPCols(int dp) {
        this.numDPCols = dp;
    }

    public int getNumDPCols() {
        return this.numDPCols;
    }

    public void setNumSPCols(int sp) {
        this.numSPCols = sp;
    }

    public int getNumSPCols() {
        return this.numSPCols;
    }

    public void setSPPath(String sp) {
        this.spPath = sp;
    }

    public String getSPPath() {
        return this.spPath;
    }
}

