/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.ConditionalResolver;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.LoadMultiFilesDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalResolverMergeFiles
implements ConditionalResolver,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ConditionalResolverMergeFiles.class);

    @Override
    public List<Task<?>> getTasks(HiveConf conf, Object objCtx) {
        ConditionalResolverMergeFilesCtx ctx = (ConditionalResolverMergeFilesCtx)objCtx;
        String dirName = ctx.getDir();
        ArrayList resTsks = new ArrayList();
        long trgtSize = conf.getLongVar(HiveConf.ConfVars.HIVEMERGEMAPFILESSIZE);
        long avgConditionSize = conf.getLongVar(HiveConf.ConfVars.HIVEMERGEMAPFILESAVGSIZE);
        trgtSize = Math.max(trgtSize, avgConditionSize);
        Task<?> mvTask = ctx.getListTasks().get(0);
        Task<?> mrTask = ctx.getListTasks().get(1);
        Task<?> mrAndMvTask = ctx.getListTasks().get(2);
        try {
            Path dirPath = new Path(dirName);
            FileSystem inpFs = dirPath.getFileSystem((Configuration)conf);
            DynamicPartitionCtx dpCtx = ctx.getDPCtx();
            if (inpFs.exists(dirPath)) {
                int lbLevel;
                MapWork work = mrTask.getWork() instanceof MapredWork ? ((MapredWork)mrTask.getWork()).getMapWork() : (mrTask.getWork() instanceof TezWork ? (MapWork)((TezWork)mrTask.getWork()).getAllWork().get(0) : (mrTask.getWork() instanceof SparkWork ? (MapWork)((SparkWork)mrTask.getWork()).getAllWork().get(0) : (MapWork)mrTask.getWork()));
                int n = lbLevel = ctx.getLbCtx() == null ? 0 : ctx.getLbCtx().calculateListBucketingLevel();
                if (dpCtx != null && dpCtx.getNumDPCols() > 0) {
                    int numDPCols = dpCtx.getNumDPCols();
                    int dpLbLevel = numDPCols + lbLevel;
                    this.generateActualTasks(conf, resTsks, trgtSize, avgConditionSize, mvTask, mrTask, mrAndMvTask, dirPath, inpFs, ctx, work, dpLbLevel);
                } else if (lbLevel == 0) {
                    long totalSz = this.getMergeSize(inpFs, dirPath, avgConditionSize);
                    Utilities.FILE_OP_LOGGER.debug("merge resolve simple case - totalSz " + totalSz + " from " + dirPath);
                    if (totalSz >= 0L) {
                        this.setupMapRedWork(conf, work, trgtSize, totalSz);
                        resTsks.add(mrTask);
                    } else {
                        resTsks.add(mvTask);
                    }
                } else {
                    this.generateActualTasks(conf, resTsks, trgtSize, avgConditionSize, mvTask, mrTask, mrAndMvTask, dirPath, inpFs, ctx, work, lbLevel);
                }
            } else {
                Utilities.FILE_OP_LOGGER.info("Resolver returning movetask for " + dirPath);
                resTsks.add(mvTask);
            }
        }
        catch (IOException e) {
            LOG.warn("Exception while getting tasks", (Throwable)e);
        }
        assert (resTsks.size() == 1);
        return resTsks;
    }

    private void generateActualTasks(HiveConf conf, List<Task<?>> resTsks, long trgtSize, long avgConditionSize, Task<?> mvTask, Task<?> mrTask, Task<?> mrAndMvTask, Path dirPath, FileSystem inpFs, ConditionalResolverMergeFilesCtx ctx, MapWork work, int dpLbLevel) throws IOException {
        DynamicPartitionCtx dpCtx = ctx.getDPCtx();
        List statusList = HiveStatsUtils.getFileStatusRecurse((Path)dirPath, (int)dpLbLevel, (FileSystem)inpFs);
        FileStatus[] status = statusList.toArray(new FileStatus[statusList.size()]);
        Map<Path, PartitionDesc> ptpi = work.getPathToPartitionInfo();
        assert (ptpi.size() == 1);
        Path path = ptpi.keySet().iterator().next();
        PartitionDesc partDesc = ptpi.get(path);
        TableDesc tblDesc = partDesc.getTableDesc();
        Utilities.FILE_OP_LOGGER.debug("merge resolver removing " + path);
        work.removePathToPartitionInfo(path);
        Map<Path, List<String>> pta = work.getPathToAliases();
        assert (pta.size() == 1);
        path = pta.keySet().iterator().next();
        List<String> aliases = pta.get(path);
        work.removePathToAlias(path);
        long totalSz = 0L;
        boolean doMerge = false;
        ArrayList<Path> toMove = new ArrayList<Path>();
        for (int i = 0; i < status.length; ++i) {
            long len = this.getMergeSize(inpFs, status[i].getPath(), avgConditionSize);
            if (len >= 0L) {
                PartitionDesc pDesc;
                doMerge = true;
                totalSz += len;
                PartitionDesc partitionDesc = pDesc = dpCtx != null ? this.generateDPFullPartSpec(dpCtx, status, tblDesc, i) : partDesc;
                if (pDesc == null) {
                    Utilities.FILE_OP_LOGGER.warn("merger ignoring invalid DP path " + status[i].getPath());
                    continue;
                }
                Utilities.FILE_OP_LOGGER.debug("merge resolver will merge " + status[i].getPath());
                work.resolveDynamicPartitionStoredAsSubDirsMerge(conf, status[i].getPath(), tblDesc, aliases, pDesc);
                continue;
            }
            Utilities.FILE_OP_LOGGER.debug("merge resolver will move " + status[i].getPath());
            toMove.add(status[i].getPath());
        }
        if (doMerge) {
            this.setupMapRedWork(conf, work, trgtSize, totalSz);
            if (toMove.size() > 0) {
                resTsks.add(mrAndMvTask);
                Task<?> mergeAndMoveMoveTask = mrAndMvTask.getChildTasks().get(0);
                MoveWork mvWork = (MoveWork)mergeAndMoveMoveTask.getWork();
                LoadFileDesc lfd = mvWork.getLoadFileWork();
                Path targetDir = lfd.getTargetDir();
                ArrayList<Path> targetDirs = new ArrayList<Path>(toMove.size());
                for (int i = 0; i < toMove.size(); ++i) {
                    String[] moveStrSplits = ((Path)toMove.get(i)).toUri().toString().split("/");
                    Path target = targetDir;
                    for (int dpIndex = moveStrSplits.length - dpLbLevel; dpIndex < moveStrSplits.length; ++dpIndex) {
                        target = new Path(target, moveStrSplits[dpIndex]);
                    }
                    targetDirs.add(target);
                }
                LoadMultiFilesDesc lmfd = new LoadMultiFilesDesc(toMove, targetDirs, lfd.getIsDfsDir(), lfd.getColumns(), lfd.getColumnTypes());
                mvWork.setLoadFileWork(null);
                mvWork.setLoadTableWork(null);
                mvWork.setMultiFilesDesc(lmfd);
            } else {
                resTsks.add(mrTask);
            }
        } else {
            resTsks.add(mvTask);
        }
    }

    private PartitionDesc generateDPFullPartSpec(DynamicPartitionCtx dpCtx, FileStatus[] status, TableDesc tblDesc, int i) {
        LinkedHashMap<String, String> fullPartSpec = new LinkedHashMap<String, String>(dpCtx.getPartSpec());
        if (!Warehouse.makeSpecFromName(fullPartSpec, (Path)status[i].getPath(), new HashSet<String>(dpCtx.getPartSpec().keySet()))) {
            return null;
        }
        return new PartitionDesc(tblDesc, fullPartSpec);
    }

    private void setupMapRedWork(HiveConf conf, MapWork mWork, long targetSize, long totalSize) {
        mWork.setMaxSplitSize(targetSize);
        mWork.setMinSplitSize(targetSize);
        mWork.setMinSplitSizePerNode(targetSize);
        mWork.setMinSplitSizePerRack(targetSize);
        mWork.setIsMergeFromResolver(true);
    }

    private AverageSize getAverageSize(FileSystem inpFs, Path dirPath) {
        AverageSize error = new AverageSize(-1L, -1);
        try {
            FileStatus[] fStats = inpFs.listStatus(dirPath);
            long totalSz = 0L;
            int numFiles = 0;
            for (FileStatus fStat : fStats) {
                Utilities.FILE_OP_LOGGER.debug("Resolver looking at " + fStat.getPath());
                if (fStat.isDir()) {
                    AverageSize avgSzDir = this.getAverageSize(inpFs, fStat.getPath());
                    if (avgSzDir.getTotalSize() < 0L) {
                        return error;
                    }
                    totalSz += avgSzDir.getTotalSize();
                    numFiles += avgSzDir.getNumFiles();
                    continue;
                }
                totalSz += fStat.getLen();
                ++numFiles;
            }
            return new AverageSize(totalSz, numFiles);
        }
        catch (IOException e) {
            return error;
        }
    }

    private long getMergeSize(FileSystem inpFs, Path dirPath, long avgSize) {
        AverageSize averageSize = this.getAverageSize(inpFs, dirPath);
        if (averageSize.getTotalSize() < 0L) {
            return -1L;
        }
        if (averageSize.getNumFiles() <= 1) {
            return -1L;
        }
        if (averageSize.getTotalSize() / (long)averageSize.getNumFiles() < avgSize) {
            return averageSize.getTotalSize();
        }
        return -1L;
    }

    private static class AverageSize {
        private final long totalSize;
        private final int numFiles;

        public AverageSize(long totalSize, int numFiles) {
            this.totalSize = totalSize;
            this.numFiles = numFiles;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public int getNumFiles() {
            return this.numFiles;
        }
    }

    public static class ConditionalResolverMergeFilesCtx
    implements Serializable {
        private static final long serialVersionUID = 1L;
        List<Task<?>> listTasks;
        private String dir;
        private DynamicPartitionCtx dpCtx;
        private ListBucketingCtx lbCtx;

        public ConditionalResolverMergeFilesCtx() {
        }

        public ConditionalResolverMergeFilesCtx(List<Task<?>> listTasks, String dir) {
            this.listTasks = listTasks;
            this.dir = dir;
        }

        public String getDir() {
            return this.dir;
        }

        public List<Task<?>> getListTasks() {
            return this.listTasks;
        }

        public void setListTasks(List<Task<?>> listTasks) {
            this.listTasks = listTasks;
        }

        public DynamicPartitionCtx getDPCtx() {
            return this.dpCtx;
        }

        public void setDPCtx(DynamicPartitionCtx dp) {
            this.dpCtx = dp;
        }

        public ListBucketingCtx getLbCtx() {
            return this.lbCtx;
        }

        public void setLbCtx(ListBucketingCtx lbCtx) {
            this.lbCtx = lbCtx;
        }
    }
}

