/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OpTraits;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.plan.VectorDesc;

public abstract class AbstractOperatorDesc
implements OperatorDesc {
    protected boolean vectorMode = false;
    protected VectorDesc vectorDesc;
    protected Statistics statistics;
    protected transient OpTraits opTraits;
    protected transient Map<String, String> opProps;
    protected long memNeeded = 0L;
    protected long memAvailable = 0L;
    protected String runtimeStatsTmpDir;
    protected int bucketingVersion = -2;
    protected Map<String, ExprNodeDesc> colExprMap;

    @Override
    @Explain(skipHeader=true, displayName="Statistics")
    public Statistics getStatistics() {
        return this.statistics;
    }

    @Explain(skipHeader=true, displayName="Statistics", explainLevels={Explain.Level.USER})
    public String getUserLevelStatistics() {
        if (this.statistics == null) {
            return null;
        }
        return this.statistics.toUserLevelExplainString();
    }

    @Override
    public void setStatistics(Statistics statistics) {
        this.statistics = statistics;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone not supported");
    }

    public boolean getVectorMode() {
        return this.vectorMode;
    }

    public void setVectorMode(boolean vm) {
        this.vectorMode = vm;
    }

    public void setVectorDesc(VectorDesc vectorDesc) {
        this.vectorDesc = vectorDesc;
    }

    public VectorDesc getVectorDesc() {
        return this.vectorDesc;
    }

    @Override
    public OpTraits getTraits() {
        return this.opTraits;
    }

    @Override
    public void setTraits(OpTraits opTraits) {
        this.opTraits = opTraits;
    }

    @Override
    public Map<String, String> getOpProps() {
        return this.opProps;
    }

    public void setOpProps(Map<String, String> props) {
        this.opProps = props;
    }

    @Override
    public long getMemoryNeeded() {
        return this.memNeeded;
    }

    @Override
    public void setMemoryNeeded(long memNeeded) {
        this.memNeeded = memNeeded;
    }

    @Override
    public long getMaxMemoryAvailable() {
        return this.memAvailable;
    }

    @Override
    public void setMaxMemoryAvailable(long memoryAvailble) {
        this.memAvailable = memoryAvailble;
    }

    @Override
    public String getRuntimeStatsTmpDir() {
        return this.runtimeStatsTmpDir;
    }

    @Override
    public void setRuntimeStatsTmpDir(String runtimeStatsTmpDir) {
        this.runtimeStatsTmpDir = runtimeStatsTmpDir;
    }

    @Override
    public boolean isSame(OperatorDesc other) {
        return this.equals(other);
    }

    @Explain(displayName="columnExprMap", jsonOnly=true)
    public Map<String, String> getColumnExprMapForExplain() {
        if (this.colExprMap == null) {
            return null;
        }
        HashMap<String, String> colExprMapForExplain = new HashMap<String, String>();
        for (String col : this.colExprMap.keySet()) {
            colExprMapForExplain.put(col, this.colExprMap.get(col).getExprString());
        }
        return colExprMapForExplain;
    }

    @Override
    public Map<String, ExprNodeDesc> getColumnExprMap() {
        return this.colExprMap;
    }

    @Override
    public void setColumnExprMap(Map<String, ExprNodeDesc> colExprMap) {
        this.colExprMap = colExprMap;
    }

    @Override
    public void fillSignature(Map<String, Object> ret) {
        throw new RuntimeException();
    }

    @Override
    public int getBucketingVersion() {
        return this.bucketingVersion;
    }

    @Override
    public void setBucketingVersion(int bucketingVersion) {
        this.bucketingVersion = bucketingVersion;
    }
}

