/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.type;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.lib.CostLessRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SubqueryExpressionWalker;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSubquerySemanticException;
import org.apache.hadoop.hive.ql.parse.ASTErrorUtils;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.type.ExprFactory;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckCtx;
import org.apache.hadoop.hive.ql.plan.SubqueryType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TimestampLocalTZTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeCheckProcFactory<T> {
    static final Logger LOG = LoggerFactory.getLogger((String)TypeCheckProcFactory.class.getName());
    static final HashMap<Integer, String> SPECIAL_UNARY_OPERATOR_TEXT_MAP;
    static final HashMap<Integer, String> CONVERSION_FUNCTION_TEXT_MAP;
    static final HashSet<Integer> WINDOWING_TOKENS;
    private static final Object ALIAS_PLACEHOLDER;
    protected final ExprFactory<T> exprFactory;

    protected TypeCheckProcFactory(ExprFactory<T> exprFactory) {
        this.exprFactory = exprFactory;
    }

    protected Map<ASTNode, T> genExprNode(ASTNode expr, TypeCheckCtx tcCtx) throws SemanticException {
        HashMultimap astNodeToProcessor = HashMultimap.create();
        astNodeToProcessor.put((Object)995, (Object)this.getNullExprProcessor());
        astNodeToProcessor.put((Object)1023, (Object)this.getDynamicParameterProcessor());
        astNodeToProcessor.put((Object)392, (Object)this.getNumExprProcessor());
        astNodeToProcessor.put((Object)25, (Object)this.getNumExprProcessor());
        astNodeToProcessor.put((Object)393, (Object)this.getNumExprProcessor());
        astNodeToProcessor.put((Object)24, (Object)this.getStrExprProcessor());
        astNodeToProcessor.put((Object)404, (Object)this.getStrExprProcessor());
        astNodeToProcessor.put((Object)854, (Object)this.getStrExprProcessor());
        astNodeToProcessor.put((Object)1124, (Object)this.getStrExprProcessor());
        astNodeToProcessor.put((Object)160, (Object)this.getStrExprProcessor());
        astNodeToProcessor.put((Object)58, (Object)this.getStrExprProcessor());
        astNodeToProcessor.put((Object)371, (Object)this.getStrExprProcessor());
        astNodeToProcessor.put((Object)162, (Object)this.getStrExprProcessor());
        astNodeToProcessor.put((Object)40, (Object)this.getStrExprProcessor());
        astNodeToProcessor.put((Object)204, (Object)this.getStrExprProcessor());
        astNodeToProcessor.put((Object)318, (Object)this.getStrExprProcessor());
        astNodeToProcessor.put((Object)129, (Object)this.getStrExprProcessor());
        astNodeToProcessor.put((Object)1130, (Object)this.getStrExprProcessor());
        astNodeToProcessor.put((Object)341, (Object)this.getBoolExprProcessor());
        astNodeToProcessor.put((Object)136, (Object)this.getBoolExprProcessor());
        astNodeToProcessor.put((Object)882, (Object)this.getDateTimeExprProcessor());
        astNodeToProcessor.put((Object)1170, (Object)this.getDateTimeExprProcessor());
        astNodeToProcessor.put((Object)1172, (Object)this.getDateTimeExprProcessor());
        astNodeToProcessor.put((Object)964, (Object)this.getIntervalExprProcessor());
        astNodeToProcessor.put((Object)957, (Object)this.getIntervalExprProcessor());
        astNodeToProcessor.put((Object)962, (Object)this.getIntervalExprProcessor());
        astNodeToProcessor.put((Object)960, (Object)this.getIntervalExprProcessor());
        astNodeToProcessor.put((Object)955, (Object)this.getIntervalExprProcessor());
        astNodeToProcessor.put((Object)958, (Object)this.getIntervalExprProcessor());
        astNodeToProcessor.put((Object)959, (Object)this.getIntervalExprProcessor());
        astNodeToProcessor.put((Object)961, (Object)this.getIntervalExprProcessor());
        astNodeToProcessor.put((Object)1159, (Object)this.getColumnExprProcessor());
        astNodeToProcessor.put((Object)1127, (Object)this.getSubQueryExprProcessor());
        astNodeToProcessor.put((Object)772, (Object)this.getValueAliasProcessor());
        CostLessRuleDispatcher disp = new CostLessRuleDispatcher(this.getDefaultExprProcessor(), (SetMultimap<Integer, SemanticNodeProcessor>)astNodeToProcessor, tcCtx);
        SubqueryExpressionWalker ogw = new SubqueryExpressionWalker(disp);
        ArrayList topNodes = Lists.newArrayList((Object[])new Node[]{expr});
        LinkedHashMap<Node, Object> nodeOutputs = new LinkedHashMap<Node, Object>();
        ogw.startWalking(topNodes, nodeOutputs);
        return this.convert(nodeOutputs);
    }

    protected Map<ASTNode, T> convert(Map<Node, Object> outputs) {
        LinkedHashMap<ASTNode, Object> converted = new LinkedHashMap<ASTNode, Object>();
        for (Map.Entry<Node, Object> entry : outputs.entrySet()) {
            if (entry.getKey() instanceof ASTNode && (entry.getValue() == null || this.exprFactory.isExprInstance(entry.getValue()))) {
                converted.put((ASTNode)entry.getKey(), entry.getValue());
                continue;
            }
            LOG.warn("Invalid type entry " + entry);
        }
        return converted;
    }

    protected NullExprProcessor getNullExprProcessor() {
        return new NullExprProcessor();
    }

    protected DynamicParameterProcessor getDynamicParameterProcessor() {
        return new DynamicParameterProcessor();
    }

    protected NumExprProcessor getNumExprProcessor() {
        return new NumExprProcessor();
    }

    protected StrExprProcessor getStrExprProcessor() {
        return new StrExprProcessor();
    }

    protected BoolExprProcessor getBoolExprProcessor() {
        return new BoolExprProcessor();
    }

    protected DateTimeExprProcessor getDateTimeExprProcessor() {
        return new DateTimeExprProcessor();
    }

    protected IntervalExprProcessor getIntervalExprProcessor() {
        return new IntervalExprProcessor();
    }

    protected ColumnExprProcessor getColumnExprProcessor() {
        return new ColumnExprProcessor();
    }

    protected DefaultExprProcessor getDefaultExprProcessor() {
        return new DefaultExprProcessor();
    }

    protected SubQueryExprProcessor getSubQueryExprProcessor() {
        return new SubQueryExprProcessor();
    }

    private T processGByExpr(Node nd, Object procCtx) throws SemanticException {
        ASTNode expr = (ASTNode)nd;
        TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
        if (!ctx.isUseCaching() && ctx.getOuterRR() == null) {
            return null;
        }
        RowResolver input = ctx.getInputRR();
        T desc = null;
        if (ctx == null || input == null || !ctx.getAllowGBExprElimination()) {
            return null;
        }
        ColumnInfo colInfo = input.getExpression(expr);
        RowResolver usedRR = input;
        int offset = 0;
        RowResolver outerRR = ctx.getOuterRR();
        if (colInfo == null && outerRR != null) {
            colInfo = outerRR.getExpression(expr);
            usedRR = outerRR;
            offset = input.getColumnInfos().size();
        }
        if (colInfo != null) {
            desc = this.exprFactory.createColumnRefExpr(colInfo, usedRR, offset);
            ASTNode source = input.getExpressionSource(expr);
            if (source != null && ctx.getUnparseTranslator() != null) {
                ctx.getUnparseTranslator().addCopyTranslation(expr, source);
            }
            return desc;
        }
        return desc;
    }

    public static boolean isStringType(TypeInfo typeInfo) {
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;
        return typeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE && PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)(primitiveCategory = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory())) == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP;
    }

    public static String getFunctionText(ASTNode expr, boolean isFunction) {
        String funcText = null;
        if (!isFunction) {
            if (expr.getChildCount() == 1) {
                funcText = SPECIAL_UNARY_OPERATOR_TEXT_MAP.get(expr.getType());
            }
            if (funcText == null) {
                funcText = expr.getText();
            }
        } else {
            assert (expr.getChildCount() >= 1);
            int funcType = ((ASTNode)expr.getChild(0)).getType();
            if (funcText == null) {
                funcText = CONVERSION_FUNCTION_TEXT_MAP.get(funcType);
            }
            if (funcText == null) {
                funcText = ((ASTNode)expr.getChild(0)).getText();
            }
        }
        return BaseSemanticAnalyzer.unescapeIdentifier(funcText);
    }

    private SemanticNodeProcessor getValueAliasProcessor() {
        return new ValueAliasProcessor();
    }

    static {
        ALIAS_PLACEHOLDER = new Object();
        SPECIAL_UNARY_OPERATOR_TEXT_MAP = new HashMap();
        SPECIAL_UNARY_OPERATOR_TEXT_MAP.put(394, "positive");
        SPECIAL_UNARY_OPERATOR_TEXT_MAP.put(389, "negative");
        CONVERSION_FUNCTION_TEXT_MAP = new HashMap();
        CONVERSION_FUNCTION_TEXT_MAP.put(850, "boolean");
        CONVERSION_FUNCTION_TEXT_MAP.put(1173, "tinyint");
        CONVERSION_FUNCTION_TEXT_MAP.put(1118, "smallint");
        CONVERSION_FUNCTION_TEXT_MAP.put(952, "int");
        CONVERSION_FUNCTION_TEXT_MAP.put(847, "bigint");
        CONVERSION_FUNCTION_TEXT_MAP.put(928, "float");
        CONVERSION_FUNCTION_TEXT_MAP.put(900, "double");
        CONVERSION_FUNCTION_TEXT_MAP.put(1123, "string");
        CONVERSION_FUNCTION_TEXT_MAP.put(853, "char");
        CONVERSION_FUNCTION_TEXT_MAP.put(1199, "varchar");
        CONVERSION_FUNCTION_TEXT_MAP.put(848, "binary");
        CONVERSION_FUNCTION_TEXT_MAP.put(881, "date");
        CONVERSION_FUNCTION_TEXT_MAP.put(1169, "timestamp");
        CONVERSION_FUNCTION_TEXT_MAP.put(1171, "timestamp with local time zone");
        CONVERSION_FUNCTION_TEXT_MAP.put(963, "interval_year_month");
        CONVERSION_FUNCTION_TEXT_MAP.put(956, "interval_day_time");
        CONVERSION_FUNCTION_TEXT_MAP.put(887, "decimal");
        WINDOWING_TOKENS = new HashSet();
        WINDOWING_TOKENS.add(236);
        WINDOWING_TOKENS.add(1025);
        WINDOWING_TOKENS.add(899);
        WINDOWING_TOKENS.add(1119);
        WINDOWING_TOKENS.add(856);
        WINDOWING_TOKENS.add(1207);
        WINDOWING_TOKENS.add(1206);
        WINDOWING_TOKENS.add(1208);
        WINDOWING_TOKENS.add(344);
        WINDOWING_TOKENS.add(249);
        WINDOWING_TOKENS.add(144);
        WINDOWING_TOKENS.add(84);
        WINDOWING_TOKENS.add(1164);
        WINDOWING_TOKENS.add(1165);
        WINDOWING_TOKENS.add(996);
        WINDOWING_TOKENS.add(997);
    }

    public static class ValueAliasProcessor
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ASTNode astNode = (ASTNode)nd;
            ((TypeCheckCtx)procCtx).addColumnAlias(astNode.getChild(0).getText());
            return ALIAS_PLACEHOLDER;
        }
    }

    public class SubQueryExprProcessor
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ASTNode expr = (ASTNode)nd;
            ASTNode sqNode = (ASTNode)expr.getParent().getChild(1);
            if (!ctx.getallowSubQueryExpr()) {
                throw new CalciteSubquerySemanticException(SemanticAnalyzer.generateErrorMessage(sqNode, ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg("Currently SubQuery expressions are only allowed as Where and Having Clause predicates")));
            }
            Object desc = TypeCheckProcFactory.this.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            assert (expr.getChildren().size() == 3 || expr.getChildren().size() == 2);
            assert (expr.getChild(0).getType() == 1128);
            ASTNode subqueryOp = (ASTNode)expr.getChild(0);
            SubqueryType subqueryType = null;
            if (subqueryOp.getChildCount() > 0 && (subqueryOp.getChild(0).getType() == 162 || subqueryOp.getChild(0).getType() == 1130)) {
                subqueryType = SubqueryType.IN;
            } else if (subqueryOp.getChildCount() > 0 && (subqueryOp.getChild(0).getType() == 129 || subqueryOp.getChild(0).getType() == 1129)) {
                subqueryType = SubqueryType.EXISTS;
            } else if (subqueryOp.getChildCount() > 0 && subqueryOp.getChild(0).getType() == 308) {
                subqueryType = SubqueryType.SOME;
            } else if (subqueryOp.getChildCount() > 0 && subqueryOp.getChild(0).getType() == 32) {
                subqueryType = SubqueryType.ALL;
            } else if (subqueryOp.getChildCount() == 0) {
                subqueryType = SubqueryType.SCALAR;
            }
            Object res = TypeCheckProcFactory.this.exprFactory.createSubqueryExpr(ctx, expr, subqueryType, nodeOutputs);
            if (res == null) {
                ctx.setError(ASTErrorUtils.getMsg((String)ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(), (ASTNode)sqNode, (String)"Currently only IN & EXISTS SubQuery expressions are allowed"), sqNode);
            }
            return res;
        }
    }

    public class DefaultExprProcessor
    implements SemanticNodeProcessor {
        private boolean isRedundantConversionFunction(ASTNode expr, boolean isFunction, List<T> children) {
            if (!isFunction) {
                return false;
            }
            if (children.size() != 1) {
                return false;
            }
            String funcText = CONVERSION_FUNCTION_TEXT_MAP.get(((ASTNode)expr.getChild(0)).getType());
            if (funcText == null) {
                return false;
            }
            return TypeCheckProcFactory.this.exprFactory.getTypeInfo(children.get(0)).getTypeName().equalsIgnoreCase(funcText);
        }

        public T getFuncExprNodeDescWithUdfData(String udfName, TypeInfo typeInfo, T ... children) throws SemanticException {
            FunctionInfo fi;
            try {
                fi = TypeCheckProcFactory.this.exprFactory.getFunctionInfo(udfName);
            }
            catch (SemanticException e) {
                throw new UDFArgumentException((Throwable)e);
            }
            if (fi == null) {
                throw new UDFArgumentException(udfName + " not found.");
            }
            if (!fi.isGenericUDF()) {
                throw new UDFArgumentException(udfName + " is an aggregation function or a table function.");
            }
            ArrayList childrenList = new ArrayList(children.length);
            childrenList.addAll(Arrays.asList(children));
            return TypeCheckProcFactory.this.exprFactory.createFuncCallExpr(typeInfo, fi, udfName, childrenList);
        }

        public T getFuncExprNodeDesc(String udfName, T ... children) throws SemanticException {
            return this.getFuncExprNodeDescWithUdfData(udfName, null, children);
        }

        public T createConversionCast(T column, PrimitiveTypeInfo tableFieldTypeInfo) throws SemanticException {
            String baseType = TypeInfoUtils.getBaseName((String)tableFieldTypeInfo.getTypeName());
            return TypeCheckProcFactory.this.getDefaultExprProcessor().getFuncExprNodeDescWithUdfData(baseType, (TypeInfo)tableFieldTypeInfo, column);
        }

        protected void validateUDF(ASTNode expr, boolean isFunction, TypeCheckCtx ctx, FunctionInfo fi, List<T> children) throws SemanticException {
            if (TypeCheckProcFactory.this.exprFactory.isCompareFunction(fi) && children.size() == 2) {
                TypeInfo oiTypeInfo0 = TypeCheckProcFactory.this.exprFactory.getTypeInfo(children.get(0));
                TypeInfo oiTypeInfo1 = TypeCheckProcFactory.this.exprFactory.getTypeInfo(children.get(1));
                SessionState ss = SessionState.get();
                HiveConf conf = ss != null ? ss.getConf() : new Configuration();
                SessionState.LogHelper console = new SessionState.LogHelper(LOG);
                if (TypeInfoUtils.isConversionLossy((TypeInfo)oiTypeInfo0, (TypeInfo)oiTypeInfo1)) {
                    String error = HiveConf.StrictChecks.checkTypeSafety((Configuration)conf);
                    if (error != null) {
                        throw new UDFArgumentException(error);
                    }
                    String tName0 = oiTypeInfo0.getTypeName();
                    String tName1 = oiTypeInfo1.getTypeName();
                    console.printError("WARNING: Comparing " + tName0 + " and " + tName1 + " may result in loss of information.");
                }
            }
            if (fi.getGenericUDTF() != null) {
                throw new SemanticException(ErrorMsg.UDTF_INVALID_LOCATION.getMsg());
            }
            if (fi.getGenericUDAFResolver() != null) {
                if (isFunction) {
                    throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.UDAF_INVALID_LOCATION.getMsg(), (ASTNode)((ASTNode)expr.getChild(0))));
                }
                throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.UDAF_INVALID_LOCATION.getMsg(), (ASTNode)expr));
            }
            if (!ctx.getAllowStatefulFunctions() && TypeCheckProcFactory.this.exprFactory.isStateful(fi)) {
                throw new SemanticException(ErrorMsg.UDF_STATEFUL_INVALID_LOCATION.getMsg());
            }
        }

        private void insertCast(String funcText, List<T> children) throws SemanticException {
            if ((funcText.equals("substring") || funcText.equals("concat")) && children.size() > 0 && !TypeCheckProcFactory.isStringType(TypeCheckProcFactory.this.exprFactory.getTypeInfo(children.get(0)))) {
                Object newColumn = this.createConversionCast(children.get(0), TypeInfoFactory.stringTypeInfo);
                children.set(0, newColumn);
            }
            if (funcText.equalsIgnoreCase("and") || funcText.equalsIgnoreCase("or") || funcText.equalsIgnoreCase("not") || funcText.equalsIgnoreCase("!")) {
                for (int i = 0; i < children.size(); ++i) {
                    Object child = children.get(i);
                    TypeInfo typeInfo = TypeCheckProcFactory.this.exprFactory.getTypeInfo(child);
                    if (TypeInfoFactory.booleanTypeInfo.accept(typeInfo)) continue;
                    if (typeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE) {
                        children.set(i, this.createConversionCast(child, TypeInfoFactory.booleanTypeInfo));
                        continue;
                    }
                    child = TypeCheckProcFactory.this.exprFactory.createFuncCallExpr((TypeInfo)TypeInfoFactory.booleanTypeInfo, TypeCheckProcFactory.this.exprFactory.getFunctionInfo("isnotnull"), "isnotnull", Arrays.asList(child));
                    children.set(i, child);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected T getXpathOrFuncExprNodeDesc(ASTNode node, boolean isFunction, List<T> children, TypeCheckCtx ctx) throws SemanticException {
            FunctionInfo fi;
            Object expr;
            if (this.isRedundantConversionFunction(node, isFunction, children)) {
                assert (children.size() == 1);
                assert (children.get(0) != null);
                return children.get(0);
            }
            String funcText = TypeCheckProcFactory.getFunctionText(node, isFunction);
            if (funcText.equals(".")) {
                boolean isList;
                assert (children.size() == 2);
                assert (TypeCheckProcFactory.this.exprFactory.isConstantExpr(children.get(1)));
                Object object = children.get(0);
                String fieldNameString = TypeCheckProcFactory.this.exprFactory.getConstantValueAsString(children.get(1));
                TypeInfo objectTypeInfo = TypeCheckProcFactory.this.exprFactory.getTypeInfo(object);
                boolean bl = isList = objectTypeInfo.getCategory() == ObjectInspector.Category.LIST;
                if (isList) {
                    objectTypeInfo = ((ListTypeInfo)objectTypeInfo).getListElementTypeInfo();
                }
                if (objectTypeInfo.getCategory() != ObjectInspector.Category.STRUCT) {
                    throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_DOT.getMsg(), (ASTNode)node));
                }
                TypeInfo t = ((StructTypeInfo)objectTypeInfo).getStructFieldTypeInfo(fieldNameString);
                if (isList) {
                    t = TypeInfoFactory.getListTypeInfo((TypeInfo)t);
                }
                expr = TypeCheckProcFactory.this.exprFactory.createNestedColumnRefExpr(t, children.get(0), fieldNameString, isList);
            } else if (funcText.equals("[")) {
                funcText = "index";
                fi = TypeCheckProcFactory.this.exprFactory.getFunctionInfo(funcText);
                if (!ctx.getallowIndexExpr()) {
                    throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_FUNCTION.getMsg(), (ASTNode)node));
                }
                assert (children.size() == 2);
                TypeInfo myt = TypeCheckProcFactory.this.exprFactory.getTypeInfo(children.get(0));
                if (myt.getCategory() == ObjectInspector.Category.LIST) {
                    if (!TypeInfoUtils.implicitConvertible((TypeInfo)TypeCheckProcFactory.this.exprFactory.getTypeInfo(children.get(1)), (TypeInfo)TypeInfoFactory.intTypeInfo)) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(node, ErrorMsg.INVALID_ARRAYINDEX_TYPE.getMsg()));
                    }
                    TypeInfo t = ((ListTypeInfo)myt).getListElementTypeInfo();
                    expr = TypeCheckProcFactory.this.exprFactory.createFuncCallExpr(t, fi, funcText, children);
                } else {
                    if (myt.getCategory() != ObjectInspector.Category.MAP) throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.NON_COLLECTION_TYPE.getMsg(), (ASTNode)node, (String)myt.getTypeName()));
                    if (!TypeInfoUtils.implicitConvertible((TypeInfo)TypeCheckProcFactory.this.exprFactory.getTypeInfo(children.get(1)), (TypeInfo)((MapTypeInfo)myt).getMapKeyTypeInfo())) {
                        throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_MAPINDEX_TYPE.getMsg(), (ASTNode)node));
                    }
                    TypeInfo t = ((MapTypeInfo)myt).getMapValueTypeInfo();
                    expr = TypeCheckProcFactory.this.exprFactory.createFuncCallExpr(t, fi, funcText, children);
                }
            } else {
                Object constantExpr;
                fi = TypeCheckProcFactory.this.exprFactory.getFunctionInfo(funcText);
                if (fi == null) {
                    if (!isFunction) throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_FUNCTION.getMsg(), (ASTNode)node));
                    throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_FUNCTION.getMsg(), (ASTNode)((ASTNode)node.getChild(0))));
                }
                if (!fi.isNative()) {
                    ctx.getUnparseTranslator().addIdentifierTranslation((ASTNode)node.getChild(0));
                }
                TypeInfo typeInfo = isFunction ? this.getTypeInfo((ASTNode)node.getChild(0)) : null;
                this.insertCast(funcText, children);
                this.validateUDF(node, isFunction, ctx, fi, children);
                if (TypeCheckProcFactory.this.exprFactory.isCompareFunction(fi) && children.size() == 2 && (TypeCheckProcFactory.this.exprFactory.isConstantExpr(children.get(0)) && TypeCheckProcFactory.this.exprFactory.isColumnRefExpr(children.get(1)) || TypeCheckProcFactory.this.exprFactory.isColumnRefExpr(children.get(0)) && TypeCheckProcFactory.this.exprFactory.isConstantExpr(children.get(1)))) {
                    int constIdx = TypeCheckProcFactory.this.exprFactory.isConstantExpr(children.get(0)) ? 0 : 1;
                    Object constChild = children.get(constIdx);
                    Object columnChild = children.get(1 - constIdx);
                    PrimitiveTypeInfo colTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo((String)TypeCheckProcFactory.this.exprFactory.getTypeInfo(columnChild).getTypeName().toLowerCase());
                    Object newChild = this.interpretNodeAsConstant(colTypeInfo, constChild, TypeCheckProcFactory.this.exprFactory.isEqualFunction(fi));
                    if (newChild == null) {
                        if (!TypeCheckProcFactory.this.exprFactory.isNSCompareFunction(fi)) {
                            return TypeCheckProcFactory.this.exprFactory.createBooleanConstantExpr(null);
                        }
                    } else {
                        children.set(constIdx, newChild);
                    }
                }
                boolean functionInfoChangedFromIn = false;
                if (TypeCheckProcFactory.this.exprFactory.isInFunction(fi)) {
                    boolean hasNullValue = false;
                    ArrayListMultimap expressions = ArrayListMultimap.create();
                    for (int i = 1; i < children.size(); ++i) {
                        TypeInfo targetType;
                        Object columnDesc = children.get(0);
                        Object valueDesc = this.interpretNode(columnDesc, children.get(i));
                        if (valueDesc == null) {
                            if (hasNullValue) continue;
                            targetType = TypeCheckProcFactory.this.exprFactory.getTypeInfo(columnDesc);
                            if (!expressions.containsKey((Object)targetType)) {
                                expressions.put((Object)targetType, columnDesc);
                            }
                            Object nullConst = TypeCheckProcFactory.this.exprFactory.createConstantExpr(targetType, null);
                            expressions.put((Object)targetType, nullConst);
                            hasNullValue = true;
                            continue;
                        }
                        targetType = TypeCheckProcFactory.this.exprFactory.getTypeInfo(valueDesc);
                        if (!expressions.containsKey((Object)targetType)) {
                            expressions.put((Object)targetType, columnDesc);
                        }
                        expressions.put((Object)targetType, valueDesc);
                    }
                    children.clear();
                    ArrayList newExprs = new ArrayList();
                    int numEntries = expressions.keySet().size();
                    if (numEntries == 1) {
                        children.addAll((Collection)expressions.asMap().values().iterator().next());
                        funcText = "in";
                        fi = TypeCheckProcFactory.this.exprFactory.getFunctionInfo("in");
                    } else {
                        FunctionInfo inFunctionInfo = TypeCheckProcFactory.this.exprFactory.getFunctionInfo("in");
                        for (Collection c : expressions.asMap().values()) {
                            newExprs.add(TypeCheckProcFactory.this.exprFactory.createFuncCallExpr(null, inFunctionInfo, "in", (List)c));
                        }
                        children.addAll(newExprs);
                        funcText = "or";
                        fi = TypeCheckProcFactory.this.exprFactory.getFunctionInfo("or");
                        functionInfoChangedFromIn = true;
                    }
                }
                if (TypeCheckProcFactory.this.exprFactory.isOrFunction(fi) && !functionInfoChangedFromIn) {
                    ArrayList childrenList = new ArrayList(children.size());
                    for (Object child : children) {
                        if (TypeInfoFactory.getPrimitiveTypeInfo((String)"void").equals((Object)TypeCheckProcFactory.this.exprFactory.getTypeInfo(child))) {
                            child = TypeCheckProcFactory.this.exprFactory.setTypeInfo(child, (TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"boolean"));
                        }
                        if (TypeCheckProcFactory.this.exprFactory.isORFuncCallExpr(child)) {
                            childrenList.addAll(TypeCheckProcFactory.this.exprFactory.getExprChildren(child));
                            continue;
                        }
                        childrenList.add(child);
                    }
                    expr = TypeCheckProcFactory.this.exprFactory.createFuncCallExpr(null, fi, funcText, childrenList);
                } else if (TypeCheckProcFactory.this.exprFactory.isAndFunction(fi)) {
                    ArrayList childrenList = new ArrayList(children.size());
                    for (Object child : children) {
                        if (TypeInfoFactory.getPrimitiveTypeInfo((String)"void").equals((Object)TypeCheckProcFactory.this.exprFactory.getTypeInfo(child))) {
                            child = TypeCheckProcFactory.this.exprFactory.setTypeInfo(child, (TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"boolean"));
                        }
                        if (TypeCheckProcFactory.this.exprFactory.isANDFuncCallExpr(child)) {
                            childrenList.addAll(TypeCheckProcFactory.this.exprFactory.getExprChildren(child));
                            continue;
                        }
                        childrenList.add(child);
                    }
                    expr = TypeCheckProcFactory.this.exprFactory.createFuncCallExpr(null, fi, funcText, childrenList);
                } else if (ctx.isFoldExpr() && TypeCheckProcFactory.this.exprFactory.convertCASEIntoCOALESCEFuncCallExpr(fi, children)) {
                    fi = TypeCheckProcFactory.this.exprFactory.getFunctionInfo("coalesce");
                    expr = TypeCheckProcFactory.this.exprFactory.createFuncCallExpr(null, fi, "coalesce", Lists.newArrayList((Object[])new Object[]{children.get(0), TypeCheckProcFactory.this.exprFactory.createBooleanConstantExpr(Boolean.FALSE.toString())}));
                    if (Boolean.FALSE.equals(TypeCheckProcFactory.this.exprFactory.getConstantValue(children.get(1)))) {
                        fi = TypeCheckProcFactory.this.exprFactory.getFunctionInfo("not");
                        expr = TypeCheckProcFactory.this.exprFactory.createFuncCallExpr(null, fi, "not", Lists.newArrayList((Object[])new Object[]{expr}));
                    }
                } else {
                    expr = TypeCheckProcFactory.this.exprFactory.createFuncCallExpr(typeInfo, fi, funcText, children);
                }
                if (TypeCheckProcFactory.this.exprFactory.isSTRUCTFuncCallExpr(expr)) {
                    expr = TypeCheckProcFactory.this.exprFactory.replaceFieldNamesInStruct(expr, ctx.getColumnAliases());
                }
                if (ctx.isFoldExpr() && TypeCheckProcFactory.this.exprFactory.isFuncCallExpr(expr) && TypeCheckProcFactory.this.exprFactory.isConsistentWithinQuery(fi) && TypeCheckProcFactory.this.exprFactory.isAllConstants(children) && (constantExpr = TypeCheckProcFactory.this.exprFactory.foldExpr(expr)) != null) {
                    expr = constantExpr;
                }
            }
            if (TypeCheckProcFactory.this.exprFactory.isPOSITIVEFuncCallExpr(expr)) {
                assert (TypeCheckProcFactory.this.exprFactory.getExprChildren(expr).size() == 1);
                expr = TypeCheckProcFactory.this.exprFactory.getExprChildren(expr).get(0);
            } else if (TypeCheckProcFactory.this.exprFactory.isNEGATIVEFuncCallExpr(expr)) {
                Object constantExpr;
                assert (TypeCheckProcFactory.this.exprFactory.getExprChildren(expr).size() == 1);
                Object input = TypeCheckProcFactory.this.exprFactory.getExprChildren(expr).get(0);
                if (TypeCheckProcFactory.this.exprFactory.isConstantExpr(input) && (constantExpr = TypeCheckProcFactory.this.exprFactory.foldExpr(expr)) != null) {
                    expr = constantExpr;
                }
            }
            assert (expr != null);
            return expr;
        }

        private TypeInfo getTypeInfo(ASTNode funcNameNode) throws SemanticException {
            switch (funcNameNode.getType()) {
                case 853: {
                    return ParseUtils.getCharTypeInfo(funcNameNode);
                }
                case 1199: {
                    return ParseUtils.getVarcharTypeInfo(funcNameNode);
                }
                case 1171: {
                    HiveConf conf;
                    TimestampLocalTZTypeInfo timestampLocalTZTypeInfo = new TimestampLocalTZTypeInfo();
                    try {
                        conf = Hive.get().getConf();
                    }
                    catch (HiveException e) {
                        throw new SemanticException((Throwable)e);
                    }
                    timestampLocalTZTypeInfo.setTimeZone(conf.getLocalTimeZone());
                    return timestampLocalTZTypeInfo;
                }
                case 887: {
                    return ParseUtils.getDecimalTypeTypeInfo(funcNameNode);
                }
            }
            return null;
        }

        private T interpretNode(T columnDesc, T valueDesc) throws SemanticException {
            if (TypeCheckProcFactory.this.exprFactory.isColumnRefExpr(columnDesc)) {
                PrimitiveTypeInfo typeInfo = TypeInfoFactory.getPrimitiveTypeInfo((String)TypeCheckProcFactory.this.exprFactory.getTypeInfo(columnDesc).getTypeName().toLowerCase());
                return this.interpretNodeAsConstant(typeInfo, valueDesc);
            }
            boolean columnStruct = TypeCheckProcFactory.this.exprFactory.isSTRUCTFuncCallExpr(columnDesc);
            if (columnStruct) {
                boolean constantValuesStruct = TypeCheckProcFactory.this.exprFactory.isConstantStruct(valueDesc);
                boolean valuesStruct = TypeCheckProcFactory.this.exprFactory.isSTRUCTFuncCallExpr(valueDesc);
                if (constantValuesStruct || valuesStruct) {
                    List columnChilds = TypeCheckProcFactory.this.exprFactory.getExprChildren(columnDesc);
                    List<TypeInfo> structFieldInfos = TypeCheckProcFactory.this.exprFactory.getStructTypeInfoList(valueDesc);
                    List<String> structFieldNames = TypeCheckProcFactory.this.exprFactory.getStructNameList(valueDesc);
                    if (columnChilds.size() != structFieldInfos.size()) {
                        throw new SemanticException(ErrorMsg.INCOMPATIBLE_STRUCT.getMsg(columnChilds + " and " + structFieldInfos));
                    }
                    if (constantValuesStruct) {
                        List literals = (List)TypeCheckProcFactory.this.exprFactory.getConstantValue(valueDesc);
                        ArrayList constantExpressions = new ArrayList();
                        ArrayList<TypeInfo> newStructFieldInfos = new ArrayList<TypeInfo>();
                        for (int i = 0; i < columnChilds.size(); ++i) {
                            PrimitiveTypeInfo typeInfo = TypeInfoFactory.getPrimitiveTypeInfo((String)TypeCheckProcFactory.this.exprFactory.getTypeInfo(columnChilds.get(i)).getTypeName().toLowerCase());
                            Object constantExpression = this.interpretNodeAsConstant(typeInfo, TypeCheckProcFactory.this.exprFactory.createConstantExpr(structFieldInfos.get(i), literals.get(i)));
                            if (constantExpression == null) {
                                constantExpression = TypeCheckProcFactory.this.exprFactory.createConstantExpr((TypeInfo)typeInfo, null);
                            }
                            constantExpressions.add(constantExpression);
                            newStructFieldInfos.add(TypeCheckProcFactory.this.exprFactory.getTypeInfo(constantExpression));
                        }
                        StructTypeInfo structTypeInfo = new StructTypeInfo();
                        structTypeInfo.setAllStructFieldNames(new ArrayList<String>(structFieldNames));
                        structTypeInfo.setAllStructFieldTypeInfos(new ArrayList(newStructFieldInfos));
                        return TypeCheckProcFactory.this.exprFactory.createStructExpr((TypeInfo)structTypeInfo, constantExpressions);
                    }
                    List valueChilds = TypeCheckProcFactory.this.exprFactory.getExprChildren(valueDesc);
                    ArrayList newValueChilds = new ArrayList();
                    ArrayList<TypeInfo> newStructFieldInfos = new ArrayList<TypeInfo>();
                    for (int i = 0; i < columnChilds.size(); ++i) {
                        Object newValue = this.interpretNode(columnChilds.get(i), valueChilds.get(i));
                        newValueChilds.add(newValue);
                        newStructFieldInfos.add(TypeCheckProcFactory.this.exprFactory.getTypeInfo(columnChilds.get(i)));
                    }
                    StructTypeInfo structTypeInfo = new StructTypeInfo();
                    structTypeInfo.setAllStructFieldNames(new ArrayList<String>(structFieldNames));
                    structTypeInfo.setAllStructFieldTypeInfos(new ArrayList(newStructFieldInfos));
                    return TypeCheckProcFactory.this.exprFactory.createStructExpr((TypeInfo)structTypeInfo, newValueChilds);
                }
            }
            return valueDesc;
        }

        @VisibleForTesting
        protected T interpretNodeAsConstant(PrimitiveTypeInfo targetType, T constChild) throws SemanticException {
            return this.interpretNodeAsConstant(targetType, constChild, true);
        }

        private T interpretNodeAsConstant(PrimitiveTypeInfo targetType, T constChild, boolean isEqual) throws SemanticException {
            if (TypeCheckProcFactory.this.exprFactory.isConstantExpr(constChild)) {
                Object constVal = TypeCheckProcFactory.this.exprFactory.getConstantValue(constChild);
                if (constVal == null) {
                    return TypeCheckProcFactory.this.exprFactory.createConstantExpr((TypeInfo)targetType, null);
                }
                PrimitiveTypeInfo sourceType = (PrimitiveTypeInfo)TypeCheckProcFactory.this.exprFactory.getTypeInfo(constChild);
                Object newConst = TypeCheckProcFactory.this.exprFactory.interpretConstantAsPrimitive(targetType, constVal, sourceType, isEqual);
                if (newConst == null) {
                    return null;
                }
                if (newConst == constVal) {
                    return constChild;
                }
                return TypeCheckProcFactory.this.exprFactory.createConstantExpr(TypeCheckProcFactory.this.exprFactory.adjustConstantType(targetType, newConst), newConst);
            }
            return constChild;
        }

        private boolean isDescendant(Node ans, Node des) {
            if (ans.getChildren() == null) {
                return false;
            }
            for (Node c : ans.getChildren()) {
                if (c == des) {
                    return true;
                }
                if (!this.isDescendant(c, des)) continue;
                return true;
            }
            return false;
        }

        protected T processQualifiedColRef(TypeCheckCtx ctx, ASTNode expr, Object ... nodeOutputs) throws SemanticException {
            String colName;
            RowResolver input = ctx.getInputRR();
            String tableAlias = BaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText());
            Object desc = nodeOutputs[1];
            if (TypeCheckProcFactory.this.exprFactory.isConstantExpr(desc)) {
                colName = TypeCheckProcFactory.this.exprFactory.getConstantValueAsString(desc);
            } else if (TypeCheckProcFactory.this.exprFactory.isColumnRefExpr(desc)) {
                colName = TypeCheckProcFactory.this.exprFactory.getColumnName(desc, input);
            } else {
                throw new SemanticException("Unexpected ExprNode : " + nodeOutputs[1]);
            }
            ColumnInfo colInfo = input.get(tableAlias, colName);
            RowResolver usedRR = input;
            int offset = 0;
            if (colInfo == null && ctx.getOuterRR() != null) {
                RowResolver outerRR = ctx.getOuterRR();
                colInfo = outerRR.get(tableAlias, colName);
                usedRR = outerRR;
                offset = input.getColumnInfos().size();
            }
            if (colInfo == null) {
                ctx.setError(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_COLUMN.getMsg(), (Tree)expr.getChild(1)), expr);
                return null;
            }
            return TypeCheckProcFactory.this.exprFactory.toExpr(colInfo, usedRR, offset);
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            boolean isFunction;
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            Object desc = TypeCheckProcFactory.this.processGByExpr(nd, procCtx);
            if (desc != null) {
                if (this.isDescendant(nd, (Node)ctx.getErrorSrcNode())) {
                    ctx.setError(null, null);
                }
                return desc;
            }
            if (ctx.getError() != null) {
                return null;
            }
            ASTNode expr = (ASTNode)nd;
            if (WINDOWING_TOKENS.contains(expr.getType())) {
                if (!ctx.getallowWindowing()) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(expr, ErrorMsg.INVALID_FUNCTION.getMsg("Windowing is not supported in the context")));
                }
                return null;
            }
            if (expr.getType() == 1128 || expr.getType() == 1049) {
                return null;
            }
            if (expr.getType() == 1162) {
                return null;
            }
            if (expr.getType() == 774) {
                if (!ctx.getallowAllColRef()) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(expr, ErrorMsg.INVALID_COLUMN.getMsg("All column reference is not supported in the context")));
                }
                RowResolver input = ctx.getInputRR();
                Object columnList = TypeCheckProcFactory.this.exprFactory.createExprsListExpr();
                assert (expr.getChildCount() <= 1);
                if (expr.getChildCount() == 1) {
                    ASTNode child = (ASTNode)expr.getChild(0);
                    assert (child.getType() == 1162);
                    assert (child.getChildCount() == 1);
                    String tableAlias = BaseSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText());
                    Map<String, ColumnInfo> columns = input.getFieldMap(tableAlias);
                    if (columns == null) {
                        throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_TABLE_ALIAS.getMsg(), (ASTNode)child));
                    }
                    for (Map.Entry<String, ColumnInfo> colMap : columns.entrySet()) {
                        ColumnInfo colInfo = colMap.getValue();
                        if (colInfo.getIsVirtualCol()) continue;
                        TypeCheckProcFactory.this.exprFactory.addExprToExprsList(columnList, TypeCheckProcFactory.this.exprFactory.toExpr(colInfo, input, 0));
                    }
                } else {
                    for (ColumnInfo colInfo : input.getColumnInfos()) {
                        if (colInfo.getIsVirtualCol()) continue;
                        TypeCheckProcFactory.this.exprFactory.addExprToExprsList(columnList, TypeCheckProcFactory.this.exprFactory.toExpr(colInfo, input, 0));
                    }
                }
                return columnList;
            }
            if (expr.getType() == 16 && expr.getChild(0).getType() == 1159 && nodeOutputs[0] == null) {
                return this.processQualifiedColRef(ctx, expr, nodeOutputs);
            }
            if (CONVERSION_FUNCTION_TEXT_MAP.keySet().contains(expr.getType()) || expr.getToken().getType() == 12 || expr.getToken().getType() == 11) {
                return null;
            }
            boolean bl = isFunction = expr.getType() == 933 || expr.getType() == 935 || expr.getType() == 934;
            if (!ctx.getAllowDistinctFunctions() && expr.getType() == 934) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(expr, ErrorMsg.DISTINCT_NOT_SUPPORTED.getMsg()));
            }
            int childrenBegin = isFunction ? 1 : 0;
            ArrayList<Iterator<ColumnInfo>> children = new ArrayList<Iterator<ColumnInfo>>(expr.getChildCount() - childrenBegin);
            for (int ci = childrenBegin; ci < expr.getChildCount(); ++ci) {
                if (nodeOutputs[ci] == ALIAS_PLACEHOLDER) continue;
                Iterator<ColumnInfo> nodeOutput = nodeOutputs[ci];
                if (TypeCheckProcFactory.this.exprFactory.isExprsListExpr(nodeOutput)) {
                    children.addAll(TypeCheckProcFactory.this.exprFactory.getExprChildren(nodeOutput));
                    continue;
                }
                children.add(nodeOutput);
            }
            if (expr.getType() == 935) {
                if (!ctx.getallowFunctionStar()) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(expr, ErrorMsg.INVALID_COLUMN.getMsg(".* reference is not supported in the context")));
                }
                RowResolver input = ctx.getInputRR();
                for (ColumnInfo colInfo : input.getColumnInfos()) {
                    if (colInfo.getIsVirtualCol()) continue;
                    children.add((Iterator<ColumnInfo>)TypeCheckProcFactory.this.exprFactory.toExpr(colInfo, input, 0));
                }
            }
            if (children.contains(null)) {
                List<String> possibleColumnNames = this.getReferenceableColumnAliases(ctx);
                String reason = String.format("(possible column names are: %s)", StringUtils.join(possibleColumnNames, (String)", "));
                ctx.setError(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_COLUMN.getMsg(), (Tree)expr.getChild(0), (String)reason), expr);
                return null;
            }
            try {
                return this.getXpathOrFuncExprNodeDesc(expr, isFunction, children, ctx);
            }
            catch (UDFArgumentTypeException e) {
                throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_ARGUMENT_TYPE.getMsg(), (Tree)expr.getChild(childrenBegin + e.getArgumentId()), (String)e.getMessage()), (Throwable)((Object)e));
            }
            catch (UDFArgumentLengthException e) {
                throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_ARGUMENT_LENGTH.getMsg(), (ASTNode)expr, (String)e.getMessage()), (Throwable)((Object)e));
            }
            catch (UDFArgumentException e) {
                throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_ARGUMENT.getMsg(), (ASTNode)expr, (String)e.getMessage()), (Throwable)e);
            }
        }

        protected List<String> getReferenceableColumnAliases(TypeCheckCtx ctx) {
            return ctx.getInputRR().getReferenceableColumnAliases(null, -1);
        }
    }

    public class ColumnExprProcessor
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            int offset;
            RowResolver usedRR;
            ColumnInfo colInfo;
            boolean isTableAlias;
            String tableOrCol;
            RowResolver input;
            ASTNode parent;
            ASTNode expr;
            TypeCheckCtx ctx;
            block15: {
                ctx = (TypeCheckCtx)procCtx;
                if (ctx.getError() != null) {
                    return null;
                }
                Object desc = TypeCheckProcFactory.this.processGByExpr(nd, procCtx);
                if (desc != null) {
                    return desc;
                }
                expr = (ASTNode)nd;
                parent = stack.size() > 1 ? (ASTNode)stack.get(stack.size() - 2) : null;
                input = ctx.getInputRR();
                if (input == null) {
                    ctx.setError(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_COLUMN.getMsg(), (ASTNode)expr), expr);
                    return null;
                }
                if (expr.getType() != 1159) {
                    ctx.setError(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_COLUMN.getMsg(), (ASTNode)expr), expr);
                    return null;
                }
                assert (expr.getChildCount() == 1);
                tableOrCol = BaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText());
                isTableAlias = input.hasTableAlias(tableOrCol);
                colInfo = null;
                usedRR = null;
                offset = 0;
                try {
                    colInfo = input.get(null, tableOrCol);
                    usedRR = input;
                }
                catch (SemanticException semanticException) {
                    if (isTableAlias && parent != null && parent.getType() == 16) break block15;
                    throw semanticException;
                }
            }
            if (ctx.getOuterRR() != null && colInfo == null && !isTableAlias) {
                RowResolver outerRR = ctx.getOuterRR();
                isTableAlias = outerRR.hasTableAlias(tableOrCol);
                colInfo = outerRR.get(null, tableOrCol);
                usedRR = outerRR;
                offset = input.getColumnInfos().size();
            }
            if (isTableAlias) {
                if (colInfo != null) {
                    if (parent != null && parent.getType() == 16) {
                        return null;
                    }
                    return TypeCheckProcFactory.this.exprFactory.toExpr(colInfo, usedRR, offset);
                }
                return null;
            }
            if (colInfo == null) {
                if (input.getIsExprResolver()) {
                    ASTNode exprNode = expr;
                    if (!stack.empty()) {
                        ASTNode tmp = (ASTNode)stack.pop();
                        if (!stack.empty()) {
                            exprNode = (ASTNode)stack.peek();
                        }
                        stack.push((Node)tmp);
                    }
                    ctx.setError(ASTErrorUtils.getMsg((String)ErrorMsg.NON_KEY_EXPR_IN_GROUPBY.getMsg(), (ASTNode)exprNode), expr);
                    return null;
                }
                List<String> possibleColumnNames = input.getReferenceableColumnAliases(tableOrCol, -1);
                String reason = String.format("(possible column names are: %s)", StringUtils.join(possibleColumnNames, (String)", "));
                ctx.setError(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_TABLE_OR_COLUMN.getMsg(), (Tree)expr.getChild(0), (String)reason), expr);
                LOG.debug(ErrorMsg.INVALID_TABLE_OR_COLUMN.toString() + ":" + input.toString());
                return null;
            }
            return TypeCheckProcFactory.this.exprFactory.toExpr(colInfo, usedRR, offset);
        }
    }

    public class IntervalExprProcessor
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            Object desc = TypeCheckProcFactory.this.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ASTNode expr = (ASTNode)nd;
            String intervalString = BaseSemanticAnalyzer.stripQuotes(expr.getText());
            try {
                switch (expr.getType()) {
                    case 964: {
                        return TypeCheckProcFactory.this.exprFactory.createIntervalYearMonthConstantExpr(intervalString);
                    }
                    case 957: {
                        return TypeCheckProcFactory.this.exprFactory.createIntervalDayTimeConstantExpr(intervalString);
                    }
                    case 962: {
                        return TypeCheckProcFactory.this.exprFactory.createIntervalYearConstantExpr(intervalString);
                    }
                    case 960: {
                        return TypeCheckProcFactory.this.exprFactory.createIntervalMonthConstantExpr(intervalString);
                    }
                    case 955: {
                        return TypeCheckProcFactory.this.exprFactory.createIntervalDayConstantExpr(intervalString);
                    }
                    case 958: {
                        return TypeCheckProcFactory.this.exprFactory.createIntervalHourConstantExpr(intervalString);
                    }
                    case 959: {
                        return TypeCheckProcFactory.this.exprFactory.createIntervalMinuteConstantExpr(intervalString);
                    }
                    case 961: {
                        return TypeCheckProcFactory.this.exprFactory.createIntervalSecondConstantExpr(intervalString);
                    }
                }
                throw new IllegalArgumentException("Invalid time literal type " + expr.getType());
            }
            catch (Exception err) {
                throw new SemanticException("Unable to convert interval literal '" + intervalString + "' to interval value.", (Throwable)err);
            }
        }
    }

    public class DateTimeExprProcessor
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            Object desc = TypeCheckProcFactory.this.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ASTNode expr = (ASTNode)nd;
            String timeString = BaseSemanticAnalyzer.stripQuotes(expr.getText());
            try {
                if (expr.getType() == 882) {
                    return TypeCheckProcFactory.this.exprFactory.createDateConstantExpr(timeString);
                }
                if (expr.getType() == 1170) {
                    return TypeCheckProcFactory.this.exprFactory.createTimestampConstantExpr(timeString);
                }
                if (expr.getType() == 1172) {
                    HiveConf conf;
                    try {
                        conf = Hive.get().getConf();
                    }
                    catch (HiveException e) {
                        throw new SemanticException((Throwable)e);
                    }
                    return TypeCheckProcFactory.this.exprFactory.createTimestampLocalTimeZoneConstantExpr(timeString, conf.getLocalTimeZone());
                }
                throw new IllegalArgumentException("Invalid time literal type " + expr.getType());
            }
            catch (Exception err) {
                throw new SemanticException("Unable to convert time literal '" + timeString + "' to time value.", (Throwable)err);
            }
        }
    }

    public class BoolExprProcessor
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            Object desc = TypeCheckProcFactory.this.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ASTNode expr = (ASTNode)nd;
            String bool = null;
            switch (expr.getToken().getType()) {
                case 341: {
                    bool = Boolean.TRUE.toString();
                    break;
                }
                case 136: {
                    bool = Boolean.FALSE.toString();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return TypeCheckProcFactory.this.exprFactory.createBooleanConstantExpr(bool);
        }
    }

    public class StrExprProcessor
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            Object desc = TypeCheckProcFactory.this.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ASTNode expr = (ASTNode)nd;
            String str = null;
            switch (expr.getToken().getType()) {
                case 404: {
                    str = BaseSemanticAnalyzer.unescapeSQLString(expr.getText());
                    break;
                }
                case 1124: {
                    StringBuilder sb = new StringBuilder();
                    for (Node n : expr.getChildren()) {
                        sb.append(BaseSemanticAnalyzer.unescapeSQLString(((ASTNode)n).getText()));
                    }
                    str = sb.toString();
                    break;
                }
                case 854: {
                    str = BaseSemanticAnalyzer.charSetString(expr.getChild(0).getText(), expr.getChild(1).getText());
                    break;
                }
                default: {
                    str = BaseSemanticAnalyzer.unescapeIdentifier(expr.getText().toLowerCase());
                }
            }
            return TypeCheckProcFactory.this.exprFactory.createStringConstantExpr(str);
        }
    }

    public class NumExprProcessor
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            Object desc = TypeCheckProcFactory.this.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            Object result = null;
            ASTNode expr = (ASTNode)nd;
            try {
                result = expr.getText().endsWith("L") ? TypeCheckProcFactory.this.exprFactory.createBigintConstantExpr(expr.getText().substring(0, expr.getText().length() - 1)) : (expr.getText().endsWith("S") ? TypeCheckProcFactory.this.exprFactory.createSmallintConstantExpr(expr.getText().substring(0, expr.getText().length() - 1)) : (expr.getText().endsWith("Y") ? TypeCheckProcFactory.this.exprFactory.createTinyintConstantExpr(expr.getText().substring(0, expr.getText().length() - 1)) : (expr.getText().endsWith("BD") ? TypeCheckProcFactory.this.exprFactory.createDecimalConstantExpr(expr.getText().substring(0, expr.getText().length() - 2), true) : (expr.getText().endsWith("F") ? TypeCheckProcFactory.this.exprFactory.createFloatConstantExpr(expr.getText().substring(0, expr.getText().length() - 1)) : (expr.getText().endsWith("D") ? TypeCheckProcFactory.this.exprFactory.createDoubleConstantExpr(expr.getText().substring(0, expr.getText().length() - 1)) : TypeCheckProcFactory.this.exprFactory.createConstantExpr(expr.getText()))))));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (result == null) {
                throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_NUMERICAL_CONSTANT.getMsg(), (ASTNode)expr));
            }
            return result;
        }
    }

    public class DynamicParameterProcessor
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ASTNode node = (ASTNode)nd;
            String indexStr = node.getText();
            int index = Integer.parseInt(indexStr);
            return TypeCheckProcFactory.this.exprFactory.createDynamicParamExpr(index);
        }
    }

    public class NullExprProcessor
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            Object desc = TypeCheckProcFactory.this.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            return TypeCheckProcFactory.this.exprFactory.createNullConstantExpr();
        }
    }
}

