/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.type;

import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckCtx;
import org.apache.hadoop.hive.ql.plan.SubqueryType;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public abstract class ExprFactory<T> {
    static final BigDecimal NANOS_PER_SEC_BD = new BigDecimal(1000000000);

    protected abstract boolean isExprInstance(Object var1);

    protected abstract T toExpr(ColumnInfo var1, RowResolver var2, int var3) throws SemanticException;

    protected abstract boolean isColumnRefExpr(Object var1);

    protected abstract T createColumnRefExpr(ColumnInfo var1, RowResolver var2, int var3) throws SemanticException;

    protected abstract T createColumnRefExpr(ColumnInfo var1, List<RowResolver> var2) throws SemanticException;

    protected abstract String getColumnName(T var1, RowResolver var2);

    protected abstract boolean isConstantExpr(Object var1);

    protected boolean isAllConstants(List<T> exprs) {
        for (T expr : exprs) {
            if (this.isConstantExpr(expr)) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean isConstantStruct(T var1);

    protected abstract T createNullConstantExpr();

    protected abstract T createDynamicParamExpr(int var1);

    protected abstract T createBooleanConstantExpr(String var1);

    protected abstract T createBigintConstantExpr(String var1);

    protected abstract T createIntConstantExpr(String var1);

    protected abstract T createSmallintConstantExpr(String var1);

    protected abstract T createTinyintConstantExpr(String var1);

    protected abstract T createFloatConstantExpr(String var1);

    protected abstract T createDoubleConstantExpr(String var1) throws SemanticException;

    protected abstract T createDecimalConstantExpr(String var1, boolean var2);

    protected abstract T createStringConstantExpr(String var1);

    protected abstract T createDateConstantExpr(String var1);

    protected abstract T createTimestampConstantExpr(String var1);

    protected abstract T createTimestampLocalTimeZoneConstantExpr(String var1, ZoneId var2);

    protected abstract T createIntervalYearMonthConstantExpr(String var1);

    protected abstract T createIntervalDayTimeConstantExpr(String var1);

    protected abstract T createIntervalYearConstantExpr(String var1);

    protected abstract T createIntervalMonthConstantExpr(String var1);

    protected abstract T createIntervalDayConstantExpr(String var1);

    protected abstract T createIntervalHourConstantExpr(String var1);

    protected abstract T createIntervalMinuteConstantExpr(String var1);

    protected abstract T createIntervalSecondConstantExpr(String var1);

    protected T createConstantExpr(String value) throws SemanticException {
        Object result = null;
        Object result2 = null;
        try {
            result = this.createDoubleConstantExpr(value);
            if (value != null && !value.toLowerCase().contains("e") && (result2 = this.createDecimalConstantExpr(value, false)) != null) {
                result = null;
            }
            result = this.createBigintConstantExpr(value);
            result = this.createIntConstantExpr(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result != null ? result : result2;
    }

    protected abstract T createStructExpr(TypeInfo var1, List<T> var2) throws SemanticException;

    protected abstract T createConstantExpr(TypeInfo var1, Object var2) throws SemanticException;

    protected abstract TypeInfo adjustConstantType(PrimitiveTypeInfo var1, Object var2);

    protected abstract Object interpretConstantAsPrimitive(PrimitiveTypeInfo var1, Object var2, PrimitiveTypeInfo var3, boolean var4);

    protected abstract Object getConstantValue(T var1);

    protected abstract String getConstantValueAsString(T var1);

    protected abstract T createNestedColumnRefExpr(TypeInfo var1, T var2, String var3, Boolean var4) throws SemanticException;

    protected abstract boolean isFuncCallExpr(Object var1);

    protected abstract T createFuncCallExpr(TypeInfo var1, FunctionInfo var2, String var3, List<T> var4) throws SemanticException;

    protected abstract boolean isORFuncCallExpr(T var1);

    protected abstract boolean isANDFuncCallExpr(T var1);

    protected abstract boolean isPOSITIVEFuncCallExpr(T var1);

    protected abstract boolean isNEGATIVEFuncCallExpr(T var1);

    protected abstract boolean isSTRUCTFuncCallExpr(T var1);

    protected abstract boolean isAndFunction(FunctionInfo var1);

    protected abstract boolean isOrFunction(FunctionInfo var1);

    protected abstract boolean isInFunction(FunctionInfo var1);

    protected abstract boolean isCompareFunction(FunctionInfo var1);

    protected abstract boolean isEqualFunction(FunctionInfo var1);

    protected abstract boolean isNSCompareFunction(FunctionInfo var1);

    protected abstract boolean isConsistentWithinQuery(FunctionInfo var1);

    protected abstract boolean isStateful(FunctionInfo var1);

    protected abstract boolean convertCASEIntoCOALESCEFuncCallExpr(FunctionInfo var1, List<T> var2);

    protected abstract T createSubqueryExpr(TypeCheckCtx var1, ASTNode var2, SubqueryType var3, Object[] var4) throws SemanticException;

    protected abstract boolean isExprsListExpr(Object var1);

    protected abstract T createExprsListExpr();

    protected abstract void addExprToExprsList(T var1, T var2);

    protected abstract TypeInfo getTypeInfo(T var1);

    protected abstract List<TypeInfo> getStructTypeInfoList(T var1);

    protected abstract T setTypeInfo(T var1, TypeInfo var2) throws SemanticException;

    protected abstract T foldExpr(T var1);

    protected abstract List<T> getExprChildren(T var1);

    protected abstract List<String> getStructNameList(T var1);

    protected abstract FunctionInfo getFunctionInfo(String var1) throws SemanticException;

    protected abstract T replaceFieldNamesInStruct(T var1, List<String> var2);
}

