/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.type;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.metadata.CheckConstraint;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.NotNullConstraint;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ASTBuilder;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckProcFactory;

class ConstraintExprGenerator<T> {
    private final HiveConf conf;
    private final TypeCheckProcFactory<T> typeCheckProcFactory;
    private final TypeCheckProcFactory.DefaultExprProcessor exprProcessor;

    ConstraintExprGenerator(HiveConf conf, TypeCheckProcFactory<T> typeCheckProcFactory) {
        this.conf = conf;
        this.typeCheckProcFactory = typeCheckProcFactory;
        this.exprProcessor = typeCheckProcFactory.getDefaultExprProcessor();
    }

    public T genConstraintsExpr(Table targetTable, boolean updateStatement, RowResolver inputRR) throws SemanticException {
        List<ColumnInfo> inputColumnInfoList = inputRR.getColumnInfos();
        T nullConstraintExpr = this.getNotNullConstraintExpr(targetTable, inputRR, updateStatement);
        T checkConstraintExpr = this.getCheckConstraintExpr(targetTable, inputColumnInfoList, inputRR, updateStatement);
        Object combinedConstraintExpr = null;
        if (nullConstraintExpr != null && checkConstraintExpr != null) {
            combinedConstraintExpr = this.exprProcessor.getFuncExprNodeDesc("and", nullConstraintExpr, checkConstraintExpr);
        } else if (nullConstraintExpr != null) {
            combinedConstraintExpr = nullConstraintExpr;
        } else if (checkConstraintExpr != null) {
            combinedConstraintExpr = checkConstraintExpr;
        }
        if (combinedConstraintExpr == null) {
            return null;
        }
        return this.exprProcessor.getFuncExprNodeDesc("enforce_constraint", combinedConstraintExpr);
    }

    private T getNotNullConstraintExpr(Table targetTable, RowResolver inputRR, boolean isUpdateStatement) throws SemanticException {
        ImmutableBitSet nullConstraintBitSet;
        boolean forceNotNullConstraint = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_ENFORCE_NOT_NULL_CONSTRAINT);
        if (!forceNotNullConstraint) {
            return null;
        }
        try {
            nullConstraintBitSet = this.getEnabledNotNullConstraints(targetTable);
        }
        catch (SemanticException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (nullConstraintBitSet == null) {
            return null;
        }
        T currUDF = null;
        int constraintIdx = 0;
        List<ColumnInfo> inputColInfos = inputRR.getColumnInfos();
        for (int colExprIdx = 0; colExprIdx < inputColInfos.size(); ++colExprIdx) {
            if (isUpdateStatement && colExprIdx == 0) continue;
            if (nullConstraintBitSet.indexOf(constraintIdx) != -1) {
                Object currExpr = this.typeCheckProcFactory.exprFactory.createColumnRefExpr(inputColInfos.get(colExprIdx), inputRR, 0);
                Object isNotNullUDF = this.exprProcessor.getFuncExprNodeDesc("isnotnull", currExpr);
                currUDF = currUDF != null ? (T)this.exprProcessor.getFuncExprNodeDesc("and", currUDF, isNotNullUDF) : (T)isNotNullUDF;
            }
            ++constraintIdx;
        }
        return currUDF;
    }

    private ImmutableBitSet getEnabledNotNullConstraints(Table tbl) throws HiveException {
        NotNullConstraint nnc = Hive.get().getEnabledNotNullConstraints(tbl.getDbName(), tbl.getTableName());
        if (nnc == null || nnc.getNotNullConstraints().isEmpty()) {
            return null;
        }
        ImmutableBitSet.Builder builder = ImmutableBitSet.builder();
        block0: for (String nnCol : nnc.getNotNullConstraints().values()) {
            int nnPos = -1;
            for (int i = 0; i < tbl.getCols().size(); ++i) {
                if (!tbl.getCols().get(i).getName().equals(nnCol)) continue;
                nnPos = i;
                builder.set(nnPos);
                continue block0;
            }
        }
        return builder.build();
    }

    private T getCheckConstraintExpr(Table tbl, List<ColumnInfo> inputColInfos, RowResolver inputRR, boolean isUpdateStatement) throws SemanticException {
        CheckConstraint cc = null;
        try {
            cc = Hive.get().getEnabledCheckConstraints(tbl.getDbName(), tbl.getTableName());
        }
        catch (HiveException e) {
            throw new SemanticException((Throwable)e);
        }
        if (cc == null || cc.getCheckConstraints().isEmpty()) {
            return null;
        }
        HashMap<String, String> col2Cols = new HashMap<String, String>();
        int colIdx = 0;
        if (isUpdateStatement) {
            colIdx = 1;
        }
        for (FieldSchema fs : tbl.getCols()) {
            col2Cols.put(fs.getName().toLowerCase(), inputColInfos.get(colIdx).getInternalName());
            ++colIdx;
        }
        List<String> checkExprStrs = cc.getCheckExpressionList();
        TypeCheckCtx typeCheckCtx = new TypeCheckCtx(inputRR);
        T checkAndExprs = null;
        for (String checkExprStr : checkExprStrs) {
            try {
                ParseDriver parseDriver = new ParseDriver();
                ASTNode checkExprAST = parseDriver.parseExpression(checkExprStr);
                this.replaceColumnReference(checkExprAST, col2Cols, inputRR);
                Map<ASTNode, T> genExprs = this.typeCheckProcFactory.genExprNode(checkExprAST, typeCheckCtx);
                T checkExpr = genExprs.get(checkExprAST);
                Object notFalseCheckExpr = this.exprProcessor.getFuncExprNodeDesc("isnotfalse", checkExpr);
                if (checkAndExprs == null) {
                    checkAndExprs = notFalseCheckExpr;
                    continue;
                }
                checkAndExprs = this.exprProcessor.getFuncExprNodeDesc("and", checkAndExprs, notFalseCheckExpr);
            }
            catch (Exception e) {
                throw new SemanticException((Throwable)e);
            }
        }
        return checkAndExprs;
    }

    private void replaceColumnReference(ASTNode checkExpr, Map<String, String> col2Col, RowResolver inputRR) {
        if (checkExpr.getType() == 1159) {
            ASTNode oldColChild = (ASTNode)checkExpr.getChild(0);
            String oldColRef = oldColChild.getText().toLowerCase();
            assert (col2Col.containsKey(oldColRef));
            String internalColRef = col2Col.get(oldColRef);
            String[] fullQualColRef = inputRR.reverseLookup(internalColRef);
            String newColRef = fullQualColRef[1];
            checkExpr.deleteChild(0);
            checkExpr.addChild((Tree)ASTBuilder.createAST(oldColChild.getType(), newColRef));
        } else {
            for (int i = 0; i < checkExpr.getChildCount(); ++i) {
                this.replaceColumnReference((ASTNode)checkExpr.getChild(i), col2Col, inputRR);
            }
        }
    }
}

