/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.spark;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.SemanticDispatcher;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.spark.GenSparkProcContext;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class GenSparkWorkWalker
extends DefaultGraphWalker {
    private final GenSparkProcContext ctx;

    public GenSparkWorkWalker(SemanticDispatcher disp, GenSparkProcContext ctx) {
        super(disp);
        this.ctx = ctx;
    }

    private void setRoot(Node nd) {
        this.ctx.currentRootOperator = (Operator)nd;
        this.ctx.preceedingWork = null;
        this.ctx.parentOfRoot = null;
    }

    @Override
    public void startWalking(Collection<Node> startNodes, HashMap<Node, Object> nodeOutput) throws SemanticException {
        this.toWalk.addAll(startNodes);
        while (this.toWalk.size() > 0) {
            Node nd = (Node)this.toWalk.remove(0);
            this.setRoot(nd);
            this.walk(nd);
            if (nodeOutput == null) continue;
            nodeOutput.put(nd, this.retMap.get(nd));
        }
    }

    @Override
    protected void walk(Node nd) throws SemanticException {
        List children = nd.getChildren();
        this.opStack.push(nd);
        Boolean skip = (Boolean)this.dispatchAndReturn(nd, this.opStack);
        Operator<? extends OperatorDesc> currentRoot = this.ctx.currentRootOperator;
        Operator<? extends OperatorDesc> parentOfRoot = this.ctx.parentOfRoot;
        BaseWork preceedingWork = this.ctx.preceedingWork;
        if (skip == null || !skip.booleanValue()) {
            for (Node ch : children) {
                this.ctx.currentRootOperator = currentRoot;
                this.ctx.parentOfRoot = parentOfRoot;
                this.ctx.preceedingWork = preceedingWork;
                this.walk(ch);
            }
        }
        this.opStack.pop();
    }
}

