/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.metric.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Metric;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Status;

public class Stage {
    private String name;
    private Status status;
    private long startTime;
    private long endTime;
    private Map<String, Metric> metrics = new HashMap<String, Metric>();
    private String errorLogPath;

    public Stage() {
    }

    public Stage(String name, Status status, long startTime) {
        this.name = name;
        this.status = status;
        this.startTime = startTime;
    }

    public Stage(Stage stage) {
        this.name = stage.name;
        this.status = stage.status;
        this.startTime = stage.startTime;
        this.endTime = stage.endTime;
        for (Metric metric : stage.metrics.values()) {
            this.metrics.put(metric.getName(), new Metric(metric));
        }
        this.errorLogPath = stage.errorLogPath;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void addMetric(Metric metric) {
        this.metrics.put(metric.getName(), metric);
    }

    public Metric getMetricByName(String name) {
        return this.metrics.get(name);
    }

    public List<Metric> getMetrics() {
        return new ArrayList<Metric>(this.metrics.values());
    }

    public String getErrorLogPath() {
        return this.errorLogPath;
    }

    public void setErrorLogPath(String errorLogPath) {
        this.errorLogPath = errorLogPath;
    }
}

