/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionMessage;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.misc.truncate.TruncateTableDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;

public class TruncatePartitionHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<?>> handle(MessageHandler.Context context) throws SemanticException {
        AlterPartitionMessage msg = this.deserializer.getAlterPartitionMessage(context.dmd.getPayload());
        TableName tName = TableName.fromString((String)msg.getTable(), null, (String)(context.isDbNameEmpty() ? msg.getDB() : context.dbName));
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        try {
            Table tblObj = msg.getTableObj();
            Iterator afterIterator = msg.getPtnObjAfter().getValuesIterator();
            for (FieldSchema fs : tblObj.getPartitionKeys()) {
                partSpec.put(fs.getName(), (String)afterIterator.next());
            }
        }
        catch (Exception e) {
            if (!(e instanceof SemanticException)) {
                throw new SemanticException("Error reading message members", (Throwable)e);
            }
            throw (SemanticException)((Object)e);
        }
        TruncateTableDesc truncateTableDesc = new TruncateTableDesc(tName, partSpec, context.eventOnlyReplicationSpec());
        truncateTableDesc.setWriteId(msg.getWriteId());
        Task<DDLWork> truncatePtnTask = TaskFactory.get(new DDLWork(this.readEntitySet, this.writeEntitySet, truncateTableDesc, true, context.getDumpDirectory(), context.getMetricCollector()), context.hiveConf);
        context.log.debug("Added truncate ptn task : {}:{}:{}", new Object[]{truncatePtnTask.getId(), truncateTableDesc.getTableName(), truncateTableDesc.getWriteId()});
        this.updatedMetadata.set(context.dmd.getEventTo().toString(), tName.getDb(), tName.getTable(), partSpec);
        try {
            return ReplUtils.addChildTask(truncatePtnTask);
        }
        catch (Exception e) {
            throw new SemanticException(e.getMessage());
        }
    }
}

