/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.metastore.messaging.AlterTableMessage;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.drop.DropTableDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;

public class DropTableHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<?>> handle(MessageHandler.Context context) throws SemanticException {
        String actualTblName;
        String actualDbName;
        AlterTableMessage msg;
        if (context.dmd.getDumpType() == DumpType.EVENT_RENAME_DROP_TABLE) {
            msg = this.deserializer.getAlterTableMessage(context.dmd.getPayload());
            actualDbName = context.isDbNameEmpty() ? msg.getDB() : context.dbName;
            actualTblName = msg.getTable();
        } else {
            msg = this.deserializer.getDropTableMessage(context.dmd.getPayload());
            actualDbName = context.isDbNameEmpty() ? msg.getDB() : context.dbName;
            actualTblName = msg.getTable();
        }
        DropTableDesc dropTableDesc = new DropTableDesc(actualDbName + "." + actualTblName, true, true, context.eventOnlyReplicationSpec(), false);
        Task<DDLWork> dropTableTask = TaskFactory.get(new DDLWork(this.readEntitySet, this.writeEntitySet, dropTableDesc, true, context.getDumpDirectory(), context.getMetricCollector()), context.hiveConf);
        context.log.debug("Added drop tbl task : {}:{}", (Object)dropTableTask.getId(), (Object)dropTableDesc.getTableName());
        this.updatedMetadata.set(context.dmd.getEventTo().toString(), actualDbName, null, null);
        return Collections.singletonList(dropTableTask);
    }
}

