/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.io;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.util.Retryable;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.CopyUtils;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.plan.ExportWork;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOperations {
    private static Logger logger = LoggerFactory.getLogger(FileOperations.class);
    private final List<Path> dataPathList;
    private final Path exportRootDataDir;
    private final String distCpDoAsUser;
    private HiveConf hiveConf;
    private FileSystem exportFileSystem;
    private FileSystem dataFileSystem;
    private final ExportWork.MmContext mmCtx;

    public FileOperations(List<Path> dataPathList, Path exportRootDataDir, String distCpDoAsUser, HiveConf hiveConf, ExportWork.MmContext mmCtx) throws IOException {
        this.dataPathList = dataPathList;
        this.exportRootDataDir = exportRootDataDir;
        this.distCpDoAsUser = distCpDoAsUser;
        this.hiveConf = hiveConf;
        this.mmCtx = mmCtx;
        this.dataFileSystem = dataPathList != null && !dataPathList.isEmpty() ? dataPathList.get(0).getFileSystem((Configuration)hiveConf) : null;
        this.exportFileSystem = exportRootDataDir.getFileSystem((Configuration)hiveConf);
    }

    public void export(boolean isExportTask, boolean dataCopyAtLoad) throws Exception {
        if (isExportTask) {
            this.copyFiles();
        } else if (dataCopyAtLoad) {
            this.exportFilesAsList();
        } else {
            this.validateSrcPathListExists();
        }
    }

    private void copyFiles() throws IOException, LoginException {
        if (this.mmCtx == null) {
            for (Path dataPath : this.dataPathList) {
                this.copyOneDataPath(dataPath, this.exportRootDataDir);
            }
        } else {
            this.copyMmPath();
        }
    }

    private void copyOneDataPath(Path fromPath, Path toPath) throws IOException, LoginException {
        FileStatus[] fileStatuses = LoadSemanticAnalyzer.matchFilesOrDir(this.dataFileSystem, fromPath);
        ArrayList<Path> srcPaths = new ArrayList<Path>();
        for (FileStatus fileStatus : fileStatuses) {
            srcPaths.add(fileStatus.getPath());
        }
        new CopyUtils(this.distCpDoAsUser, this.hiveConf, toPath.getFileSystem((Configuration)this.hiveConf)).doCopy(toPath, srcPaths);
    }

    private void copyMmPath() throws LoginException, IOException {
        ValidWriteIdList ids = AcidUtils.getTableValidWriteIdList((Configuration)this.hiveConf, this.mmCtx.getFqTableName());
        for (Path fromPath : this.dataPathList) {
            fromPath = this.dataFileSystem.makeQualified(fromPath);
            ArrayList<Path> validPaths = new ArrayList<Path>();
            ArrayList<Path> dirsWithOriginals = new ArrayList<Path>();
            HiveInputFormat.processPathsForMmRead(this.dataPathList, (Configuration)this.hiveConf, ids, validPaths, dirsWithOriginals);
            String fromPathStr = fromPath.toString();
            if (!fromPathStr.endsWith("/")) {
                fromPathStr = fromPathStr + "/";
            }
            for (Path validPath : validPaths) {
                String mmChildPath = "export_old_" + validPath.toString().substring(fromPathStr.length());
                Path destPath = new Path(this.exportRootDataDir, mmChildPath);
                Utilities.FILE_OP_LOGGER.debug("Exporting {} to {}", (Object)validPath, (Object)destPath);
                this.exportFileSystem.mkdirs(destPath);
                this.copyOneDataPath(validPath, destPath);
            }
            for (Path dirWithOriginals : dirsWithOriginals) {
                FileStatus[] files = this.dataFileSystem.listStatus(dirWithOriginals, AcidUtils.hiddenFileFilter);
                ArrayList<Path> srcPaths = new ArrayList<Path>();
                for (FileStatus fileStatus : files) {
                    if (fileStatus.isDirectory()) continue;
                    srcPaths.add(fileStatus.getPath());
                }
                Utilities.FILE_OP_LOGGER.debug("Exporting originals from {} to {}", (Object)dirWithOriginals, (Object)this.exportRootDataDir);
                new CopyUtils(this.distCpDoAsUser, this.hiveConf, this.exportRootDataDir.getFileSystem((Configuration)this.hiveConf)).doCopy(this.exportRootDataDir, srcPaths);
            }
        }
    }

    public Path getPathWithSchemeAndAuthority(Path targetFilePath, Path currentFilePath) {
        if (targetFilePath.toUri().getScheme() == null) {
            URI currentURI = currentFilePath.toUri();
            targetFilePath = new Path(currentURI.getScheme(), currentURI.getAuthority(), targetFilePath.toUri().getPath());
        }
        return targetFilePath;
    }

    private FileStatus[] listFilesInDir(Path path) throws IOException {
        return this.dataFileSystem.listStatus(path, p -> {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        });
    }

    private void validateSrcPathListExists() throws IOException, LoginException {
        if (this.dataPathList.isEmpty()) {
            return;
        }
        try {
            for (Path dataPath : this.dataPathList) {
                this.listFilesInDir(dataPath);
            }
        }
        catch (FileNotFoundException e) {
            logger.error("exporting data files in dir : " + this.dataPathList + " to " + this.exportRootDataDir + " failed");
            throw new FileNotFoundException(ErrorMsg.FILE_NOT_FOUND.format(e.getMessage()));
        }
    }

    void exportFilesAsList() throws SemanticException {
        if (this.dataPathList.isEmpty()) {
            return;
        }
        Retryable retryable = Retryable.builder().withHiveConf(this.hiveConf).withRetryOnException(IOException.class).build();
        try {
            retryable.executeCallable(() -> {
                try (BufferedWriter writer = this.writer();){
                    for (Path dataPath : this.dataPathList) {
                        this.writeFilesList(this.listFilesInDir(dataPath), writer, AcidUtils.getAcidSubDir(dataPath));
                    }
                }
                catch (IOException e) {
                    if (e instanceof FileNotFoundException) {
                        logger.error("exporting data files in dir : " + this.dataPathList + " to " + this.exportRootDataDir + " failed");
                        throw new FileNotFoundException(ErrorMsg.FILE_NOT_FOUND.format(e.getMessage()));
                    }
                    FileSystem.closeAllForUGI((UserGroupInformation)org.apache.hadoop.hive.shims.Utils.getUGI());
                    this.dataFileSystem = this.dataPathList.get(0).getFileSystem((Configuration)this.hiveConf);
                    this.exportFileSystem = this.exportRootDataDir.getFileSystem((Configuration)this.hiveConf);
                    Path exportPath = new Path(this.exportRootDataDir, "_files");
                    if (this.exportFileSystem.exists(exportPath)) {
                        this.exportFileSystem.delete(exportPath, true);
                    }
                    throw e;
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new SemanticException((Throwable)e);
        }
    }

    private void writeFilesList(FileStatus[] fileStatuses, BufferedWriter writer, String encodedSubDirs) throws IOException, SemanticException {
        for (FileStatus fileStatus : fileStatuses) {
            if (fileStatus.isDirectory()) {
                Path subDir = fileStatus.getPath();
                this.writeFilesList(this.listFilesInDir(subDir), writer, this.encodedSubDir(encodedSubDirs, subDir));
                continue;
            }
            writer.write(this.encodedUri(fileStatus, encodedSubDirs));
            writer.newLine();
        }
    }

    private BufferedWriter writer() throws IOException {
        Path exportToFile = new Path(this.exportRootDataDir, "_files");
        logger.debug("exporting data files in dir : " + this.dataPathList + " to " + exportToFile);
        return new BufferedWriter(new OutputStreamWriter((OutputStream)this.exportFileSystem.create(exportToFile)));
    }

    private String encodedSubDir(String encodedParentDirs, Path subDir) {
        if (null == encodedParentDirs) {
            return subDir.getName();
        }
        return encodedParentDirs + "/" + subDir.getName();
    }

    private String encodedUri(FileStatus fileStatus, String encodedSubDir) throws IOException, SemanticException {
        ReplChangeManager replChangeManager = ReplChangeManager.getInstance();
        Path currentDataFilePath = fileStatus.getPath();
        String checkSum = ReplChangeManager.checksumFor((Path)currentDataFilePath, (FileSystem)this.dataFileSystem);
        String cmEncodedURIL = replChangeManager.encodeFileUri(currentDataFilePath.toString(), checkSum, encodedSubDir);
        if (this.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_HA_DATAPATH_REPLACE_REMOTE_NAMESERVICE)) {
            return Utils.replaceNameserviceInEncodedURI(cmEncodedURIL, this.hiveConf);
        }
        return cmEncodedURIL;
    }
}

