/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.messaging.AbortTxnMessage;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AbstractEventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;

class AbortTxnHandler
extends AbstractEventHandler<AbortTxnMessage> {
    AbortTxnHandler(NotificationEvent event) {
        super(event);
    }

    @Override
    AbortTxnMessage eventMessage(String stringRepresentation) {
        return this.deserializer.getAbortTxnMessage(stringRepresentation);
    }

    @Override
    public void handle(EventHandler.Context withinContext) throws Exception {
        if (!ReplUtils.includeAcidTableInDump(withinContext.hiveConf)) {
            return;
        }
        LOG.info("Processing#{} ABORT_TXN message : {}", (Object)this.fromEventId(), (Object)this.eventMessageAsJSON);
        DumpMetaData dmd = withinContext.createDmd(this);
        dmd.setPayload(this.eventMessageAsJSON);
        dmd.write();
    }

    @Override
    public DumpType dumpType() {
        return DumpType.EVENT_ABORT_TXN;
    }
}

