/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.repl.util.FileList;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.PartitionIterable;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.dump.PartitionExport;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.FileOperations;
import org.apache.hadoop.hive.ql.plan.ExportWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableExport {
    private static final Logger logger = LoggerFactory.getLogger(TableExport.class);
    private BaseSemanticAnalyzer.TableSpec tableSpec;
    private final ReplicationSpec replicationSpec;
    private final Hive db;
    private final String distCpDoAsUser;
    private final HiveConf conf;
    private final Paths paths;
    private final ExportWork.MmContext mmCtx;

    public TableExport(Paths paths, BaseSemanticAnalyzer.TableSpec tableSpec, ReplicationSpec replicationSpec, Hive db, String distCpDoAsUser, HiveConf conf, ExportWork.MmContext mmCtx) {
        this.tableSpec = tableSpec != null && tableSpec.tableHandle.isTemporary() && replicationSpec.isInReplicationScope() ? null : tableSpec;
        this.replicationSpec = replicationSpec;
        if (this.tableSpec != null && this.tableSpec.tableHandle != null) {
            if (this.tableSpec.tableHandle.isView() || Utils.shouldDumpMetaDataOnly(conf)) {
                this.tableSpec.tableHandle.setStatsStateLikeNewTable();
                this.replicationSpec.setIsMetadataOnly(true);
            }
            if (this.tableSpec.tableHandle.isView() || Utils.shouldDumpMetaDataOnlyForExternalTables(this.tableSpec.tableHandle, conf)) {
                this.tableSpec.tableHandle.setStatsStateLikeNewTable();
                this.replicationSpec.setMetadataOnlyForExternalTables(true);
            }
        }
        this.db = db;
        this.distCpDoAsUser = distCpDoAsUser;
        this.conf = conf;
        this.paths = paths;
        this.mmCtx = mmCtx;
    }

    public void write(boolean isExportTask, FileList fileList, boolean dataCopyAtLoad) throws SemanticException {
        if (this.tableSpec == null) {
            this.writeMetaData(null);
        } else if (this.shouldExport()) {
            PartitionIterable withPartitions = this.getPartitions();
            this.writeMetaData(withPartitions);
            if (!(this.replicationSpec.isMetadataOnly() || this.replicationSpec.isRepl() && this.tableSpec.tableHandle.getTableType().equals((Object)TableType.EXTERNAL_TABLE))) {
                this.writeData(withPartitions, isExportTask, fileList, dataCopyAtLoad);
            }
        } else if (isExportTask) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg());
        }
    }

    private PartitionIterable getPartitions() throws SemanticException {
        try {
            if (this.tableSpec != null && this.tableSpec.tableHandle != null && this.tableSpec.tableHandle.isPartitioned()) {
                if (this.tableSpec.specType == BaseSemanticAnalyzer.TableSpec.SpecType.TABLE_ONLY) {
                    if (this.replicationSpec.isMetadataOnly()) {
                        return null;
                    }
                    return new PartitionIterable(this.db, this.tableSpec.tableHandle, null, this.conf.getIntVar(HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX), true);
                }
                return new PartitionIterable(this.tableSpec.partitions);
            }
            return null;
        }
        catch (HiveException e) {
            if (e.getCause() instanceof NoSuchObjectException) {
                return new PartitionIterable(new ArrayList<Partition>());
            }
            throw new SemanticException("Error when identifying partitions", (Throwable)e);
        }
    }

    private void writeMetaData(PartitionIterable partitions) throws SemanticException {
        try {
            EximUtil.createExportDump(this.paths.exportFileSystem, this.paths.metaDataExportFile(), this.tableSpec == null ? null : this.tableSpec.tableHandle, partitions, this.replicationSpec, this.conf);
            logger.debug("_metadata file written into " + this.paths.metaDataExportFile().toString());
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.IO_ERROR.getMsg("Exception while writing out the local file"), (Throwable)e);
        }
    }

    private void writeData(PartitionIterable partitions, boolean isExportTask, FileList fileList, boolean dataCopyAtLoad) throws SemanticException {
        try {
            if (this.tableSpec.tableHandle.isPartitioned()) {
                if (partitions == null) {
                    throw new IllegalStateException("partitions cannot be null for partitionTable :" + this.tableSpec.getTableName().getTable());
                }
                new PartitionExport(this.paths, partitions, this.distCpDoAsUser, this.conf, this.mmCtx).write(this.replicationSpec, isExportTask, fileList, dataCopyAtLoad);
            } else {
                List<Path> dataPathList = Utils.getDataPathList(this.tableSpec.tableHandle.getDataLocation(), this.replicationSpec, this.conf);
                if (!isExportTask && !dataCopyAtLoad) {
                    fileList.add(new EximUtil.DataCopyPath(this.replicationSpec, this.tableSpec.tableHandle.getDataLocation(), this.paths.dataExportDir()).convertToString());
                }
                new FileOperations(dataPathList, this.paths.dataExportDir(), this.distCpDoAsUser, this.conf, this.mmCtx).export(isExportTask, dataCopyAtLoad);
            }
        }
        catch (Exception e) {
            throw new SemanticException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean shouldExport() {
        return Utils.shouldReplicate(this.replicationSpec, this.tableSpec.tableHandle, false, null, null, this.conf);
    }

    public AuthEntities getAuthEntities() throws SemanticException {
        AuthEntities authEntities = new AuthEntities();
        try {
            if (this.replicationSpec.isMetadataOnly() || this.replicationSpec.isMetadataOnlyForExternalTables()) {
                return authEntities;
            }
            PartitionIterable partitions = this.getPartitions();
            if (this.tableSpec != null) {
                if (this.tableSpec.tableHandle.isPartitioned()) {
                    if (partitions == null) {
                        throw new IllegalStateException("partitions cannot be null for partitionTable :" + this.tableSpec.getTableName().getTable());
                    }
                    for (Partition partition : partitions) {
                        authEntities.inputs.add(new ReadEntity(partition));
                    }
                } else {
                    authEntities.inputs.add(new ReadEntity(this.tableSpec.tableHandle));
                }
            }
            authEntities.outputs.add(BaseSemanticAnalyzer.toWriteEntity(this.paths.metadataExportRootDir(), this.conf));
        }
        catch (Exception e) {
            throw new SemanticException((Throwable)e);
        }
        return authEntities;
    }

    public static class AuthEntities {
        public final Set<ReadEntity> inputs = Collections.newSetFromMap(new ConcurrentHashMap());
        public final Set<WriteEntity> outputs = new HashSet<WriteEntity>();
    }

    public static class Paths {
        private final String astRepresentationForErrorMsg;
        private final HiveConf conf;
        private final Path metadataExportRootDir;
        private final Path dataExportRootDir;
        private final FileSystem exportFileSystem;
        private boolean writeData;
        private boolean metadataExportRootDirCreated = false;
        private boolean dataExportRootDirCreated = false;

        public Paths(String astRepresentationForErrorMsg, Path dbMetadataRoot, Path dbDataRoot, String tblName, HiveConf conf, boolean shouldWriteData) throws SemanticException {
            this.astRepresentationForErrorMsg = astRepresentationForErrorMsg;
            this.conf = conf;
            this.writeData = shouldWriteData;
            Path tableRootForMetadataDump = new Path(dbMetadataRoot, tblName);
            Path tableRootForDataDump = new Path(dbDataRoot, tblName);
            URI metadataExportRootDirUri = EximUtil.getValidatedURI(conf, tableRootForMetadataDump.toUri().toString());
            this.validateTargetDir(metadataExportRootDirUri);
            URI dataExportRootDirUri = EximUtil.getValidatedURI(conf, tableRootForDataDump.toUri().toString());
            this.validateTargetDataDir(dataExportRootDirUri);
            this.metadataExportRootDir = new Path(metadataExportRootDirUri);
            this.dataExportRootDir = new Path(dataExportRootDirUri);
            try {
                this.exportFileSystem = this.metadataExportRootDir.getFileSystem((Configuration)conf);
            }
            catch (IOException e) {
                throw new SemanticException((Throwable)e);
            }
        }

        public Paths(String astRepresentationForErrorMsg, String path, HiveConf conf, boolean shouldWriteData) throws SemanticException {
            this.astRepresentationForErrorMsg = astRepresentationForErrorMsg;
            this.conf = conf;
            this.metadataExportRootDir = new Path(EximUtil.getValidatedURI(conf, path));
            this.dataExportRootDir = new Path(new Path(EximUtil.getValidatedURI(conf, path)), "data");
            this.writeData = shouldWriteData;
            try {
                this.exportFileSystem = this.metadataExportRootDir.getFileSystem((Configuration)conf);
            }
            catch (IOException e) {
                throw new SemanticException((Throwable)e);
            }
        }

        Path partitionMetadataExportDir(String partitionName) throws SemanticException {
            return this.exportDir(new Path(this.metadataExportRootDir(), partitionName));
        }

        Path partitionDataExportDir(String partitionName) throws SemanticException {
            return this.exportDir(new Path(this.dataExportRootDir(), partitionName));
        }

        public Path metadataExportRootDir() throws SemanticException {
            if (!this.metadataExportRootDirCreated) {
                try {
                    if (!this.exportFileSystem.exists(this.metadataExportRootDir) && this.writeData) {
                        this.exportFileSystem.mkdirs(this.metadataExportRootDir);
                    }
                    this.metadataExportRootDirCreated = true;
                }
                catch (IOException e) {
                    throw new SemanticException((Throwable)e);
                }
            }
            return this.metadataExportRootDir;
        }

        public Path dataExportRootDir() throws SemanticException {
            if (!this.dataExportRootDirCreated) {
                try {
                    if (!this.exportFileSystem.exists(this.dataExportRootDir) && this.writeData) {
                        this.exportFileSystem.mkdirs(this.dataExportRootDir);
                    }
                    this.dataExportRootDirCreated = true;
                }
                catch (IOException e) {
                    throw new SemanticException((Throwable)e);
                }
            }
            return this.dataExportRootDir;
        }

        private Path exportDir(Path exportDir) throws SemanticException {
            try {
                if (!this.exportFileSystem.exists(exportDir)) {
                    this.exportFileSystem.mkdirs(exportDir);
                }
                return exportDir;
            }
            catch (IOException e) {
                throw new SemanticException("error while creating directory for partition at " + exportDir, (Throwable)e);
            }
        }

        private Path metaDataExportFile() throws SemanticException {
            return new Path(this.metadataExportRootDir(), "_metadata");
        }

        private Path dataExportDir() throws SemanticException {
            return this.exportDir(this.dataExportRootDir());
        }

        private void validateTargetDir(URI rootDirExportFile) throws SemanticException {
            try {
                FileSystem fs = FileSystem.get((URI)rootDirExportFile, (Configuration)this.conf);
                Path toPath = new Path(rootDirExportFile.getScheme(), rootDirExportFile.getAuthority(), rootDirExportFile.getPath());
                try {
                    FileStatus tgt = fs.getFileStatus(toPath);
                    if (!tgt.isDirectory()) {
                        throw new SemanticException(this.astRepresentationForErrorMsg + ": Target is not a directory : " + rootDirExportFile);
                    }
                    FileStatus[] files = fs.listStatus(toPath, FileUtils.HIDDEN_FILES_PATH_FILTER);
                    if (files != null && files.length != 0) {
                        throw new SemanticException(this.astRepresentationForErrorMsg + ": Target is not an empty directory : " + rootDirExportFile);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            catch (IOException e) {
                throw new SemanticException(this.astRepresentationForErrorMsg, (Throwable)e);
            }
        }

        private void validateTargetDataDir(URI rootDirExportFile) throws SemanticException {
            try {
                FileSystem fs = FileSystem.get((URI)rootDirExportFile, (Configuration)this.conf);
                Path toPath = new Path(rootDirExportFile.getScheme(), rootDirExportFile.getAuthority(), rootDirExportFile.getPath());
                try {
                    FileStatus tgt = fs.getFileStatus(toPath);
                    if (!tgt.isDirectory()) {
                        throw new SemanticException(this.astRepresentationForErrorMsg + ": Target is not a directory : " + rootDirExportFile);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            catch (IOException e) {
                throw new SemanticException(this.astRepresentationForErrorMsg, (Throwable)e);
            }
        }
    }
}

