/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.RewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class UpdateDeleteSemanticAnalyzer
extends RewriteSemanticAnalyzer {
    private Context.Operation operation = Context.Operation.OTHER;

    UpdateDeleteSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyze(ASTNode tree) throws SemanticException {
        switch (tree.getToken().getType()) {
            case 891: {
                this.analyzeDelete(tree);
                break;
            }
            case 1193: {
                this.analyzeUpdate(tree);
                break;
            }
            default: {
                throw new RuntimeException("Asked to parse token " + tree.getName() + " in UpdateDeleteSemanticAnalyzer");
            }
        }
    }

    private void analyzeUpdate(ASTNode tree) throws SemanticException {
        this.operation = Context.Operation.UPDATE;
        this.reparseAndSuperAnalyze(tree);
    }

    private void analyzeDelete(ASTNode tree) throws SemanticException {
        this.operation = Context.Operation.DELETE;
        this.reparseAndSuperAnalyze(tree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reparseAndSuperAnalyze(ASTNode tree) throws SemanticException {
        int whereIndex;
        List children = tree.getChildren();
        ASTNode tabName = (ASTNode)children.get(0);
        assert (tabName.getToken().getType() == 1162) : "Expected tablename as first child of " + (Object)((Object)this.operation) + " but found " + tabName.getName();
        Table mTable = this.getTargetTable(tabName);
        this.validateTargetTable(mTable);
        StringBuilder rewrittenQueryStr = new StringBuilder();
        rewrittenQueryStr.append("insert into table ");
        rewrittenQueryStr.append(this.getFullTableNameForSQL(tabName));
        this.addPartitionColsToInsert(mTable.getPartCols(), rewrittenQueryStr);
        rewrittenQueryStr.append(" select ROW__ID");
        HashMap<Integer, ASTNode> setColExprs = null;
        Map<String, ASTNode> setCols = null;
        LinkedHashSet<String> setRCols = new LinkedHashSet<String>();
        if (this.updating()) {
            assert (children.size() >= 2) : "Expected update token to have at least two children";
            ASTNode setClause = (ASTNode)children.get(1);
            setCols = this.collectSetColumnsAndExpressions(setClause, setRCols, mTable);
            setColExprs = new HashMap<Integer, ASTNode>(setClause.getChildCount());
            List<FieldSchema> nonPartCols = mTable.getCols();
            for (int i = 0; i < nonPartCols.size(); ++i) {
                rewrittenQueryStr.append(',');
                String name = nonPartCols.get(i).getName();
                ASTNode setCol = setCols.get(name);
                rewrittenQueryStr.append(HiveUtils.unparseIdentifier(name, (Configuration)this.conf));
                if (setCol == null) continue;
                setColExprs.put(i + 1, setCol);
            }
        }
        this.addPartitionColsToSelect(mTable.getPartCols(), rewrittenQueryStr, null);
        rewrittenQueryStr.append(" from ");
        rewrittenQueryStr.append(this.getFullTableNameForSQL(tabName));
        ASTNode where = null;
        int n = whereIndex = this.deleting() ? 1 : 2;
        if (children.size() > whereIndex) {
            where = (ASTNode)children.get(whereIndex);
            assert (where.getToken().getType() == 1204) : "Expected where clause, but found " + where.getName();
        }
        rewrittenQueryStr.append(" sort by ROW__ID ");
        RewriteSemanticAnalyzer.ReparseResult rr = this.parseRewrittenQuery(rewrittenQueryStr, this.ctx.getCmd());
        Context rewrittenCtx = rr.rewrittenCtx;
        ASTNode rewrittenTree = rr.rewrittenTree;
        ASTNode rewrittenInsert = (ASTNode)rewrittenTree.getChildren().get(1);
        assert (rewrittenInsert.getToken().getType() == 950) : "Expected TOK_INSERT as second child of TOK_QUERY but found " + rewrittenInsert.getName();
        if (this.updating()) {
            rewrittenCtx.setOperation(Context.Operation.UPDATE);
            rewrittenCtx.addDestNamePrefix(1, Context.DestClausePrefix.UPDATE);
        } else if (this.deleting()) {
            rewrittenCtx.setOperation(Context.Operation.DELETE);
            rewrittenCtx.addDestNamePrefix(1, Context.DestClausePrefix.DELETE);
        }
        if (where != null) {
            ASTNode sortBy = (ASTNode)rewrittenInsert.getChildren().get(2);
            assert (sortBy.getToken().getType() == 1119) : "Expected TOK_SORTBY to be first child of TOK_SELECT, but found " + sortBy.getName();
            rewrittenInsert.addChild((Tree)sortBy);
            rewrittenInsert.setChild(2, (Tree)where);
        }
        if (this.updating() && setColExprs != null) {
            ASTNode rewrittenSelect = (ASTNode)rewrittenInsert.getChildren().get(1);
            assert (rewrittenSelect.getToken().getType() == 1082) : "Expected TOK_SELECT as second child of TOK_INSERT but found " + rewrittenSelect.getName();
            for (Map.Entry entry : setColExprs.entrySet()) {
                ASTNode selExpr = (ASTNode)rewrittenSelect.getChildren().get((Integer)entry.getKey());
                assert (selExpr.getToken().getType() == 1084) : "Expected child of TOK_SELECT to be TOK_SELEXPR but was " + selExpr.getName();
                selExpr.setChild(0, (Tree)entry.getValue());
            }
        }
        try {
            this.useSuper = true;
            rewrittenCtx.setEnableUnparse(false);
            super.analyze(rewrittenTree, rewrittenCtx);
        }
        finally {
            this.useSuper = false;
        }
        this.updateOutputs(mTable);
        if (this.updating()) {
            this.setUpAccessControlInfoForUpdate(mTable, setCols);
            for (String colName : setRCols) {
                if (this.columnAccessInfo == null) continue;
                this.columnAccessInfo.add(Table.getCompleteName(mTable.getDbName(), mTable.getTableName()), colName);
            }
        }
    }

    private boolean updating() {
        return this.operation == Context.Operation.UPDATE;
    }

    private boolean deleting() {
        return this.operation == Context.Operation.DELETE;
    }
}

