/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AcidExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExecuteStatementAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSQRewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MergeSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.PrepareStatementAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ScheduledQueryAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UpdateDeleteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SemanticAnalyzerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SemanticAnalyzerFactory.class);

    private SemanticAnalyzerFactory() {
        throw new UnsupportedOperationException("SemanticAnalyzerFactory should not be instantiated");
    }

    public static BaseSemanticAnalyzer get(QueryState queryState, ASTNode tree) throws SemanticException {
        BaseSemanticAnalyzer sem = SemanticAnalyzerFactory.getInternal(queryState, tree);
        if (queryState.getHiveOperation() == null) {
            String query = queryState.getQueryString();
            if (query != null && query.length() > 30) {
                query = query.substring(0, 30);
            }
            String msg = "Unknown HiveOperation for query='" + query + "' queryId=" + queryState.getQueryId();
            LOG.debug(msg);
        }
        return sem;
    }

    private static BaseSemanticAnalyzer getInternal(QueryState queryState, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        HiveOperation opType = HiveOperation.operationForToken(tree.getType());
        queryState.setCommandType(opType);
        if (DDLSemanticAnalyzerFactory.handles(tree)) {
            return DDLSemanticAnalyzerFactory.getAnalyzer(tree, queryState);
        }
        switch (tree.getType()) {
            case 920: {
                return new ExplainSemanticAnalyzer(queryState);
            }
            case 921: {
                return new ExplainSQRewriteSemanticAnalyzer(queryState);
            }
            case 980: {
                return new LoadSemanticAnalyzer(queryState);
            }
            case 923: {
                if (AcidExportSemanticAnalyzer.isAcidExport(tree)) {
                    return new AcidExportSemanticAnalyzer(queryState);
                }
                return new ExportSemanticAnalyzer(queryState);
            }
            case 948: {
                return new ImportSemanticAnalyzer(queryState);
            }
            case 1062: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 1063: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 1064: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 822: {
                Tree child = tree.getChild(1);
                assert (child.getType() == 1049);
                queryState.setCommandType(HiveOperation.ALTERVIEW_AS);
                return new SemanticAnalyzer(queryState);
            }
            case 845: {
                return new ColumnStatsSemanticAnalyzer(queryState);
            }
            case 891: 
            case 1193: {
                return new UpdateDeleteSemanticAnalyzer(queryState);
            }
            case 985: {
                return new MergeSemanticAnalyzer(queryState);
            }
            case 843: 
            case 871: 
            case 911: {
                return new ScheduledQueryAnalyzer(queryState);
            }
            case 917: {
                return new ExecuteStatementAnalyzer(queryState);
            }
            case 1031: {
                return new PrepareStatementAnalyzer(queryState);
            }
        }
        SemanticAnalyzer semAnalyzer = HiveConf.getBoolVar((Configuration)queryState.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_ENABLED) ? new CalcitePlanner(queryState) : new SemanticAnalyzer(queryState);
        return semAnalyzer;
    }
}

