/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTErrorUtils;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.BasicStatsWork;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.mapred.InputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadSemanticAnalyzer
extends SemanticAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(LoadSemanticAnalyzer.class);
    private boolean queryReWritten = false;
    private final String tempTblNameSuffix = "__temp_table_for_load_data__";
    private Tree fromTree;
    private Tree tableTree;
    private boolean isLocal = false;
    private boolean isOverWrite = false;
    private String inputFormatClassName = null;
    private String serDeClassName = null;

    public LoadSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    public static FileStatus[] matchFilesOrDir(FileSystem fs, Path path) throws IOException {
        FileStatus[] srcs = fs.globStatus(path, new PathFilter(){

            public boolean accept(Path p) {
                String name = p.getName();
                return name.equals("_metadata") || !name.startsWith("_") && !name.startsWith(".");
            }
        });
        if (srcs != null && srcs.length == 1 && srcs[0].isDirectory()) {
            srcs = fs.listStatus(srcs[0].getPath(), new PathFilter(){

                public boolean accept(Path p) {
                    String name = p.getName();
                    return !name.startsWith("_") && !name.startsWith(".");
                }
            });
        }
        return srcs;
    }

    private URI initializeFromURI(String fromPath, boolean isLocal) throws IOException, URISyntaxException, SemanticException {
        URI defaultURI;
        URI fromURI = new Path(fromPath).toUri();
        String fromScheme = fromURI.getScheme();
        String fromAuthority = fromURI.getAuthority();
        String path = fromURI.getPath();
        if (!path.startsWith("/")) {
            if (isLocal) {
                try {
                    path = new String(URLCodec.decodeUrl((byte[])new Path(System.getProperty("user.dir"), fromPath).toUri().toString().getBytes("US-ASCII")), "US-ASCII");
                }
                catch (DecoderException de) {
                    throw new SemanticException("URL Decode failed", (Throwable)de);
                }
            } else {
                path = new Path(new Path("/user/" + System.getProperty("user.name")), path).toString();
            }
        }
        if (StringUtils.isEmpty((CharSequence)fromScheme)) {
            if (isLocal) {
                fromScheme = "file";
            } else {
                defaultURI = FileSystem.get((Configuration)this.conf).getUri();
                fromScheme = defaultURI.getScheme();
                fromAuthority = defaultURI.getAuthority();
            }
        }
        if (!fromScheme.equals("file") && StringUtils.isEmpty((CharSequence)fromAuthority)) {
            defaultURI = FileSystem.get((Configuration)this.conf).getUri();
            fromAuthority = defaultURI.getAuthority();
        }
        LOG.debug(fromScheme + "@" + fromAuthority + "@" + path);
        return new URI(fromScheme, fromAuthority, path, null, null);
    }

    private List<FileStatus> applyConstraintsAndGetFiles(URI fromURI, Table table) throws SemanticException {
        Object[] srcs = null;
        if (this.isLocal && !fromURI.getScheme().equals("file")) {
            throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.ILLEGAL_PATH.getMsg(), (Tree)this.fromTree, (String)"Source file system should be \"file\" if \"local\" is specified"));
        }
        try {
            FileSystem fileSystem = FileSystem.get((URI)fromURI, (Configuration)this.conf);
            srcs = LoadSemanticAnalyzer.matchFilesOrDir(fileSystem, new Path(fromURI));
            if (srcs == null || srcs.length == 0) {
                throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_PATH.getMsg(), (Tree)this.fromTree, (String)("No files matching path " + fromURI)));
            }
            for (FileStatus fileStatus : srcs) {
                if (!fileStatus.isDir()) continue;
                this.reparseAndSuperAnalyze(table, fromURI);
                return null;
            }
            AcidUtils.validateAcidFiles(table, (FileStatus[])srcs, fileSystem);
            List<String> bucketCols = table.getBucketCols();
            if (bucketCols != null && !bucketCols.isEmpty()) {
                boolean[] bucketArray = new boolean[table.getNumBuckets()];
                Arrays.fill(bucketArray, false);
                int numBuckets = table.getNumBuckets();
                for (Object oneSrc : srcs) {
                    String bucketName = oneSrc.getPath().getName();
                    String bucketIdStr = Utilities.getBucketFileNameFromPathSubString(bucketName);
                    int bucketId = Utilities.getBucketIdFromFile(bucketIdStr);
                    LOG.debug("bucket ID for file " + oneSrc.getPath() + " = " + bucketId + " for table " + table.getFullyQualifiedName());
                    if (bucketId == -1 || bucketId >= numBuckets || bucketArray[bucketId]) {
                        this.reparseAndSuperAnalyze(table, fromURI);
                        return null;
                    }
                    bucketArray[bucketId] = true;
                }
            }
        }
        catch (IOException e) {
            throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_PATH.getMsg(), (Tree)this.fromTree), (Throwable)e);
        }
        return Lists.newArrayList((Object[])srcs);
    }

    @Override
    public void init(boolean clearPartsCache) {
        Table tempTable = this.ctx.getTempTableForLoad();
        if (tempTable != null) {
            super.init(clearPartsCache);
            this.tabNameToTabObject.put(tempTable.getTableName().toLowerCase(), tempTable);
        }
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        if (this.ctx.getTempTableForLoad() != null) {
            super.analyzeInternal(ast);
        } else {
            this.analyzeLoad(ast);
        }
    }

    private void analyzeLoad(ASTNode ast) throws SemanticException {
        String error;
        URI fromURI;
        this.fromTree = ast.getChild(0);
        this.tableTree = ast.getChild(1);
        boolean inputInfo = false;
        ASTNode child = (ASTNode)ast.getChild(ast.getChildCount() - 1);
        if (child.getToken().getType() == 949) {
            if (child.getChildCount() != 2) {
                throw new SemanticException("FileFormat should contain both input format and Serde");
            }
            try {
                this.inputFormatClassName = LoadSemanticAnalyzer.stripQuotes(child.getChild(0).getText());
                this.serDeClassName = LoadSemanticAnalyzer.stripQuotes(child.getChild(1).getText());
                inputInfo = true;
            }
            catch (Exception e) {
                throw new SemanticException("FileFormat inputFormatClassName or serDeClassName is incorrect");
            }
        }
        if (!inputInfo && ast.getChildCount() == 4 || inputInfo && ast.getChildCount() == 5) {
            this.isLocal = true;
            this.isOverWrite = true;
        }
        if (!inputInfo && ast.getChildCount() == 3 || inputInfo && ast.getChildCount() == 4) {
            if (ast.getChild(2).getText().toLowerCase().equals("local")) {
                this.isLocal = true;
            } else {
                this.isOverWrite = true;
            }
        }
        try {
            String fromPath = LoadSemanticAnalyzer.stripQuotes(this.fromTree.getText());
            fromURI = this.initializeFromURI(fromPath, this.isLocal);
        }
        catch (IOException | URISyntaxException e) {
            throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_PATH.getMsg(), (Tree)this.fromTree, (String)e.getMessage()), (Throwable)e);
        }
        BaseSemanticAnalyzer.TableSpec ts = new BaseSemanticAnalyzer.TableSpec(this.db, this.conf, (ASTNode)this.tableTree);
        if (ts.tableHandle.isView() || ts.tableHandle.isMaterializedView()) {
            throw new SemanticException(ErrorMsg.DML_AGAINST_VIEW.getMsg());
        }
        if (ts.tableHandle.isNonNative()) {
            throw new SemanticException(ErrorMsg.LOAD_INTO_NON_NATIVE.getMsg());
        }
        if (ts.tableHandle.isStoredAsSubDirectories()) {
            throw new SemanticException(ErrorMsg.LOAD_INTO_STORED_AS_DIR.getMsg());
        }
        List<FieldSchema> parts = ts.tableHandle.getPartitionKeys();
        if (parts != null && parts.size() > 0 && (ts.partSpec == null || ts.partSpec.size() == 0)) {
            this.reparseAndSuperAnalyze(ts.tableHandle, fromURI);
            return;
        }
        List<String> bucketCols = ts.tableHandle.getBucketCols();
        if (bucketCols != null && !bucketCols.isEmpty() && (error = HiveConf.StrictChecks.checkBucketing((Configuration)this.conf)) != null) {
            this.reparseAndSuperAnalyze(ts.tableHandle, fromURI);
            return;
        }
        List<FileStatus> files = this.applyConstraintsAndGetFiles(fromURI, ts.tableHandle);
        if (this.queryReWritten) {
            return;
        }
        if (TableType.MANAGED_TABLE.equals((Object)ts.tableHandle.getTableType()) && this.conf.getBoolVar(HiveConf.ConfVars.HIVECHECKFILEFORMAT)) {
            this.ensureFileFormatsMatch(ts, files, fromURI);
        }
        this.inputs.add(this.toReadEntity(new Path(fromURI)));
        boolean preservePartitionSpecs = false;
        Map<String, String> partSpec = ts.getPartSpec();
        if (partSpec == null) {
            partSpec = new LinkedHashMap<String, String>();
            this.outputs.add(new WriteEntity(ts.tableHandle, this.isOverWrite ? WriteEntity.WriteType.INSERT_OVERWRITE : WriteEntity.WriteType.INSERT));
        } else {
            try {
                Partition part = Hive.get().getPartition(ts.tableHandle, partSpec, false);
                if (part != null) {
                    if (this.isOverWrite) {
                        this.outputs.add(new WriteEntity(part, WriteEntity.WriteType.INSERT_OVERWRITE));
                    } else {
                        this.outputs.add(new WriteEntity(part, WriteEntity.WriteType.INSERT));
                        preservePartitionSpecs = true;
                    }
                } else {
                    this.outputs.add(new WriteEntity(ts.tableHandle, this.isOverWrite ? WriteEntity.WriteType.INSERT_OVERWRITE : WriteEntity.WriteType.INSERT));
                }
            }
            catch (HiveException e) {
                throw new SemanticException((Throwable)e);
            }
        }
        Long writeId = null;
        int stmtId = -1;
        boolean isTxnTable = AcidUtils.isTransactionalTable(ts.tableHandle);
        if (isTxnTable) {
            try {
                writeId = this.getTxnMgr().getTableWriteId(ts.tableHandle.getDbName(), ts.tableHandle.getTableName());
            }
            catch (LockException ex) {
                throw new SemanticException("Failed to allocate the write id", (Throwable)((Object)ex));
            }
            stmtId = this.getTxnMgr().getStmtIdAndIncrement();
        }
        LoadTableDesc loadTableWork = new LoadTableDesc(new Path(fromURI), Utilities.getTableDesc(ts.tableHandle), partSpec, this.isOverWrite ? LoadTableDesc.LoadFileType.REPLACE_ALL : LoadTableDesc.LoadFileType.KEEP_EXISTING, writeId);
        loadTableWork.setStmtId(stmtId);
        loadTableWork.setInsertOverwrite(this.isOverWrite);
        if (preservePartitionSpecs) {
            loadTableWork.setInheritTableSpecs(false);
        }
        Task<MoveWork> childTask = TaskFactory.get(new MoveWork(this.getInputs(), this.getOutputs(), loadTableWork, null, true, this.isLocal));
        this.rootTasks.add(childTask);
        Task<StatsWork> statTask = null;
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
            BasicStatsWork basicStatsWork = new BasicStatsWork(loadTableWork);
            basicStatsWork.setNoStatsAggregator(true);
            basicStatsWork.setClearAggregatorStats(true);
            StatsWork columnStatsWork = new StatsWork(ts.tableHandle, basicStatsWork, this.conf);
            statTask = TaskFactory.get(columnStatsWork);
        }
        if (statTask != null) {
            childTask.addDependentTask(statTask);
        }
    }

    private void ensureFileFormatsMatch(BaseSemanticAnalyzer.TableSpec ts, List<FileStatus> fileStatuses, URI fromURI) throws SemanticException {
        Class<? extends InputFormat> destInputFormat;
        try {
            destInputFormat = ts.getPartSpec() == null || ts.getPartSpec().isEmpty() ? ts.tableHandle.getInputFormatClass() : ts.partHandle.getInputFormatClass();
        }
        catch (HiveException e) {
            throw new SemanticException((Throwable)e);
        }
        try {
            FileSystem fs = FileSystem.get((URI)fromURI, (Configuration)this.conf);
            boolean validFormat = HiveFileFormatUtils.checkInputFormat(fs, this.conf, destInputFormat, fileStatuses);
            if (!validFormat) {
                throw new SemanticException(ErrorMsg.INVALID_FILE_FORMAT_IN_LOAD.getMsg());
            }
        }
        catch (Exception e) {
            throw new SemanticException("Unable to load data to destination table. Error: " + e.getMessage());
        }
    }

    private void reparseAndSuperAnalyze(Table table, URI fromURI) throws SemanticException {
        ASTNode rewrittenTree;
        LOG.info("Load data triggered a Tez job instead of usual file operation");
        Table tempTableObj = new Table(new org.apache.hadoop.hive.metastore.api.Table(table.getTTable()));
        String tempTblName = table.getTableName() + "__temp_table_for_load_data__";
        tempTableObj.setTableName(tempTblName);
        tempTableObj.setParameters(new HashMap<String, String>());
        tempTableObj.setDataLocation(new Path(fromURI));
        if (this.inputFormatClassName != null && this.serDeClassName != null) {
            try {
                tempTableObj.setInputFormatClass(this.inputFormatClassName);
                tempTableObj.setSerializationLib(this.serDeClassName);
            }
            catch (HiveException e) {
                throw new SemanticException("Load Data: Failed to set inputFormat or SerDe");
            }
        }
        ArrayList<FieldSchema> colList = new ArrayList<FieldSchema>();
        colList.addAll(table.getCols());
        HashMap<String, String> inpPartSpec = null;
        List<FieldSchema> parts = table.getPartCols();
        if (this.tableTree.getChildCount() >= 2) {
            ASTNode partSpecNode = (ASTNode)this.tableTree.getChild(1);
            inpPartSpec = new HashMap<String, String>(partSpecNode.getChildCount());
            for (int i = 0; i < partSpecNode.getChildCount(); ++i) {
                ASTNode partSpecValNode = (ASTNode)partSpecNode.getChild(i);
                String partVal = null;
                String partColName = LoadSemanticAnalyzer.unescapeIdentifier(partSpecValNode.getChild(0).getText().toLowerCase());
                if (partSpecValNode.getChildCount() >= 2) {
                    partVal = partSpecValNode.getChild(1).getText();
                }
                inpPartSpec.put(partColName, partVal);
            }
            for (FieldSchema fs : parts) {
                String partKey = fs.getName();
                if (inpPartSpec.get(partKey) != null) continue;
                colList.add(fs);
            }
        } else {
            colList.addAll(parts);
        }
        tempTableObj.setFields(colList);
        tempTableObj.setPartCols(new ArrayList<FieldSchema>());
        StringBuilder rewrittenQueryStr = new StringBuilder();
        rewrittenQueryStr.append("insert into table ");
        rewrittenQueryStr.append(this.getFullTableNameForSQL((ASTNode)this.tableTree.getChild(0)));
        this.addPartitionColsToInsert(table.getPartCols(), inpPartSpec, rewrittenQueryStr);
        rewrittenQueryStr.append(" select * from ");
        rewrittenQueryStr.append(tempTblName);
        HiveConf.setVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.DYNAMICPARTITIONINGMODE, (String)"nonstrict");
        Context rewrittenCtx = new Context((Configuration)this.conf);
        this.ctx.addSubContext(rewrittenCtx);
        rewrittenCtx.setExplainConfig(this.ctx.getExplainConfig());
        rewrittenCtx.setExplainPlan(this.ctx.isExplainPlan());
        rewrittenCtx.setCmd(rewrittenQueryStr.toString());
        rewrittenCtx.setTempTableForLoad(tempTableObj);
        try {
            LOG.info("Going to reparse <" + this.ctx.getCmd() + "> as \n<" + rewrittenQueryStr.toString() + ">");
            rewrittenTree = ParseUtils.parse(rewrittenQueryStr.toString(), rewrittenCtx);
        }
        catch (ParseException e) {
            throw new SemanticException(ErrorMsg.LOAD_DATA_LAUNCH_JOB_PARSE_ERROR.getMsg(), (Throwable)e);
        }
        super.analyze(rewrittenTree, rewrittenCtx);
        this.queryReWritten = true;
    }

    @Override
    public Set<WriteEntity> getAllOutputs() {
        return this.outputs;
    }
}

