/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;

public final class HiveTableName
extends TableName {
    public HiveTableName(String catName, String dbName, String tableName) {
        super(catName, dbName, tableName);
    }

    public static TableName of(Table table) throws SemanticException {
        return HiveTableName.ofNullable(table.getTableName(), table.getDbName());
    }

    public static Table setFrom(String dbTable, Table table) throws SemanticException {
        TableName name = HiveTableName.ofNullable(dbTable);
        table.setTableName(name.getTable());
        table.setDbName(name.getDb());
        return table;
    }

    public static TableName ofNullable(String dbTableName) throws SemanticException {
        return HiveTableName.ofNullable(dbTableName, SessionState.get().getCurrentDatabase());
    }

    public static TableName ofNullableWithNoDefault(String dbTableName) throws SemanticException {
        return HiveTableName.ofNullable(dbTableName, null);
    }

    public static TableName ofNullable(String dbTableName, String defaultDb) throws SemanticException {
        if (dbTableName == null) {
            return new TableName(null, null, null);
        }
        try {
            return HiveTableName.fromString((String)dbTableName, (String)SessionState.get().getCurrentCatalog(), (String)defaultDb);
        }
        catch (IllegalArgumentException e) {
            throw new SemanticException((Throwable)e);
        }
    }

    public static TableName withNoDefault(String dbTableName) throws SemanticException {
        try {
            return HiveTableName.fromString((String)dbTableName, null, null);
        }
        catch (IllegalArgumentException e) {
            throw new SemanticException((Throwable)e);
        }
    }

    public static TableName of(String dbTableName) throws SemanticException {
        try {
            return HiveTableName.fromString((String)dbTableName, (String)SessionState.get().getCurrentCatalog(), (String)SessionState.get().getCurrentDatabase());
        }
        catch (IllegalArgumentException e) {
            throw new SemanticException((Throwable)e);
        }
    }
}

