/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.CommonMergeJoinOperator;
import org.apache.hadoop.hive.ql.exec.DummyStoreOperator;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.optimizer.ReduceSinkMapJoinProc;
import org.apache.hadoop.hive.ql.parse.GenTezProcContext;
import org.apache.hadoop.hive.ql.parse.GenTezUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.CommonMergeJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MergeJoinWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TezEdgeProperty;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.plan.UnionWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenTezWork
implements SemanticNodeProcessor {
    private static final Logger LOG = LoggerFactory.getLogger((String)GenTezWork.class.getName());
    private final GenTezUtils utils;

    public GenTezWork(GenTezUtils utils) {
        this.utils = utils;
    }

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procContext, Object ... nodeOutputs) throws SemanticException {
        Object work;
        GenTezProcContext context = (GenTezProcContext)procContext;
        assert (context != null && context.currentTask != null && context.currentRootOperator != null);
        Operator operator = (Operator)nd;
        Operator<? extends OperatorDesc> root = context.currentRootOperator;
        LOG.debug("Root operator: " + root);
        LOG.debug("Leaf operator: " + operator);
        if (context.clonedReduceSinks.contains(operator)) {
            return null;
        }
        TezWork tezWork = (TezWork)context.currentTask.getWork();
        if (context.rootToWorkMap.containsKey(root)) {
            if (context.childToWorkMap.containsKey(operator)) {
                context.currentMapJoinOperators.clear();
                context.currentUnionOperators.clear();
                return null;
            }
            work = context.rootToWorkMap.get(root);
        } else {
            work = context.preceedingWork == null ? this.utils.createMapWork(context, root, tezWork, null) : GenTezUtils.createReduceWork(context, root, tezWork);
            context.rootToWorkMap.put(root, (BaseWork)work);
        }
        if (operator instanceof DummyStoreOperator) {
            ((BaseWork)work).addSortCols(root.getOpTraits().getSortCols().get(0));
        }
        if (!context.childToWorkMap.containsKey(operator)) {
            LinkedList<BaseWork> workItems = new LinkedList<BaseWork>();
            workItems.add((BaseWork)work);
            context.childToWorkMap.put(operator, workItems);
        } else {
            context.childToWorkMap.get(operator).add((BaseWork)work);
        }
        if (context.currentMergeJoinOperator != null) {
            TezEdgeProperty edgeProp;
            Object mergeJoinWork = null;
            if (context.opMergeJoinWorkMap.containsKey(context.currentMergeJoinOperator)) {
                mergeJoinWork = context.opMergeJoinWorkMap.get(context.currentMergeJoinOperator);
            } else {
                mergeJoinWork = new MergeJoinWork();
                ((MergeJoinWork)mergeJoinWork).setMergeJoinOperator(context.currentMergeJoinOperator);
                tezWork.add((BaseWork)mergeJoinWork);
                context.opMergeJoinWorkMap.put(context.currentMergeJoinOperator, (MergeJoinWork)mergeJoinWork);
            }
            ((BaseWork)work).addSortCols(root.getOpTraits().getSortCols().get(0));
            ((MergeJoinWork)mergeJoinWork).addMergedWork((BaseWork)work, null, context.leafOperatorToFollowingWork);
            Operator<? extends OperatorDesc> operator2 = this.getParentFromStack(context.currentMergeJoinOperator, stack);
            int pos = ((CommonMergeJoinDesc)context.currentMergeJoinOperator.getConf()).getBigTablePosition();
            ((BaseWork)work).setTag(pos);
            ((CommonMergeJoinDesc)context.currentMergeJoinOperator.getConf()).setBigTablePosition(pos);
            tezWork.setVertexType((BaseWork)work, TezWork.VertexType.MULTI_INPUT_UNINITIALIZED_EDGES);
            for (BaseWork parentWork : tezWork.getParents((BaseWork)work)) {
                edgeProp = tezWork.getEdgeProperty(parentWork, (BaseWork)work);
                tezWork.disconnect(parentWork, (BaseWork)work);
                tezWork.connect(parentWork, (BaseWork)mergeJoinWork, edgeProp);
            }
            for (BaseWork childWork : tezWork.getChildren((BaseWork)work)) {
                edgeProp = tezWork.getEdgeProperty((BaseWork)work, childWork);
                tezWork.disconnect((BaseWork)work, childWork);
                tezWork.connect((BaseWork)mergeJoinWork, childWork, edgeProp);
            }
            tezWork.remove((BaseWork)work);
            context.rootToWorkMap.put(root, (BaseWork)mergeJoinWork);
            context.childToWorkMap.get(operator).remove(work);
            context.childToWorkMap.get(operator).add((BaseWork)mergeJoinWork);
            work = mergeJoinWork;
            context.currentMergeJoinOperator = null;
        }
        if (!context.currentMapJoinOperators.isEmpty()) {
            for (MapJoinOperator mapJoinOperator : context.currentMapJoinOperators) {
                Map<BaseWork, TezEdgeProperty> linkWorkMap;
                if (((MapJoinDesc)mapJoinOperator.getConf()).isDynamicPartitionHashJoin()) {
                    ReduceWork reduceWork = (ReduceWork)work;
                    int bigTablePosition = ((MapJoinDesc)mapJoinOperator.getConf()).getPosBigTable();
                    reduceWork.setTag(bigTablePosition);
                    List<Operator<?>> mapJoinOriginalParents = context.mapJoinParentMap.get(mapJoinOperator);
                    if (mapJoinOriginalParents == null) {
                        throw new SemanticException("Unexpected error - context.mapJoinParentMap did not have an entry for " + mapJoinOperator);
                    }
                    for (int pos = 0; pos < mapJoinOriginalParents.size(); ++pos) {
                        if (pos == bigTablePosition) continue;
                        Operator<?> parentOp = mapJoinOriginalParents.get(pos);
                        context.smallTableParentToMapJoinMap.put(parentOp, mapJoinOperator);
                        ReduceSinkOperator parentRS = (ReduceSinkOperator)parentOp;
                        GenMapRedUtils.setKeyAndValueDesc(reduceWork, parentRS);
                        if (context.mapJoinToUnprocessedSmallTableReduceSinks.get(mapJoinOperator).contains(parentRS)) continue;
                        BaseWork parentWork = ReduceSinkMapJoinProc.getMapJoinParentWork(context, parentRS);
                        int tag = ((ReduceSinkDesc)parentRS.getConf()).getTag();
                        tag = tag == -1 ? 0 : tag;
                        reduceWork.getTagToInput().put(tag, parentWork.getName());
                    }
                }
                LOG.debug("Processing map join: " + mapJoinOperator);
                if (!context.mapJoinWorkMap.containsKey(mapJoinOperator)) {
                    LinkedList<BaseWork> workItems = new LinkedList<BaseWork>();
                    workItems.add((BaseWork)work);
                    context.mapJoinWorkMap.put(mapJoinOperator, workItems);
                } else {
                    context.mapJoinWorkMap.get(mapJoinOperator).add((BaseWork)work);
                }
                if (!context.linkOpWithWorkMap.containsKey(mapJoinOperator) || (linkWorkMap = context.linkOpWithWorkMap.get(mapJoinOperator)) == null) continue;
                if (context.linkChildOpWithDummyOp.containsKey(mapJoinOperator)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Adding dummy ops to work: " + ((BaseWork)work).getName() + ": " + context.linkChildOpWithDummyOp.get(mapJoinOperator));
                    }
                    for (Operator<?> dummy : context.linkChildOpWithDummyOp.get(mapJoinOperator)) {
                        ((BaseWork)work).addDummyOp((HashTableDummyOperator)dummy);
                    }
                }
                for (Map.Entry<BaseWork, TezEdgeProperty> parentWorkMap : linkWorkMap.entrySet()) {
                    BaseWork parentWork = parentWorkMap.getKey();
                    LOG.debug("connecting " + parentWork.getName() + " with " + ((BaseWork)work).getName());
                    TezEdgeProperty edgeProp = parentWorkMap.getValue();
                    tezWork.connect(parentWork, (BaseWork)work, edgeProp);
                    if (edgeProp.getEdgeType() == TezEdgeProperty.EdgeType.CUSTOM_EDGE) {
                        tezWork.setVertexType((BaseWork)work, TezWork.VertexType.INITIALIZED_EDGES);
                    }
                    for (ReduceSinkOperator r : context.linkWorkWithReduceSinkMap.get(parentWork)) {
                        if (!context.mapJoinParentMap.get(mapJoinOperator).contains(r)) continue;
                        if (((ReduceSinkDesc)r.getConf()).getOutputName() != null) {
                            LOG.debug("Cloning reduce sink " + r + " for multi-child broadcast edge");
                            r = (ReduceSinkOperator)OperatorFactory.getAndMakeChild(r.getCompilationOpContext(), (ReduceSinkDesc)((ReduceSinkDesc)r.getConf()).clone(), new RowSchema(r.getSchema()), r.getParentOperators());
                            context.clonedReduceSinks.add(r);
                        }
                        ((ReduceSinkDesc)r.getConf()).setOutputName(((BaseWork)work).getName());
                        context.connectedReduceSinks.add(r);
                    }
                }
            }
            context.currentMapJoinOperators.clear();
        }
        for (Operator operator3 : new ArrayList<Operator<OperatorDesc>>(root.getParentOperators())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removing " + operator3 + " as parent from " + root);
            }
            context.leafOperatorToFollowingWork.remove(operator3);
            context.leafOperatorToFollowingWork.put(operator3, (BaseWork)work);
            root.removeParent(operator3);
        }
        if (!context.currentUnionOperators.isEmpty()) {
            UnionWork unionWork;
            if (context.unionWorkMap.containsKey(operator)) {
                assert (operator.getChildOperators().isEmpty());
                unionWork = (UnionWork)context.unionWorkMap.get(operator);
                this.connectUnionWorkWithWork(unionWork, (BaseWork)work, tezWork, context);
            } else {
                unionWork = context.rootUnionWorkMap.get(root);
                if (unionWork == null) {
                    unionWork = GenTezUtils.createUnionWork(context, root, operator, tezWork);
                    this.connectUnionWorkWithWork(unionWork, (BaseWork)work, tezWork, context);
                }
            }
            context.currentUnionOperators.clear();
            work = unionWork;
        }
        if (context.leafOperatorToFollowingWork.containsKey(operator)) {
            TezEdgeProperty edgeProp;
            BaseWork followingWork = context.leafOperatorToFollowingWork.get(operator);
            long l = context.conf.getLongVar(HiveConf.ConfVars.BYTESPERREDUCER);
            LOG.debug("Second pass. Leaf operator: " + operator + " has common downstream work: " + followingWork);
            if (operator instanceof DummyStoreOperator) {
                assert (followingWork instanceof MergeJoinWork);
                MergeJoinWork mergeJoinWork = (MergeJoinWork)followingWork;
                CommonMergeJoinOperator mergeJoinOp = mergeJoinWork.getMergeJoinOperator();
                ((BaseWork)work).setTag(mergeJoinOp.getTagForOperator(operator));
                mergeJoinWork.addMergedWork(null, (BaseWork)work, context.leafOperatorToFollowingWork);
                tezWork.setVertexType(mergeJoinWork, TezWork.VertexType.MULTI_INPUT_UNINITIALIZED_EDGES);
                for (BaseWork parentWork : tezWork.getParents((BaseWork)work)) {
                    edgeProp = tezWork.getEdgeProperty(parentWork, (BaseWork)work);
                    tezWork.disconnect(parentWork, (BaseWork)work);
                    tezWork.connect(parentWork, mergeJoinWork, edgeProp);
                }
                work = mergeJoinWork;
            } else {
                assert (operator instanceof ReduceSinkOperator && (followingWork instanceof ReduceWork || followingWork instanceof MergeJoinWork || followingWork instanceof UnionWork));
                ReduceSinkOperator rs = (ReduceSinkOperator)operator;
                ReduceWork rWork = null;
                if (followingWork instanceof MergeJoinWork) {
                    MergeJoinWork mergeJoinWork = (MergeJoinWork)followingWork;
                    rWork = (ReduceWork)mergeJoinWork.getMainWork();
                } else if (followingWork instanceof UnionWork) {
                    UnionWork unionWork = (UnionWork)followingWork;
                    int index = this.getFollowingWorkIndex(tezWork, unionWork, rs);
                    BaseWork baseWork = tezWork.getChildren(unionWork).get(index);
                    if (baseWork instanceof MergeJoinWork) {
                        MergeJoinWork mergeJoinWork = (MergeJoinWork)baseWork;
                        followingWork = mergeJoinWork;
                        rWork = (ReduceWork)mergeJoinWork.getMainWork();
                    } else {
                        rWork = (ReduceWork)baseWork;
                    }
                } else {
                    rWork = (ReduceWork)followingWork;
                }
                GenMapRedUtils.setKeyAndValueDesc(rWork, rs);
                int tag = ((ReduceSinkDesc)rs.getConf()).getTag();
                rWork.getTagToInput().put(tag == -1 ? 0 : tag, ((BaseWork)work).getName());
                ((ReduceSinkDesc)rs.getConf()).setOutputName(rWork.getName());
                MapJoinOperator mj = context.smallTableParentToMapJoinMap.get(rs);
                if (mj != null && context.mapJoinToUnprocessedSmallTableReduceSinks.get(mj).contains(rs)) {
                    ArrayList<Operator<? extends OperatorDesc>> tempMJParents = new ArrayList<Operator<? extends OperatorDesc>>();
                    tempMJParents.add(rs);
                    mj.setParentOperators(tempMJParents);
                    List<Operator<OperatorDesc>> rsChildren = rs.getChildOperators();
                    rsChildren.add(mj);
                    ReduceSinkMapJoinProc.processReduceSinkToHashJoin(rs, mj, context);
                    mj.removeParents();
                }
                if (!context.connectedReduceSinks.contains(rs)) {
                    TezEdgeProperty.EdgeType edgeType = GenTezUtils.determineEdgeType((BaseWork)work, followingWork, rs);
                    if (rWork.isAutoReduceParallelism()) {
                        edgeProp = new TezEdgeProperty(context.conf, edgeType, true, rWork.isSlowStart(), rWork.getMinReduceTasks(), rWork.getMaxReduceTasks(), l);
                    } else {
                        edgeProp = new TezEdgeProperty(edgeType);
                        edgeProp.setSlowStart(rWork.isSlowStart());
                    }
                    tezWork.connect((BaseWork)work, followingWork, edgeProp);
                    context.connectedReduceSinks.add(rs);
                }
            }
        } else {
            LOG.debug("First pass. Leaf operator: " + operator);
        }
        if (!operator.getChildOperators().isEmpty()) {
            assert (operator.getChildOperators().size() == 1);
            context.parentOfRoot = operator;
            context.currentRootOperator = operator.getChildOperators().get(0);
            context.preceedingWork = work;
        }
        return null;
    }

    private int getFollowingWorkIndex(TezWork tezWork, UnionWork unionWork, ReduceSinkOperator rs) throws SemanticException {
        int index = 0;
        for (BaseWork baseWork : tezWork.getChildren(unionWork)) {
            TezEdgeProperty edgeProperty = tezWork.getEdgeProperty(unionWork, baseWork);
            if (edgeProperty.getEdgeType() != TezEdgeProperty.EdgeType.CONTAINS) {
                return index;
            }
            ++index;
        }
        throw new SemanticException("Following work not found for the reduce sink: " + rs.getName());
    }

    private Operator<? extends OperatorDesc> getParentFromStack(Node currentMergeJoinOperator, Stack<Node> stack) {
        int pos = stack.indexOf(currentMergeJoinOperator);
        return (Operator)stack.get(pos - 1);
    }

    private void connectUnionWorkWithWork(UnionWork unionWork, BaseWork work, TezWork tezWork, GenTezProcContext context) {
        LOG.debug("Connecting union work (" + unionWork + ") with work (" + work + ")");
        TezEdgeProperty edgeProp = new TezEdgeProperty(TezEdgeProperty.EdgeType.CONTAINS);
        tezWork.connect(unionWork, work, edgeProp);
        unionWork.addUnionOperators(context.currentUnionOperators);
        context.workWithUnionOperators.add(work);
    }
}

