/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.Set;
import javax.annotation.Nullable;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTErrorUtils;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.dump.TableExport;
import org.apache.hadoop.hive.ql.plan.ExportWork;

public class ExportSemanticAnalyzer
extends BaseSemanticAnalyzer {
    private boolean isMmExport = false;

    ExportSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        Task<ExportWork> task = ExportSemanticAnalyzer.analyzeExport(ast, null, this.db, this.conf, this.inputs, this.outputs);
        this.isMmExport = task.getWork().getMmContext() != null;
        this.rootTasks.add(task);
    }

    static Task<ExportWork> analyzeExport(ASTNode ast, @Nullable String acidTableName, Hive db, HiveConf conf, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws SemanticException {
        BaseSemanticAnalyzer.TableSpec ts;
        Tree tableTree = ast.getChild(0);
        Tree toTree = ast.getChild(1);
        ReplicationSpec replicationSpec = ast.getChildCount() > 2 ? new ReplicationSpec((ASTNode)ast.getChild(2)) : new ReplicationSpec();
        if (replicationSpec.getCurrentReplicationState() == null) {
            try {
                long currentEventId = db.getMSC().getCurrentNotificationEventId().getEventId();
                replicationSpec.setCurrentReplicationState(String.valueOf(currentEventId));
            }
            catch (Exception e) {
                throw new SemanticException("Error when getting current notification event ID", (Throwable)e);
            }
        }
        try {
            ts = new BaseSemanticAnalyzer.TableSpec(db, conf, (ASTNode)tableTree, false, true);
        }
        catch (SemanticException sme) {
            if (!replicationSpec.isInReplicationScope()) {
                throw sme;
            }
            if (sme.getCause() instanceof InvalidTableException || sme instanceof Table.ValidationFailureSemanticException) {
                ts = null;
            }
            throw sme;
        }
        if (ts != null && (ts.tableHandle.isView() || ts.tableHandle.isMaterializedView())) {
            throw new SemanticException("Views and Materialized Views can not be exported.");
        }
        String tmpPath = ExportSemanticAnalyzer.stripQuotes(toTree.getText());
        TableExport.Paths exportPaths = new TableExport.Paths(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_PATH.getMsg(), (ASTNode)ast), tmpPath, conf, false);
        TableExport.AuthEntities authEntities = new TableExport(exportPaths, ts, replicationSpec, db, null, conf, null).getAuthEntities();
        inputs.addAll(authEntities.inputs);
        outputs.addAll(authEntities.outputs);
        String exportRootDirName = tmpPath;
        ExportWork.MmContext mmCtx = ExportWork.MmContext.createIfNeeded(ts == null ? null : ts.tableHandle);
        Utilities.FILE_OP_LOGGER.debug("Exporting table {}: MM context {}", (Object)(ts == null ? null : ts.getTableName()), (Object)mmCtx);
        ExportWork exportWork = new ExportWork(exportRootDirName, ts, replicationSpec, ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_PATH.getMsg(), (ASTNode)ast), acidTableName, mmCtx);
        return TaskFactory.get(exportWork);
    }

    @Override
    public boolean hasTransactionalInQuery() {
        return this.isMmExport;
    }
}

