/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TaskCompiler;
import org.apache.hadoop.hive.ql.parse.TaskCompilerFactory;
import org.apache.hadoop.hive.ql.parse.type.ExprNodeTypeCheck;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckCtx;
import org.apache.hadoop.hive.ql.plan.ExprDynamicParamDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.parquet.Preconditions;

@DDLSemanticAnalyzerFactory.DDLType(types={917})
public class ExecuteStatementAnalyzer
extends SemanticAnalyzer {
    public ExecuteStatementAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    private String getQueryName(ASTNode root) {
        ASTNode queryNameAST = (ASTNode)root.getChild(1);
        return queryNameAST.getText();
    }

    private <T> T makeCopy(Object task, Class<T> objClass) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SerializationUtilities.serializePlan(task, baos);
        return SerializationUtilities.deserializePlan(new ByteArrayInputStream(baos.toByteArray()), objClass);
    }

    private void createOperatorCopy(SemanticAnalyzer cachedPlan) {
        this.topOps = (Map)this.makeCopy(cachedPlan.topOpsCopy, cachedPlan.topOpsCopy.getClass());
    }

    private ExprNodeConstantDesc getConstant(ExprDynamicParamDesc dynamicExpr, TypeInfo typeInfo, Map<Integer, ASTNode> parameterMap) throws SemanticException {
        Preconditions.checkArgument((boolean)parameterMap.containsKey(dynamicExpr.getIndex()), (String)"Paramter index not found");
        ASTNode paramNode = parameterMap.get(dynamicExpr.getIndex());
        TypeCheckCtx typeCheckCtx = new TypeCheckCtx(null);
        ExprNodeDesc node = ExprNodeTypeCheck.genExprNode(paramNode, typeCheckCtx).get(paramNode);
        Preconditions.checkArgument((boolean)(node instanceof ExprNodeConstantDesc), (String)"Invalid expression created");
        return (ExprNodeConstantDesc)node;
    }

    private ExprNodeDesc replaceDynamicParamsWithConstant(ExprNodeDesc expr, TypeInfo typeInfo, Map<Integer, ASTNode> paramMap) throws SemanticException {
        if (expr.getChildren() == null || expr.getChildren().isEmpty()) {
            if (expr instanceof ExprDynamicParamDesc) {
                return this.getConstant((ExprDynamicParamDesc)expr, typeInfo, paramMap);
            }
            return expr;
        }
        for (ExprNodeDesc child : expr.getChildren()) {
            if (child instanceof ExprDynamicParamDesc || child.getTypeInfo() == TypeInfoFactory.voidTypeInfo) continue;
            typeInfo = child.getTypeInfo();
            break;
        }
        Preconditions.checkArgument((typeInfo != null ? 1 : 0) != 0, (String)"TypeInfo is null");
        ArrayList<ExprNodeDesc> exprList = new ArrayList<ExprNodeDesc>();
        for (ExprNodeDesc child : expr.getChildren()) {
            child = this.replaceDynamicParamsWithConstant(child, typeInfo, paramMap);
            exprList.add(child);
        }
        expr.getChildren().clear();
        expr.getChildren().addAll(exprList);
        return expr;
    }

    private void bindOperatorsWithDynamicParams(Map<Integer, ASTNode> parameterMap) throws SemanticException {
        Collection<Operator> allOps = this.getParseContext().getAllOps();
        for (Operator op : allOps) {
            switch (op.getType()) {
                case FILTER: {
                    FilterOperator filterOp = (FilterOperator)op;
                    ExprNodeDesc predicate = ((FilterDesc)filterOp.getConf()).getPredicate();
                    ((FilterDesc)filterOp.getConf()).setPredicate(this.replaceDynamicParamsWithConstant(predicate, (TypeInfo)TypeInfoFactory.booleanTypeInfo, parameterMap));
                }
            }
        }
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        SessionState ss = SessionState.get();
        Preconditions.checkNotNull((Object)ss, (String)"SessionState object must not be NULL");
        String queryName = this.getQueryName(root);
        if (ss.getPreparePlans().containsKey(queryName)) {
            SemanticAnalyzer cachedPlan = ss.getPreparePlans().get(queryName);
            this.createOperatorCopy(cachedPlan);
            Map<Integer, ASTNode> parameterMap = this.findParams(root);
            this.bindOperatorsWithDynamicParams(parameterMap);
            this.prepareQuery = false;
            String queryId = this.conf.getVar(HiveConf.ConfVars.HIVEQUERYID);
            this.conf.syncFromConf(cachedPlan.getQueryState().getConf());
            this.conf.setVar(HiveConf.ConfVars.HIVEQUERYID, queryId);
            this.inputs = cachedPlan.getInputs();
            this.outputs = cachedPlan.getOutputs();
            this.setLineageInfo(cachedPlan.getLineageInfo());
            this.setTableAccessInfo(cachedPlan.getTableAccessInfo());
            this.setColumnAccessInfo(cachedPlan.getColumnAccessInfo());
            this.idToTableNameMap = new HashMap<String, String>(cachedPlan.getIdToTableNameMap());
            this.queryProperties = cachedPlan.getQueryProperties();
            this.setAutoCommitValue(cachedPlan.getAutoCommitValue());
            this.transactionalInQuery = cachedPlan.hasTransactionalInQuery();
            this.acidFileSinks.addAll(cachedPlan.getAcidFileSinks());
            this.initCtx(cachedPlan.getCtx());
            this.ctx.setCboInfo(cachedPlan.getCboInfo());
            this.setLoadFileWork(cachedPlan.getLoadFileWork());
            this.setLoadTableWork(cachedPlan.getLoadTableWork());
            this.setQB(cachedPlan.getQB());
            ParseContext pctxt = this.getParseContext();
            PartitionPruner ppr = new PartitionPruner();
            ((Transform)ppr).transform(pctxt);
            if (!this.ctx.getExplainLogical()) {
                TaskCompiler compiler = TaskCompilerFactory.getCompiler(this.conf, pctxt);
                compiler.init(this.queryState, this.console, this.db);
                compiler.compile(pctxt, this.rootTasks, this.inputs, this.outputs);
                this.fetchTask = pctxt.getFetchTask();
            }
        } else {
            throw new SemanticException("No existing plan found for the execute statement. Please make sure to add one using prepare");
        }
    }

    private Map<Integer, ASTNode> findParams(ASTNode executeRoot) {
        Preconditions.checkArgument((executeRoot.getType() == 917 ? 1 : 0) != 0, (String)"Unexpected ASTNode type");
        ASTNode executeParamList = (ASTNode)executeRoot.getChildren().get(0);
        Preconditions.checkArgument((executeParamList.getType() == 919 ? 1 : 0) != 0, (String)"Unexpected execute parameter type");
        HashMap<Integer, ASTNode> paramMap = new HashMap<Integer, ASTNode>();
        int idx = 0;
        for (int i = 0; i < executeParamList.getChildCount(); ++i) {
            ASTNode param = (ASTNode)executeParamList.getChild(i);
            paramMap.put(++idx, param);
        }
        return paramMap;
    }

    private class PlanCopy {
        FetchTask fetchTask;
        List<Task<?>> tasks;

        PlanCopy(FetchTask fetchTask, List<Task<?>> tasks) {
            this.fetchTask = fetchTask;
            this.tasks = tasks;
        }

        FetchTask getFetchTask() {
            return this.fetchTask;
        }

        List<Task<?>> getTasks() {
            return this.tasks;
        }
    }
}

