/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.VariableSubstitution;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AnalyzeCommandUtils;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnStatsAutoGatherContext;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.QBParseInfo;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.ColStatsProcessor;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnStatsSemanticAnalyzer
extends SemanticAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnStatsSemanticAnalyzer.class);
    private static final SessionState.LogHelper CONSOLE = new SessionState.LogHelper(LOG);
    private ASTNode originalTree;
    private ASTNode rewrittenTree;
    private String rewrittenQuery;
    private Context ctx;
    private boolean isRewritten;
    private boolean isTableLevel;
    private List<String> colNames;
    private List<String> colType;
    private Table tbl;

    public ColumnStatsSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    private boolean shouldRewrite(ASTNode tree) {
        ASTNode child1;
        ASTNode child0;
        boolean rwt = false;
        if (tree.getChildCount() > 1 && (child0 = (ASTNode)tree.getChild(0)).getToken().getType() == 1133 && (child0 = (ASTNode)child0.getChild(0)).getToken().getType() == 1162 && (child1 = (ASTNode)tree.getChild(1)).getToken().getType() == 69) {
            rwt = true;
        }
        return rwt;
    }

    private List<String> getColumnName(ASTNode tree) throws SemanticException {
        switch (tree.getChildCount()) {
            case 2: {
                return Utilities.getColumnNamesFromFieldSchema(this.tbl.getCols());
            }
            case 3: {
                int numCols = tree.getChild(2).getChildCount();
                ArrayList<String> colName = new ArrayList<String>(numCols);
                for (int i = 0; i < numCols; ++i) {
                    colName.add(ColumnStatsSemanticAnalyzer.getUnescapedName((ASTNode)tree.getChild(2).getChild(i)));
                }
                return colName;
            }
        }
        throw new SemanticException("Internal error. Expected number of children of ASTNode to be either 2 or 3. Found : " + tree.getChildCount());
    }

    private void handlePartialPartitionSpec(Map<String, String> partSpec, ColumnStatsAutoGatherContext context) throws SemanticException {
        int partValsSpecified = 0;
        for (String partKey : partSpec.keySet()) {
            partValsSpecified += partSpec.get(partKey) == null ? 0 : 1;
        }
        try {
            if (context == null && partValsSpecified == this.tbl.getPartitionKeys().size() && this.db.getPartition(this.tbl, partSpec, false, null, false) == null) {
                throw new SemanticException(ErrorMsg.COLUMNSTATSCOLLECTOR_INVALID_PARTITION.getMsg() + " : " + partSpec);
            }
        }
        catch (HiveException he) {
            throw new SemanticException(ErrorMsg.COLUMNSTATSCOLLECTOR_INVALID_PARTITION.getMsg() + " : " + partSpec);
        }
        List<String> partKeys = Utilities.getColumnNamesFromFieldSchema(this.tbl.getPartitionKeys());
        for (String partKey : partKeys) {
            if (partSpec.containsKey(partKey)) continue;
            partSpec.put(partKey, null);
        }
        for (String partKey : partSpec.keySet()) {
            if (partKeys.contains(partKey)) continue;
            throw new SemanticException(ErrorMsg.COLUMNSTATSCOLLECTOR_INVALID_PART_KEY.getMsg() + " : " + partKey);
        }
    }

    private static StringBuilder genPartitionClause(Table tbl, Map<String, String> partSpec, HiveConf conf) throws SemanticException {
        StringBuilder whereClause = new StringBuilder(" where ");
        boolean predPresent = false;
        StringBuilder groupByClause = new StringBuilder(" group by ");
        boolean aggPresent = false;
        for (Map.Entry<String, String> part : partSpec.entrySet()) {
            String value = part.getValue();
            if (value == null) continue;
            if (!predPresent) {
                predPresent = true;
            } else {
                whereClause.append(" and ");
            }
            whereClause.append(HiveUtils.unparseIdentifier(part.getKey(), (Configuration)conf)).append(" = ").append(ColumnStatsSemanticAnalyzer.genPartValueString(ColumnStatsSemanticAnalyzer.getColTypeOf(tbl, part.getKey()), value));
        }
        for (FieldSchema fs : tbl.getPartitionKeys()) {
            if (!aggPresent) {
                aggPresent = true;
            } else {
                groupByClause.append(',');
            }
            groupByClause.append(HiveUtils.unparseIdentifier(fs.getName(), (Configuration)conf));
        }
        return predPresent ? whereClause.append((CharSequence)groupByClause) : groupByClause;
    }

    private static String getColTypeOf(Table tbl, String partKey) throws SemanticException {
        for (FieldSchema fs : tbl.getPartitionKeys()) {
            if (!partKey.equalsIgnoreCase(fs.getName())) continue;
            return fs.getType().toLowerCase();
        }
        throw new SemanticException("Unknown partition key : " + partKey);
    }

    protected static List<String> getColumnTypes(Table tbl, List<String> colNames) {
        ArrayList<String> colTypes = new ArrayList<String>();
        List<FieldSchema> cols = tbl.getCols();
        ArrayList<String> copyColNames = new ArrayList<String>(colNames);
        for (String colName : copyColNames) {
            for (FieldSchema col : cols) {
                if (!colName.equalsIgnoreCase(col.getName())) continue;
                String type = col.getType();
                TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)type);
                if (typeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE) {
                    ColumnStatsSemanticAnalyzer.logTypeWarning(colName, type);
                    colNames.remove(colName);
                    continue;
                }
                colTypes.add(type);
            }
        }
        return colTypes;
    }

    private String genRewrittenQuery(List<String> colNames, List<String> colTypes, HiveConf conf, Map<String, String> partSpec, boolean isPartitionStats) throws SemanticException {
        String rewritten = ColumnStatsSemanticAnalyzer.genRewrittenQuery(this.tbl, colNames, colTypes, conf, partSpec, isPartitionStats, false);
        this.isRewritten = true;
        return rewritten;
    }

    protected static String genRewrittenQuery(Table tbl, HiveConf conf, Map<String, String> partSpec, boolean isPartitionStats, boolean useTableValues) throws SemanticException {
        List<String> colNames = Utilities.getColumnNamesFromFieldSchema(tbl.getCols());
        List<String> colTypes = ColumnStatsSemanticAnalyzer.getColumnTypes(tbl, colNames);
        return ColumnStatsSemanticAnalyzer.genRewrittenQuery(tbl, colNames, colTypes, conf, partSpec, isPartitionStats, useTableValues);
    }

    private static String genRewrittenQuery(Table tbl, List<String> colNames, List<String> colTypes, HiveConf conf, Map<String, String> partSpec, boolean isPartitionStats, boolean useTableValues) throws SemanticException {
        StringBuilder rewrittenQueryBuilder = new StringBuilder("select ");
        StringBuilder columnNamesBuilder = new StringBuilder();
        StringBuilder columnDummyValuesBuilder = new StringBuilder();
        for (int i = 0; i < colNames.size(); ++i) {
            if (i > 0) {
                rewrittenQueryBuilder.append(" , ");
                columnNamesBuilder.append(" , ");
                columnDummyValuesBuilder.append(" , ");
            }
            String columnName = HiveUtils.unparseIdentifier(colNames.get(i), (Configuration)conf);
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)colTypes.get(i));
            ColumnStatsSemanticAnalyzer.genComputeStats(rewrittenQueryBuilder, conf, i, columnName, typeInfo);
            columnNamesBuilder.append(HiveUtils.unparseIdentifier(columnName, (Configuration)conf));
            columnDummyValuesBuilder.append("cast(null as " + typeInfo.toString() + ")");
        }
        if (isPartitionStats) {
            for (FieldSchema fs : tbl.getPartCols()) {
                String identifier = HiveUtils.unparseIdentifier(fs.getName(), (Configuration)conf);
                rewrittenQueryBuilder.append(" , ").append(identifier);
                columnNamesBuilder.append(" , ").append(identifier);
                columnDummyValuesBuilder.append(" , cast(null as ").append(TypeInfoUtils.getTypeInfoFromTypeString((String)fs.getType()).toString()).append(")");
            }
        }
        rewrittenQueryBuilder.append(" from ");
        if (useTableValues) {
            rewrittenQueryBuilder.append("table(values(");
            rewrittenQueryBuilder.append(columnDummyValuesBuilder.toString());
            rewrittenQueryBuilder.append(")) as ");
            rewrittenQueryBuilder.append(HiveUtils.unparseIdentifier(tbl.getTableName(), (Configuration)conf));
            rewrittenQueryBuilder.append("(");
            rewrittenQueryBuilder.append(columnNamesBuilder.toString());
            rewrittenQueryBuilder.append(")");
        } else {
            rewrittenQueryBuilder.append(HiveUtils.unparseIdentifier(tbl.getDbName(), (Configuration)conf));
            rewrittenQueryBuilder.append(".");
            rewrittenQueryBuilder.append(HiveUtils.unparseIdentifier(tbl.getTableName(), (Configuration)conf));
        }
        if (isPartitionStats) {
            rewrittenQueryBuilder.append((CharSequence)ColumnStatsSemanticAnalyzer.genPartitionClause(tbl, partSpec, conf));
        }
        String rewrittenQuery = rewrittenQueryBuilder.toString();
        rewrittenQuery = new VariableSubstitution(() -> SessionState.get().getHiveVariables()).substitute(conf, rewrittenQuery);
        return rewrittenQuery;
    }

    private static void genComputeStats(StringBuilder rewrittenQueryBuilder, HiveConf conf, int pos, String columnName, TypeInfo typeInfo) throws SemanticException {
        Preconditions.checkArgument((typeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE ? 1 : 0) != 0);
        ColStatsProcessor.ColumnStatsType columnStatsType = ColStatsProcessor.ColumnStatsType.getColumnStatsType((PrimitiveTypeInfo)typeInfo);
        for (int i = 0; i < columnStatsType.getColumnStats().size(); ++i) {
            if (i > 0) {
                rewrittenQueryBuilder.append(", ");
            }
            ColStatsProcessor.ColumnStatsField columnStatsField = columnStatsType.getColumnStats().get(i);
            ColumnStatsSemanticAnalyzer.appendStatsField(rewrittenQueryBuilder, conf, columnStatsField, columnStatsType, columnName, pos);
        }
    }

    private static void appendStatsField(StringBuilder rewrittenQueryBuilder, HiveConf conf, ColStatsProcessor.ColumnStatsField columnStatsField, ColStatsProcessor.ColumnStatsType columnStatsType, String columnName, int pos) throws SemanticException {
        switch (columnStatsField) {
            case COLUMN_STATS_TYPE: {
                ColumnStatsSemanticAnalyzer.appendColumnType(rewrittenQueryBuilder, conf, columnStatsType, pos);
                break;
            }
            case COUNT_TRUES: {
                ColumnStatsSemanticAnalyzer.appendCountTrues(rewrittenQueryBuilder, conf, columnName, pos);
                break;
            }
            case COUNT_FALSES: {
                ColumnStatsSemanticAnalyzer.appendCountFalses(rewrittenQueryBuilder, conf, columnName, pos);
                break;
            }
            case COUNT_NULLS: {
                ColumnStatsSemanticAnalyzer.appendCountNulls(rewrittenQueryBuilder, conf, columnName, pos);
                break;
            }
            case MIN: {
                ColumnStatsSemanticAnalyzer.appendMin(rewrittenQueryBuilder, conf, columnStatsType, columnName, pos);
                break;
            }
            case MAX: {
                ColumnStatsSemanticAnalyzer.appendMax(rewrittenQueryBuilder, conf, columnStatsType, columnName, pos);
                break;
            }
            case NDV: {
                ColumnStatsSemanticAnalyzer.appendNDV(rewrittenQueryBuilder, conf, columnName, pos);
                break;
            }
            case BITVECTOR: {
                ColumnStatsSemanticAnalyzer.appendBitVector(rewrittenQueryBuilder, conf, columnName, pos);
                break;
            }
            case MAX_LENGTH: {
                ColumnStatsSemanticAnalyzer.appendMaxLength(rewrittenQueryBuilder, conf, columnName, pos);
                break;
            }
            case AVG_LENGTH: {
                ColumnStatsSemanticAnalyzer.appendAvgLength(rewrittenQueryBuilder, conf, columnName, pos);
                break;
            }
            default: {
                throw new SemanticException("Not supported field " + (Object)((Object)columnStatsField));
            }
        }
    }

    private static void appendColumnType(StringBuilder rewrittenQueryBuilder, HiveConf conf, ColStatsProcessor.ColumnStatsType columnStatsType, int pos) {
        rewrittenQueryBuilder.append("'").append(columnStatsType.toString()).append("' AS ").append(HiveUtils.unparseIdentifier(ColStatsProcessor.ColumnStatsField.COLUMN_STATS_TYPE.getFieldName() + pos, (Configuration)conf));
    }

    private static void appendMin(StringBuilder rewrittenQueryBuilder, HiveConf conf, ColStatsProcessor.ColumnStatsType columnStatsType, String columnName, int pos) {
        switch (columnStatsType) {
            case LONG: {
                rewrittenQueryBuilder.append("CAST(min(").append(columnName).append(") AS bigint) AS ");
                break;
            }
            case DOUBLE: {
                rewrittenQueryBuilder.append("CAST(min(").append(columnName).append(") AS double) AS ");
                break;
            }
            default: {
                rewrittenQueryBuilder.append("min(").append(columnName).append(") AS ");
            }
        }
        rewrittenQueryBuilder.append(HiveUtils.unparseIdentifier(ColStatsProcessor.ColumnStatsField.MIN.getFieldName() + pos, (Configuration)conf));
    }

    private static void appendMax(StringBuilder rewrittenQueryBuilder, HiveConf conf, ColStatsProcessor.ColumnStatsType columnStatsType, String columnName, int pos) {
        switch (columnStatsType) {
            case LONG: {
                rewrittenQueryBuilder.append("CAST(max(").append(columnName).append(") AS bigint) AS ");
                break;
            }
            case DOUBLE: {
                rewrittenQueryBuilder.append("CAST(max(").append(columnName).append(") AS double) AS ");
                break;
            }
            default: {
                rewrittenQueryBuilder.append("max(").append(columnName).append(") AS ");
            }
        }
        rewrittenQueryBuilder.append(HiveUtils.unparseIdentifier(ColStatsProcessor.ColumnStatsField.MAX.getFieldName() + pos, (Configuration)conf));
    }

    private static void appendMaxLength(StringBuilder rewrittenQueryBuilder, HiveConf conf, String columnName, int pos) {
        rewrittenQueryBuilder.append("CAST(COALESCE(max(LENGTH(").append(columnName).append(")), 0) AS bigint) AS ").append(HiveUtils.unparseIdentifier(ColStatsProcessor.ColumnStatsField.MAX_LENGTH.getFieldName() + pos, (Configuration)conf));
    }

    private static void appendAvgLength(StringBuilder rewrittenQueryBuilder, HiveConf conf, String columnName, int pos) {
        rewrittenQueryBuilder.append("CAST(COALESCE(avg(COALESCE(LENGTH(").append(columnName).append("), 0)), 0) AS double) AS ").append(HiveUtils.unparseIdentifier(ColStatsProcessor.ColumnStatsField.AVG_LENGTH.getFieldName() + pos, (Configuration)conf));
    }

    private static void appendCountNulls(StringBuilder rewrittenQueryBuilder, HiveConf conf, String columnName, int pos) {
        rewrittenQueryBuilder.append("CAST(count(1) - count(").append(columnName).append(") AS bigint) AS ").append(HiveUtils.unparseIdentifier(ColStatsProcessor.ColumnStatsField.COUNT_NULLS.getFieldName() + pos, (Configuration)conf));
    }

    private static void appendNDV(StringBuilder rewrittenQueryBuilder, HiveConf conf, String columnName, int pos) throws SemanticException {
        rewrittenQueryBuilder.append("COALESCE(NDV_COMPUTE_BIT_VECTOR(");
        ColumnStatsSemanticAnalyzer.appendBitVector(rewrittenQueryBuilder, conf, columnName);
        rewrittenQueryBuilder.append("), 0) AS ").append(HiveUtils.unparseIdentifier(ColStatsProcessor.ColumnStatsField.NDV.getFieldName() + pos, (Configuration)conf));
    }

    private static void appendBitVector(StringBuilder rewrittenQueryBuilder, HiveConf conf, String columnName, int pos) throws SemanticException {
        ColumnStatsSemanticAnalyzer.appendBitVector(rewrittenQueryBuilder, conf, columnName);
        rewrittenQueryBuilder.append(" AS ").append(HiveUtils.unparseIdentifier(ColStatsProcessor.ColumnStatsField.BITVECTOR.getFieldName() + pos, (Configuration)conf));
    }

    private static void appendBitVector(StringBuilder rewrittenQueryBuilder, HiveConf conf, String columnName) throws SemanticException {
        String func = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_NDV_ALGO).toLowerCase();
        if ("hll".equals(func)) {
            rewrittenQueryBuilder.append("compute_bit_vector_hll(").append(columnName).append(")");
        } else if ("fm".equals(func)) {
            int numBitVectors;
            try {
                numBitVectors = HiveStatsUtils.getNumBitVectorsForNDVEstimation((Configuration)conf);
            }
            catch (Exception e) {
                throw new SemanticException(e.getMessage());
            }
            rewrittenQueryBuilder.append("compute_bit_vector_fm(").append(columnName).append(", ").append(numBitVectors).append(")");
        } else {
            throw new UDFArgumentException("available ndv computation options are hll and fm. Got: " + func);
        }
    }

    private static void appendCountTrues(StringBuilder rewrittenQueryBuilder, HiveConf conf, String columnName, int pos) {
        rewrittenQueryBuilder.append("CAST(count(CASE WHEN ").append(columnName).append(" IS TRUE THEN 1 ELSE null END) AS bigint) AS ").append(HiveUtils.unparseIdentifier(ColStatsProcessor.ColumnStatsField.COUNT_TRUES.getFieldName() + pos, (Configuration)conf));
    }

    private static void appendCountFalses(StringBuilder rewrittenQueryBuilder, HiveConf conf, String columnName, int pos) {
        rewrittenQueryBuilder.append("CAST(count(CASE WHEN ").append(columnName).append(" IS FALSE THEN 1 ELSE null END) AS bigint) AS ").append(HiveUtils.unparseIdentifier(ColStatsProcessor.ColumnStatsField.COUNT_FALSES.getFieldName() + pos, (Configuration)conf));
    }

    private ASTNode genRewrittenTree(String rewrittenQuery) throws SemanticException {
        this.ctx = new Context((Configuration)this.conf);
        this.ctx.setCmd(rewrittenQuery);
        this.ctx.setHDFSCleanup(true);
        try {
            return ParseUtils.parse(rewrittenQuery, this.ctx);
        }
        catch (ParseException e) {
            throw new SemanticException(ErrorMsg.COLUMNSTATSCOLLECTOR_PARSE_ERROR.getMsg());
        }
    }

    private void validateSpecifiedColumnNames(List<String> specifiedCols) throws SemanticException {
        List<String> tableCols = Utilities.getColumnNamesFromFieldSchema(this.tbl.getCols());
        for (String sc : specifiedCols) {
            if (tableCols.contains(sc.toLowerCase())) continue;
            String msg = "'" + sc + "' (possible columns are " + tableCols.toString() + ")";
            throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(msg));
        }
    }

    private void checkForPartitionColumns(List<String> specifiedCols, List<String> partCols) throws SemanticException {
        for (String pc : partCols) {
            for (String sc : specifiedCols) {
                if (!pc.equalsIgnoreCase(sc)) continue;
                throw new SemanticException(ErrorMsg.COLUMNSTATSCOLLECTOR_INVALID_COLUMN.getMsg() + " [Try removing column '" + sc + "' from column list]");
            }
        }
    }

    private static void logTypeWarning(String colName, String colType) {
        String warning = "Only primitive type arguments are accepted but " + colType + " is passed for " + colName + ".";
        warning = "WARNING: " + warning;
        CONSOLE.printInfo(warning);
    }

    @Override
    public void analyze(ASTNode ast, Context origCtx) throws SemanticException {
        this.init(true);
        super.processNoScanCommand(ast);
        if (this.shouldRewrite(ast)) {
            this.tbl = AnalyzeCommandUtils.getTable(ast, this);
            this.colNames = this.getColumnName(ast);
            this.originalTree = ast;
            boolean isPartitionStats = AnalyzeCommandUtils.isPartitionLevelStats(ast);
            Map<String, String> partSpec = null;
            this.checkForPartitionColumns(this.colNames, Utilities.getColumnNamesFromFieldSchema(this.tbl.getPartitionKeys()));
            this.validateSpecifiedColumnNames(this.colNames);
            if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_COLLECT_PART_LEVEL_STATS) && this.tbl.isPartitioned()) {
                isPartitionStats = true;
            }
            if (isPartitionStats) {
                this.isTableLevel = false;
                partSpec = AnalyzeCommandUtils.getPartKeyValuePairsFromAST(this.tbl, ast, this.conf);
                this.handlePartialPartitionSpec(partSpec, null);
            } else {
                this.isTableLevel = true;
            }
            this.colType = ColumnStatsSemanticAnalyzer.getColumnTypes(this.tbl, this.colNames);
            this.rewrittenQuery = this.genRewrittenQuery(this.colNames, this.colType, this.conf, partSpec, isPartitionStats);
            this.rewrittenTree = this.genRewrittenTree(this.rewrittenQuery);
        } else {
            this.originalTree = this.rewrittenTree = ast;
            this.rewrittenQuery = null;
            this.isRewritten = false;
        }
        if (this.isRewritten) {
            QB qb = this.getQB();
            qb.setAnalyzeRewrite(true);
            QBParseInfo qbp = qb.getParseInfo();
            this.analyzeRewrite = new BaseSemanticAnalyzer.AnalyzeRewriteContext();
            this.analyzeRewrite.setTableName(this.tbl.getFullyQualifiedName());
            this.analyzeRewrite.setTblLvl(this.isTableLevel);
            this.analyzeRewrite.setColName(this.colNames);
            this.analyzeRewrite.setColType(this.colType);
            qbp.setAnalyzeRewrite(this.analyzeRewrite);
            origCtx.addSubContext(this.ctx);
            this.initCtx(this.ctx);
            this.ctx.setExplainConfig(origCtx.getExplainConfig());
            LOG.info("Invoking analyze on rewritten query");
            this.analyzeInternal(this.rewrittenTree);
            this.queryState.setCommandType(HiveOperation.ANALYZE_TABLE);
        } else {
            this.initCtx(origCtx);
            LOG.info("Invoking analyze on original query");
            this.analyzeInternal(this.originalTree);
        }
    }

    public ASTNode rewriteAST(ASTNode ast, ColumnStatsAutoGatherContext context) throws SemanticException {
        this.originalTree = ast;
        this.tbl = AnalyzeCommandUtils.getTable(ast, this);
        this.colNames = this.getColumnName(ast);
        boolean isPartitionStats = AnalyzeCommandUtils.isPartitionLevelStats(ast);
        Map<String, String> partSpec = null;
        this.checkForPartitionColumns(this.colNames, Utilities.getColumnNamesFromFieldSchema(this.tbl.getPartitionKeys()));
        this.validateSpecifiedColumnNames(this.colNames);
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_COLLECT_PART_LEVEL_STATS) && this.tbl.isPartitioned()) {
            isPartitionStats = true;
        }
        if (isPartitionStats) {
            partSpec = AnalyzeCommandUtils.getPartKeyValuePairsFromAST(this.tbl, ast, this.conf);
            this.handlePartialPartitionSpec(partSpec, context);
        }
        this.colType = ColumnStatsSemanticAnalyzer.getColumnTypes(this.tbl, this.colNames);
        this.isTableLevel = !isPartitionStats;
        this.rewrittenQuery = this.genRewrittenQuery(this.colNames, this.colType, this.conf, partSpec, isPartitionStats);
        this.rewrittenTree = this.genRewrittenTree(this.rewrittenQuery);
        return this.rewrittenTree;
    }

    BaseSemanticAnalyzer.AnalyzeRewriteContext getAnalyzeRewriteContext() {
        BaseSemanticAnalyzer.AnalyzeRewriteContext analyzeRewrite = new BaseSemanticAnalyzer.AnalyzeRewriteContext();
        analyzeRewrite.setTableName(this.tbl.getFullyQualifiedName());
        analyzeRewrite.setTblLvl(this.isTableLevel);
        analyzeRewrite.setColName(this.colNames);
        analyzeRewrite.setColType(this.colType);
        return analyzeRewrite;
    }

    static BaseSemanticAnalyzer.AnalyzeRewriteContext genAnalyzeRewriteContext(HiveConf conf, Table tbl) {
        BaseSemanticAnalyzer.AnalyzeRewriteContext analyzeRewrite = new BaseSemanticAnalyzer.AnalyzeRewriteContext();
        analyzeRewrite.setTableName(tbl.getFullyQualifiedName());
        analyzeRewrite.setTblLvl(!conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_COLLECT_PART_LEVEL_STATS) || !tbl.isPartitioned());
        List<String> colNames = Utilities.getColumnNamesFromFieldSchema(tbl.getCols());
        List<String> colTypes = ColumnStatsSemanticAnalyzer.getColumnTypes(tbl, colNames);
        analyzeRewrite.setColName(colNames);
        analyzeRewrite.setColType(colTypes);
        return analyzeRewrite;
    }
}

